/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.AbstractCallAttribute;
import com.oracle.bmc.dataconnectivity.model.Connection;
import com.oracle.bmc.dataconnectivity.model.DataAsset;
import com.oracle.bmc.dataconnectivity.model.Schema;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class BipCallAttribute
extends AbstractCallAttribute {
    @JsonProperty(value="stagingBucket")
    private final Schema stagingBucket;
    @JsonProperty(value="offsetParameter")
    private final String offsetParameter;
    @JsonProperty(value="fetchNextRowsParameter")
    private final String fetchNextRowsParameter;
    @JsonProperty(value="stagingDataAsset")
    private final DataAsset stagingDataAsset;
    @JsonProperty(value="stagingConnection")
    private final Connection stagingConnection;
    @JsonProperty(value="stagingPrefix")
    private final String stagingPrefix;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public BipCallAttribute(Schema stagingBucket, String offsetParameter, String fetchNextRowsParameter, DataAsset stagingDataAsset, Connection stagingConnection, String stagingPrefix) {
        this.stagingBucket = stagingBucket;
        this.offsetParameter = offsetParameter;
        this.fetchNextRowsParameter = fetchNextRowsParameter;
        this.stagingDataAsset = stagingDataAsset;
        this.stagingConnection = stagingConnection;
        this.stagingPrefix = stagingPrefix;
    }

    public Schema getStagingBucket() {
        return this.stagingBucket;
    }

    public String getOffsetParameter() {
        return this.offsetParameter;
    }

    public String getFetchNextRowsParameter() {
        return this.fetchNextRowsParameter;
    }

    public DataAsset getStagingDataAsset() {
        return this.stagingDataAsset;
    }

    public Connection getStagingConnection() {
        return this.stagingConnection;
    }

    public String getStagingPrefix() {
        return this.stagingPrefix;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BipCallAttribute(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", stagingBucket=").append(String.valueOf((Object)this.stagingBucket));
        sb.append(", offsetParameter=").append(String.valueOf(this.offsetParameter));
        sb.append(", fetchNextRowsParameter=").append(String.valueOf(this.fetchNextRowsParameter));
        sb.append(", stagingDataAsset=").append(String.valueOf((Object)this.stagingDataAsset));
        sb.append(", stagingConnection=").append(String.valueOf((Object)this.stagingConnection));
        sb.append(", stagingPrefix=").append(String.valueOf(this.stagingPrefix));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BipCallAttribute)) {
            return false;
        }
        BipCallAttribute other = (BipCallAttribute)((Object)o);
        return Objects.equals((Object)this.stagingBucket, (Object)other.stagingBucket) && Objects.equals(this.offsetParameter, other.offsetParameter) && Objects.equals(this.fetchNextRowsParameter, other.fetchNextRowsParameter) && Objects.equals((Object)this.stagingDataAsset, (Object)other.stagingDataAsset) && Objects.equals((Object)this.stagingConnection, (Object)other.stagingConnection) && Objects.equals(this.stagingPrefix, other.stagingPrefix) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.stagingBucket == null ? 43 : this.stagingBucket.hashCode());
        result = result * 59 + (this.offsetParameter == null ? 43 : this.offsetParameter.hashCode());
        result = result * 59 + (this.fetchNextRowsParameter == null ? 43 : this.fetchNextRowsParameter.hashCode());
        result = result * 59 + (this.stagingDataAsset == null ? 43 : this.stagingDataAsset.hashCode());
        result = result * 59 + (this.stagingConnection == null ? 43 : this.stagingConnection.hashCode());
        result = result * 59 + (this.stagingPrefix == null ? 43 : this.stagingPrefix.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="stagingBucket")
        private Schema stagingBucket;
        @JsonProperty(value="offsetParameter")
        private String offsetParameter;
        @JsonProperty(value="fetchNextRowsParameter")
        private String fetchNextRowsParameter;
        @JsonProperty(value="stagingDataAsset")
        private DataAsset stagingDataAsset;
        @JsonProperty(value="stagingConnection")
        private Connection stagingConnection;
        @JsonProperty(value="stagingPrefix")
        private String stagingPrefix;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder stagingBucket(Schema stagingBucket) {
            this.stagingBucket = stagingBucket;
            this.__explicitlySet__.add("stagingBucket");
            return this;
        }

        public Builder offsetParameter(String offsetParameter) {
            this.offsetParameter = offsetParameter;
            this.__explicitlySet__.add("offsetParameter");
            return this;
        }

        public Builder fetchNextRowsParameter(String fetchNextRowsParameter) {
            this.fetchNextRowsParameter = fetchNextRowsParameter;
            this.__explicitlySet__.add("fetchNextRowsParameter");
            return this;
        }

        public Builder stagingDataAsset(DataAsset stagingDataAsset) {
            this.stagingDataAsset = stagingDataAsset;
            this.__explicitlySet__.add("stagingDataAsset");
            return this;
        }

        public Builder stagingConnection(Connection stagingConnection) {
            this.stagingConnection = stagingConnection;
            this.__explicitlySet__.add("stagingConnection");
            return this;
        }

        public Builder stagingPrefix(String stagingPrefix) {
            this.stagingPrefix = stagingPrefix;
            this.__explicitlySet__.add("stagingPrefix");
            return this;
        }

        public BipCallAttribute build() {
            BipCallAttribute model = new BipCallAttribute(this.stagingBucket, this.offsetParameter, this.fetchNextRowsParameter, this.stagingDataAsset, this.stagingConnection, this.stagingPrefix);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BipCallAttribute model) {
            if (model.wasPropertyExplicitlySet("stagingBucket")) {
                this.stagingBucket(model.getStagingBucket());
            }
            if (model.wasPropertyExplicitlySet("offsetParameter")) {
                this.offsetParameter(model.getOffsetParameter());
            }
            if (model.wasPropertyExplicitlySet("fetchNextRowsParameter")) {
                this.fetchNextRowsParameter(model.getFetchNextRowsParameter());
            }
            if (model.wasPropertyExplicitlySet("stagingDataAsset")) {
                this.stagingDataAsset(model.getStagingDataAsset());
            }
            if (model.wasPropertyExplicitlySet("stagingConnection")) {
                this.stagingConnection(model.getStagingConnection());
            }
            if (model.wasPropertyExplicitlySet("stagingPrefix")) {
                this.stagingPrefix(model.getStagingPrefix());
            }
            return this;
        }
    }
}

