/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Attribute
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="isSensitive")
    private final Boolean isSensitive;
    @JsonProperty(value="isMandatory")
    private final Boolean isMandatory;
    @JsonProperty(value="isGenerated")
    private final Boolean isGenerated;
    @JsonProperty(value="isBase64Encoded")
    private final Boolean isBase64Encoded;
    @JsonProperty(value="validKeyList")
    private final List<String> validKeyList;
    @JsonProperty(value="attributeType")
    private final String attributeType;

    @Deprecated
    @ConstructorProperties(value={"name", "isSensitive", "isMandatory", "isGenerated", "isBase64Encoded", "validKeyList", "attributeType"})
    public Attribute(String name, Boolean isSensitive, Boolean isMandatory, Boolean isGenerated, Boolean isBase64Encoded, List<String> validKeyList, String attributeType) {
        this.name = name;
        this.isSensitive = isSensitive;
        this.isMandatory = isMandatory;
        this.isGenerated = isGenerated;
        this.isBase64Encoded = isBase64Encoded;
        this.validKeyList = validKeyList;
        this.attributeType = attributeType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Boolean getIsSensitive() {
        return this.isSensitive;
    }

    public Boolean getIsMandatory() {
        return this.isMandatory;
    }

    public Boolean getIsGenerated() {
        return this.isGenerated;
    }

    public Boolean getIsBase64Encoded() {
        return this.isBase64Encoded;
    }

    public List<String> getValidKeyList() {
        return this.validKeyList;
    }

    public String getAttributeType() {
        return this.attributeType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Attribute(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", isSensitive=").append(String.valueOf(this.isSensitive));
        sb.append(", isMandatory=").append(String.valueOf(this.isMandatory));
        sb.append(", isGenerated=").append(String.valueOf(this.isGenerated));
        sb.append(", isBase64Encoded=").append(String.valueOf(this.isBase64Encoded));
        sb.append(", validKeyList=").append(String.valueOf(this.validKeyList));
        sb.append(", attributeType=").append(String.valueOf(this.attributeType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.isSensitive, other.isSensitive) && Objects.equals(this.isMandatory, other.isMandatory) && Objects.equals(this.isGenerated, other.isGenerated) && Objects.equals(this.isBase64Encoded, other.isBase64Encoded) && Objects.equals(this.validKeyList, other.validKeyList) && Objects.equals(this.attributeType, other.attributeType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.isSensitive == null ? 43 : this.isSensitive.hashCode());
        result = result * 59 + (this.isMandatory == null ? 43 : this.isMandatory.hashCode());
        result = result * 59 + (this.isGenerated == null ? 43 : this.isGenerated.hashCode());
        result = result * 59 + (this.isBase64Encoded == null ? 43 : this.isBase64Encoded.hashCode());
        result = result * 59 + (this.validKeyList == null ? 43 : this.validKeyList.hashCode());
        result = result * 59 + (this.attributeType == null ? 43 : this.attributeType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="isSensitive")
        private Boolean isSensitive;
        @JsonProperty(value="isMandatory")
        private Boolean isMandatory;
        @JsonProperty(value="isGenerated")
        private Boolean isGenerated;
        @JsonProperty(value="isBase64Encoded")
        private Boolean isBase64Encoded;
        @JsonProperty(value="validKeyList")
        private List<String> validKeyList;
        @JsonProperty(value="attributeType")
        private String attributeType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder isSensitive(Boolean isSensitive) {
            this.isSensitive = isSensitive;
            this.__explicitlySet__.add("isSensitive");
            return this;
        }

        public Builder isMandatory(Boolean isMandatory) {
            this.isMandatory = isMandatory;
            this.__explicitlySet__.add("isMandatory");
            return this;
        }

        public Builder isGenerated(Boolean isGenerated) {
            this.isGenerated = isGenerated;
            this.__explicitlySet__.add("isGenerated");
            return this;
        }

        public Builder isBase64Encoded(Boolean isBase64Encoded) {
            this.isBase64Encoded = isBase64Encoded;
            this.__explicitlySet__.add("isBase64Encoded");
            return this;
        }

        public Builder validKeyList(List<String> validKeyList) {
            this.validKeyList = validKeyList;
            this.__explicitlySet__.add("validKeyList");
            return this;
        }

        public Builder attributeType(String attributeType) {
            this.attributeType = attributeType;
            this.__explicitlySet__.add("attributeType");
            return this;
        }

        public Attribute build() {
            Attribute model = new Attribute(this.name, this.isSensitive, this.isMandatory, this.isGenerated, this.isBase64Encoded, this.validKeyList, this.attributeType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Attribute model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("isSensitive")) {
                this.isSensitive(model.getIsSensitive());
            }
            if (model.wasPropertyExplicitlySet("isMandatory")) {
                this.isMandatory(model.getIsMandatory());
            }
            if (model.wasPropertyExplicitlySet("isGenerated")) {
                this.isGenerated(model.getIsGenerated());
            }
            if (model.wasPropertyExplicitlySet("isBase64Encoded")) {
                this.isBase64Encoded(model.getIsBase64Encoded());
            }
            if (model.wasPropertyExplicitlySet("validKeyList")) {
                this.validKeyList(model.getValidKeyList());
            }
            if (model.wasPropertyExplicitlySet("attributeType")) {
                this.attributeType(model.getAttributeType());
            }
            return this;
        }
    }
}

