/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasetools.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDatabaseToolsPrivateEndpointRequest
extends BmcRequest<Void> {
    private String databaseToolsPrivateEndpointId;
    private String opcRequestId;

    public String getDatabaseToolsPrivateEndpointId() {
        return this.databaseToolsPrivateEndpointId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().databaseToolsPrivateEndpointId(this.databaseToolsPrivateEndpointId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseToolsPrivateEndpointId=").append(String.valueOf(this.databaseToolsPrivateEndpointId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDatabaseToolsPrivateEndpointRequest)) {
            return false;
        }
        GetDatabaseToolsPrivateEndpointRequest other = (GetDatabaseToolsPrivateEndpointRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseToolsPrivateEndpointId, other.databaseToolsPrivateEndpointId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseToolsPrivateEndpointId == null ? 43 : this.databaseToolsPrivateEndpointId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDatabaseToolsPrivateEndpointRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseToolsPrivateEndpointId = null;
        private String opcRequestId = null;

        public Builder databaseToolsPrivateEndpointId(String databaseToolsPrivateEndpointId) {
            this.databaseToolsPrivateEndpointId = databaseToolsPrivateEndpointId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDatabaseToolsPrivateEndpointRequest o) {
            this.databaseToolsPrivateEndpointId(o.getDatabaseToolsPrivateEndpointId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDatabaseToolsPrivateEndpointRequest build() {
            GetDatabaseToolsPrivateEndpointRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDatabaseToolsPrivateEndpointRequest buildWithoutInvocationCallback() {
            GetDatabaseToolsPrivateEndpointRequest request = new GetDatabaseToolsPrivateEndpointRequest();
            request.databaseToolsPrivateEndpointId = this.databaseToolsPrivateEndpointId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

