/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasetools.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasetools.model.DatabaseToolsConnectionSummary;
import com.oracle.bmc.databasetools.model.DatabaseToolsKeyStoreMySqlSummary;
import com.oracle.bmc.databasetools.model.DatabaseToolsRelatedResourceMySql;
import com.oracle.bmc.databasetools.model.DatabaseToolsUserPasswordSummary;
import com.oracle.bmc.databasetools.model.LifecycleState;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseToolsConnectionMySqlSummary
extends DatabaseToolsConnectionSummary {
    @JsonProperty(value="relatedResource")
    private final DatabaseToolsRelatedResourceMySql relatedResource;
    @JsonProperty(value="connectionString")
    private final String connectionString;
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="userPassword")
    private final DatabaseToolsUserPasswordSummary userPassword;
    @JsonProperty(value="advancedProperties")
    private final Map<String, String> advancedProperties;
    @JsonProperty(value="keyStores")
    private final List<DatabaseToolsKeyStoreMySqlSummary> keyStores;
    @JsonProperty(value="privateEndpointId")
    private final String privateEndpointId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DatabaseToolsConnectionMySqlSummary(String id, String displayName, String compartmentId, LifecycleState lifecycleState, String lifecycleDetails, Date timeCreated, Date timeUpdated, Map<String, Map<String, Object>> definedTags, Map<String, String> freeformTags, Map<String, Map<String, Object>> systemTags, DatabaseToolsRelatedResourceMySql relatedResource, String connectionString, String userName, DatabaseToolsUserPasswordSummary userPassword, Map<String, String> advancedProperties, List<DatabaseToolsKeyStoreMySqlSummary> keyStores, String privateEndpointId) {
        super(id, displayName, compartmentId, lifecycleState, lifecycleDetails, timeCreated, timeUpdated, definedTags, freeformTags, systemTags);
        this.relatedResource = relatedResource;
        this.connectionString = connectionString;
        this.userName = userName;
        this.userPassword = userPassword;
        this.advancedProperties = advancedProperties;
        this.keyStores = keyStores;
        this.privateEndpointId = privateEndpointId;
    }

    public DatabaseToolsRelatedResourceMySql getRelatedResource() {
        return this.relatedResource;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getUserName() {
        return this.userName;
    }

    public DatabaseToolsUserPasswordSummary getUserPassword() {
        return this.userPassword;
    }

    public Map<String, String> getAdvancedProperties() {
        return this.advancedProperties;
    }

    public List<DatabaseToolsKeyStoreMySqlSummary> getKeyStores() {
        return this.keyStores;
    }

    public String getPrivateEndpointId() {
        return this.privateEndpointId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseToolsConnectionMySqlSummary(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", relatedResource=").append(String.valueOf((Object)this.relatedResource));
        sb.append(", connectionString=").append(String.valueOf(this.connectionString));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", userPassword=").append(String.valueOf((Object)this.userPassword));
        sb.append(", advancedProperties=").append(String.valueOf(this.advancedProperties));
        sb.append(", keyStores=").append(String.valueOf(this.keyStores));
        sb.append(", privateEndpointId=").append(String.valueOf(this.privateEndpointId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseToolsConnectionMySqlSummary)) {
            return false;
        }
        DatabaseToolsConnectionMySqlSummary other = (DatabaseToolsConnectionMySqlSummary)((Object)o);
        return Objects.equals((Object)this.relatedResource, (Object)other.relatedResource) && Objects.equals(this.connectionString, other.connectionString) && Objects.equals(this.userName, other.userName) && Objects.equals((Object)this.userPassword, (Object)other.userPassword) && Objects.equals(this.advancedProperties, other.advancedProperties) && Objects.equals(this.keyStores, other.keyStores) && Objects.equals(this.privateEndpointId, other.privateEndpointId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.relatedResource == null ? 43 : this.relatedResource.hashCode());
        result = result * 59 + (this.connectionString == null ? 43 : this.connectionString.hashCode());
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.userPassword == null ? 43 : this.userPassword.hashCode());
        result = result * 59 + (this.advancedProperties == null ? 43 : this.advancedProperties.hashCode());
        result = result * 59 + (this.keyStores == null ? 43 : this.keyStores.hashCode());
        result = result * 59 + (this.privateEndpointId == null ? 43 : this.privateEndpointId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="relatedResource")
        private DatabaseToolsRelatedResourceMySql relatedResource;
        @JsonProperty(value="connectionString")
        private String connectionString;
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="userPassword")
        private DatabaseToolsUserPasswordSummary userPassword;
        @JsonProperty(value="advancedProperties")
        private Map<String, String> advancedProperties;
        @JsonProperty(value="keyStores")
        private List<DatabaseToolsKeyStoreMySqlSummary> keyStores;
        @JsonProperty(value="privateEndpointId")
        private String privateEndpointId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder relatedResource(DatabaseToolsRelatedResourceMySql relatedResource) {
            this.relatedResource = relatedResource;
            this.__explicitlySet__.add("relatedResource");
            return this;
        }

        public Builder connectionString(String connectionString) {
            this.connectionString = connectionString;
            this.__explicitlySet__.add("connectionString");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder userPassword(DatabaseToolsUserPasswordSummary userPassword) {
            this.userPassword = userPassword;
            this.__explicitlySet__.add("userPassword");
            return this;
        }

        public Builder advancedProperties(Map<String, String> advancedProperties) {
            this.advancedProperties = advancedProperties;
            this.__explicitlySet__.add("advancedProperties");
            return this;
        }

        public Builder keyStores(List<DatabaseToolsKeyStoreMySqlSummary> keyStores) {
            this.keyStores = keyStores;
            this.__explicitlySet__.add("keyStores");
            return this;
        }

        public Builder privateEndpointId(String privateEndpointId) {
            this.privateEndpointId = privateEndpointId;
            this.__explicitlySet__.add("privateEndpointId");
            return this;
        }

        public DatabaseToolsConnectionMySqlSummary build() {
            DatabaseToolsConnectionMySqlSummary model = new DatabaseToolsConnectionMySqlSummary(this.id, this.displayName, this.compartmentId, this.lifecycleState, this.lifecycleDetails, this.timeCreated, this.timeUpdated, this.definedTags, this.freeformTags, this.systemTags, this.relatedResource, this.connectionString, this.userName, this.userPassword, this.advancedProperties, this.keyStores, this.privateEndpointId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseToolsConnectionMySqlSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("relatedResource")) {
                this.relatedResource(model.getRelatedResource());
            }
            if (model.wasPropertyExplicitlySet("connectionString")) {
                this.connectionString(model.getConnectionString());
            }
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("userPassword")) {
                this.userPassword(model.getUserPassword());
            }
            if (model.wasPropertyExplicitlySet("advancedProperties")) {
                this.advancedProperties(model.getAdvancedProperties());
            }
            if (model.wasPropertyExplicitlySet("keyStores")) {
                this.keyStores(model.getKeyStores());
            }
            if (model.wasPropertyExplicitlySet("privateEndpointId")) {
                this.privateEndpointId(model.getPrivateEndpointId());
            }
            return this;
        }
    }
}

