/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.databasemigration.model.UpdateConnectionDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateConnectionRequest
extends BmcRequest<UpdateConnectionDetails> {
    private String connectionId;
    private UpdateConnectionDetails updateConnectionDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getConnectionId() {
        return this.connectionId;
    }

    public UpdateConnectionDetails getUpdateConnectionDetails() {
        return this.updateConnectionDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateConnectionDetails getBody$() {
        return this.updateConnectionDetails;
    }

    public Builder toBuilder() {
        return new Builder().connectionId(this.connectionId).updateConnectionDetails(this.updateConnectionDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",connectionId=").append(String.valueOf(this.connectionId));
        sb.append(",updateConnectionDetails=").append(String.valueOf((Object)this.updateConnectionDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateConnectionRequest)) {
            return false;
        }
        UpdateConnectionRequest other = (UpdateConnectionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.connectionId, other.connectionId) && Objects.equals((Object)this.updateConnectionDetails, (Object)other.updateConnectionDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.connectionId == null ? 43 : this.connectionId.hashCode());
        result = result * 59 + (this.updateConnectionDetails == null ? 43 : this.updateConnectionDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateConnectionRequest, UpdateConnectionDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String connectionId = null;
        private UpdateConnectionDetails updateConnectionDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public Builder updateConnectionDetails(UpdateConnectionDetails updateConnectionDetails) {
            this.updateConnectionDetails = updateConnectionDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateConnectionRequest o) {
            this.connectionId(o.getConnectionId());
            this.updateConnectionDetails(o.getUpdateConnectionDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateConnectionRequest build() {
            UpdateConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateConnectionDetails body) {
            this.updateConnectionDetails(body);
            return this;
        }

        public UpdateConnectionRequest buildWithoutInvocationCallback() {
            UpdateConnectionRequest request = new UpdateConnectionRequest();
            request.connectionId = this.connectionId;
            request.updateConnectionDetails = this.updateConnectionDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

