/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.databasemigration.model.MigrationObjectCollection;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RemoveMigrationObjectsRequest
extends BmcRequest<MigrationObjectCollection> {
    private String migrationId;
    private MigrationObjectCollection removeMigrationObjectsDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getMigrationId() {
        return this.migrationId;
    }

    public MigrationObjectCollection getRemoveMigrationObjectsDetails() {
        return this.removeMigrationObjectsDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public MigrationObjectCollection getBody$() {
        return this.removeMigrationObjectsDetails;
    }

    public Builder toBuilder() {
        return new Builder().migrationId(this.migrationId).removeMigrationObjectsDetails(this.removeMigrationObjectsDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",migrationId=").append(String.valueOf(this.migrationId));
        sb.append(",removeMigrationObjectsDetails=").append(String.valueOf((Object)this.removeMigrationObjectsDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoveMigrationObjectsRequest)) {
            return false;
        }
        RemoveMigrationObjectsRequest other = (RemoveMigrationObjectsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.migrationId, other.migrationId) && Objects.equals((Object)this.removeMigrationObjectsDetails, (Object)other.removeMigrationObjectsDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.migrationId == null ? 43 : this.migrationId.hashCode());
        result = result * 59 + (this.removeMigrationObjectsDetails == null ? 43 : this.removeMigrationObjectsDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RemoveMigrationObjectsRequest, MigrationObjectCollection> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String migrationId = null;
        private MigrationObjectCollection removeMigrationObjectsDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder migrationId(String migrationId) {
            this.migrationId = migrationId;
            return this;
        }

        public Builder removeMigrationObjectsDetails(MigrationObjectCollection removeMigrationObjectsDetails) {
            this.removeMigrationObjectsDetails = removeMigrationObjectsDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RemoveMigrationObjectsRequest o) {
            this.migrationId(o.getMigrationId());
            this.removeMigrationObjectsDetails(o.getRemoveMigrationObjectsDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RemoveMigrationObjectsRequest build() {
            RemoveMigrationObjectsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(MigrationObjectCollection body) {
            this.removeMigrationObjectsDetails(body);
            return this;
        }

        public RemoveMigrationObjectsRequest buildWithoutInvocationCallback() {
            RemoveMigrationObjectsRequest request = new RemoveMigrationObjectsRequest();
            request.migrationId = this.migrationId;
            request.removeMigrationObjectsDetails = this.removeMigrationObjectsDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

