/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.databasemigration.model.ReasonKeywords;
import com.oracle.bmc.databasemigration.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListExcludedObjectsRequest
extends BmcRequest<Void> {
    private String jobId;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private SortOrders sortOrder;
    private SortBy sortBy;
    private String type;
    private String owner;
    private String object;
    private String ownerContains;
    private String objectContains;
    private ReasonKeywords reasonCategory;
    private String sourceRule;

    public String getJobId() {
        return this.jobId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getType() {
        return this.type;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getObject() {
        return this.object;
    }

    public String getOwnerContains() {
        return this.ownerContains;
    }

    public String getObjectContains() {
        return this.objectContains;
    }

    public ReasonKeywords getReasonCategory() {
        return this.reasonCategory;
    }

    public String getSourceRule() {
        return this.sourceRule;
    }

    public Builder toBuilder() {
        return new Builder().jobId(this.jobId).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).type(this.type).owner(this.owner).object(this.object).ownerContains(this.ownerContains).objectContains(this.objectContains).reasonCategory(this.reasonCategory).sourceRule(this.sourceRule);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",jobId=").append(String.valueOf(this.jobId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",type=").append(String.valueOf(this.type));
        sb.append(",owner=").append(String.valueOf(this.owner));
        sb.append(",object=").append(String.valueOf(this.object));
        sb.append(",ownerContains=").append(String.valueOf(this.ownerContains));
        sb.append(",objectContains=").append(String.valueOf(this.objectContains));
        sb.append(",reasonCategory=").append(String.valueOf((Object)this.reasonCategory));
        sb.append(",sourceRule=").append(String.valueOf(this.sourceRule));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListExcludedObjectsRequest)) {
            return false;
        }
        ListExcludedObjectsRequest other = (ListExcludedObjectsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.jobId, other.jobId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.type, other.type) && Objects.equals(this.owner, other.owner) && Objects.equals(this.object, other.object) && Objects.equals(this.ownerContains, other.ownerContains) && Objects.equals(this.objectContains, other.objectContains) && Objects.equals((Object)this.reasonCategory, (Object)other.reasonCategory) && Objects.equals(this.sourceRule, other.sourceRule);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.jobId == null ? 43 : this.jobId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.owner == null ? 43 : this.owner.hashCode());
        result = result * 59 + (this.object == null ? 43 : this.object.hashCode());
        result = result * 59 + (this.ownerContains == null ? 43 : this.ownerContains.hashCode());
        result = result * 59 + (this.objectContains == null ? 43 : this.objectContains.hashCode());
        result = result * 59 + (this.reasonCategory == null ? 43 : this.reasonCategory.hashCode());
        result = result * 59 + (this.sourceRule == null ? 43 : this.sourceRule.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListExcludedObjectsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String jobId = null;
        private String opcRequestId = null;
        private Integer limit = null;
        private String page = null;
        private SortOrders sortOrder = null;
        private SortBy sortBy = null;
        private String type = null;
        private String owner = null;
        private String object = null;
        private String ownerContains = null;
        private String objectContains = null;
        private ReasonKeywords reasonCategory = null;
        private String sourceRule = null;

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder object(String object) {
            this.object = object;
            return this;
        }

        public Builder ownerContains(String ownerContains) {
            this.ownerContains = ownerContains;
            return this;
        }

        public Builder objectContains(String objectContains) {
            this.objectContains = objectContains;
            return this;
        }

        public Builder reasonCategory(ReasonKeywords reasonCategory) {
            this.reasonCategory = reasonCategory;
            return this;
        }

        public Builder sourceRule(String sourceRule) {
            this.sourceRule = sourceRule;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListExcludedObjectsRequest o) {
            this.jobId(o.getJobId());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.type(o.getType());
            this.owner(o.getOwner());
            this.object(o.getObject());
            this.ownerContains(o.getOwnerContains());
            this.objectContains(o.getObjectContains());
            this.reasonCategory(o.getReasonCategory());
            this.sourceRule(o.getSourceRule());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListExcludedObjectsRequest build() {
            ListExcludedObjectsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListExcludedObjectsRequest buildWithoutInvocationCallback() {
            ListExcludedObjectsRequest request = new ListExcludedObjectsRequest();
            request.jobId = this.jobId;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.type = this.type;
            request.owner = this.owner;
            request.object = this.object;
            request.ownerContains = this.ownerContains;
            request.objectContains = this.objectContains;
            request.reasonCategory = this.reasonCategory;
            request.sourceRule = this.sourceRule;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Type("type"),
        ReasonCategory("reasonCategory");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

