/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemigration.model.JobPhaseStatus;
import com.oracle.bmc.databasemigration.model.OdmsJobPhases;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MigrationJobProgressSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="currentPhase")
    private final OdmsJobPhases currentPhase;
    @JsonProperty(value="currentStatus")
    private final JobPhaseStatus currentStatus;
    @JsonProperty(value="jobProgress")
    private final Integer jobProgress;

    @Deprecated
    @ConstructorProperties(value={"currentPhase", "currentStatus", "jobProgress"})
    public MigrationJobProgressSummary(OdmsJobPhases currentPhase, JobPhaseStatus currentStatus, Integer jobProgress) {
        this.currentPhase = currentPhase;
        this.currentStatus = currentStatus;
        this.jobProgress = jobProgress;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public OdmsJobPhases getCurrentPhase() {
        return this.currentPhase;
    }

    public JobPhaseStatus getCurrentStatus() {
        return this.currentStatus;
    }

    public Integer getJobProgress() {
        return this.jobProgress;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MigrationJobProgressSummary(");
        sb.append("super=").append(super.toString());
        sb.append("currentPhase=").append(String.valueOf((Object)this.currentPhase));
        sb.append(", currentStatus=").append(String.valueOf((Object)this.currentStatus));
        sb.append(", jobProgress=").append(String.valueOf(this.jobProgress));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MigrationJobProgressSummary)) {
            return false;
        }
        MigrationJobProgressSummary other = (MigrationJobProgressSummary)((Object)o);
        return Objects.equals((Object)this.currentPhase, (Object)other.currentPhase) && Objects.equals((Object)this.currentStatus, (Object)other.currentStatus) && Objects.equals(this.jobProgress, other.jobProgress) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.currentPhase == null ? 43 : this.currentPhase.hashCode());
        result = result * 59 + (this.currentStatus == null ? 43 : this.currentStatus.hashCode());
        result = result * 59 + (this.jobProgress == null ? 43 : this.jobProgress.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="currentPhase")
        private OdmsJobPhases currentPhase;
        @JsonProperty(value="currentStatus")
        private JobPhaseStatus currentStatus;
        @JsonProperty(value="jobProgress")
        private Integer jobProgress;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder currentPhase(OdmsJobPhases currentPhase) {
            this.currentPhase = currentPhase;
            this.__explicitlySet__.add("currentPhase");
            return this;
        }

        public Builder currentStatus(JobPhaseStatus currentStatus) {
            this.currentStatus = currentStatus;
            this.__explicitlySet__.add("currentStatus");
            return this;
        }

        public Builder jobProgress(Integer jobProgress) {
            this.jobProgress = jobProgress;
            this.__explicitlySet__.add("jobProgress");
            return this;
        }

        public MigrationJobProgressSummary build() {
            MigrationJobProgressSummary model = new MigrationJobProgressSummary(this.currentPhase, this.currentStatus, this.jobProgress);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MigrationJobProgressSummary model) {
            if (model.wasPropertyExplicitlySet("currentPhase")) {
                this.currentPhase(model.getCurrentPhase());
            }
            if (model.wasPropertyExplicitlySet("currentStatus")) {
                this.currentStatus(model.getCurrentStatus());
            }
            if (model.wasPropertyExplicitlySet("jobProgress")) {
                this.jobProgress(model.getJobProgress());
            }
            return this;
        }
    }
}

