/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateConnectDescriptor
extends ExplicitlySetBmcModel {
    @JsonProperty(value="host")
    private final String host;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="databaseServiceName")
    private final String databaseServiceName;
    @JsonProperty(value="connectString")
    private final String connectString;

    @Deprecated
    @ConstructorProperties(value={"host", "port", "databaseServiceName", "connectString"})
    public CreateConnectDescriptor(String host, Integer port, String databaseServiceName, String connectString) {
        this.host = host;
        this.port = port;
        this.databaseServiceName = databaseServiceName;
        this.connectString = connectString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getDatabaseServiceName() {
        return this.databaseServiceName;
    }

    public String getConnectString() {
        return this.connectString;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateConnectDescriptor(");
        sb.append("super=").append(super.toString());
        sb.append("host=").append(String.valueOf(this.host));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", databaseServiceName=").append(String.valueOf(this.databaseServiceName));
        sb.append(", connectString=").append(String.valueOf(this.connectString));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateConnectDescriptor)) {
            return false;
        }
        CreateConnectDescriptor other = (CreateConnectDescriptor)((Object)o);
        return Objects.equals(this.host, other.host) && Objects.equals(this.port, other.port) && Objects.equals(this.databaseServiceName, other.databaseServiceName) && Objects.equals(this.connectString, other.connectString) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.host == null ? 43 : this.host.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.databaseServiceName == null ? 43 : this.databaseServiceName.hashCode());
        result = result * 59 + (this.connectString == null ? 43 : this.connectString.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="host")
        private String host;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="databaseServiceName")
        private String databaseServiceName;
        @JsonProperty(value="connectString")
        private String connectString;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder host(String host) {
            this.host = host;
            this.__explicitlySet__.add("host");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder databaseServiceName(String databaseServiceName) {
            this.databaseServiceName = databaseServiceName;
            this.__explicitlySet__.add("databaseServiceName");
            return this;
        }

        public Builder connectString(String connectString) {
            this.connectString = connectString;
            this.__explicitlySet__.add("connectString");
            return this;
        }

        public CreateConnectDescriptor build() {
            CreateConnectDescriptor model = new CreateConnectDescriptor(this.host, this.port, this.databaseServiceName, this.connectString);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateConnectDescriptor model) {
            if (model.wasPropertyExplicitlySet("host")) {
                this.host(model.getHost());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("databaseServiceName")) {
                this.databaseServiceName(model.getDatabaseServiceName());
            }
            if (model.wasPropertyExplicitlySet("connectString")) {
                this.connectString(model.getConnectString());
            }
            return this;
        }
    }
}

