/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AgentImageSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="downloadUrl")
    private final String downloadUrl;

    @Deprecated
    @ConstructorProperties(value={"version", "downloadUrl"})
    public AgentImageSummary(String version, String downloadUrl) {
        this.version = version;
        this.downloadUrl = downloadUrl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getVersion() {
        return this.version;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AgentImageSummary(");
        sb.append("super=").append(super.toString());
        sb.append("version=").append(String.valueOf(this.version));
        sb.append(", downloadUrl=").append(String.valueOf(this.downloadUrl));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AgentImageSummary)) {
            return false;
        }
        AgentImageSummary other = (AgentImageSummary)((Object)o);
        return Objects.equals(this.version, other.version) && Objects.equals(this.downloadUrl, other.downloadUrl) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.downloadUrl == null ? 43 : this.downloadUrl.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="downloadUrl")
        private String downloadUrl;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            this.__explicitlySet__.add("downloadUrl");
            return this;
        }

        public AgentImageSummary build() {
            AgentImageSummary model = new AgentImageSummary(this.version, this.downloadUrl);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AgentImageSummary model) {
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("downloadUrl")) {
                this.downloadUrl(model.getDownloadUrl());
            }
            return this;
        }
    }
}

