/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.databasemanagement.model.TestPreferredCredentialDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class TestPreferredCredentialRequest
extends BmcRequest<TestPreferredCredentialDetails> {
    private String managedDatabaseId;
    private String credentialName;
    private String opcRequestId;
    private TestPreferredCredentialDetails testPreferredCredentialDetails;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public String getCredentialName() {
        return this.credentialName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public TestPreferredCredentialDetails getTestPreferredCredentialDetails() {
        return this.testPreferredCredentialDetails;
    }

    @InternalSdk
    public TestPreferredCredentialDetails getBody$() {
        return this.testPreferredCredentialDetails;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).credentialName(this.credentialName).opcRequestId(this.opcRequestId).testPreferredCredentialDetails(this.testPreferredCredentialDetails);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",credentialName=").append(String.valueOf(this.credentialName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",testPreferredCredentialDetails=").append(String.valueOf((Object)this.testPreferredCredentialDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestPreferredCredentialRequest)) {
            return false;
        }
        TestPreferredCredentialRequest other = (TestPreferredCredentialRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.credentialName, other.credentialName) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.testPreferredCredentialDetails, (Object)other.testPreferredCredentialDetails);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.credentialName == null ? 43 : this.credentialName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.testPreferredCredentialDetails == null ? 43 : this.testPreferredCredentialDetails.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<TestPreferredCredentialRequest, TestPreferredCredentialDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private String credentialName = null;
        private String opcRequestId = null;
        private TestPreferredCredentialDetails testPreferredCredentialDetails = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder credentialName(String credentialName) {
            this.credentialName = credentialName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder testPreferredCredentialDetails(TestPreferredCredentialDetails testPreferredCredentialDetails) {
            this.testPreferredCredentialDetails = testPreferredCredentialDetails;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(TestPreferredCredentialRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.credentialName(o.getCredentialName());
            this.opcRequestId(o.getOpcRequestId());
            this.testPreferredCredentialDetails(o.getTestPreferredCredentialDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public TestPreferredCredentialRequest build() {
            TestPreferredCredentialRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(TestPreferredCredentialDetails body) {
            this.testPreferredCredentialDetails(body);
            return this;
        }

        public TestPreferredCredentialRequest buildWithoutInvocationCallback() {
            TestPreferredCredentialRequest request = new TestPreferredCredentialRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.credentialName = this.credentialName;
            request.opcRequestId = this.opcRequestId;
            request.testPreferredCredentialDetails = this.testPreferredCredentialDetails;
            return request;
        }
    }
}

