/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SummarizeAttentionLogCountsRequest
extends BmcRequest<Void> {
    private String managedDatabaseId;
    private Date timeGreaterThanOrEqualTo;
    private Date timeLessThanOrEqualTo;
    private UrgencyFilter urgencyFilter;
    private GroupBy groupBy;
    private TypeFilter typeFilter;
    private String logSearchText;
    private Boolean isRegularExpression;
    private String page;
    private Integer limit;
    private String opcRequestId;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public Date getTimeGreaterThanOrEqualTo() {
        return this.timeGreaterThanOrEqualTo;
    }

    public Date getTimeLessThanOrEqualTo() {
        return this.timeLessThanOrEqualTo;
    }

    public UrgencyFilter getUrgencyFilter() {
        return this.urgencyFilter;
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    public TypeFilter getTypeFilter() {
        return this.typeFilter;
    }

    public String getLogSearchText() {
        return this.logSearchText;
    }

    public Boolean getIsRegularExpression() {
        return this.isRegularExpression;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).timeGreaterThanOrEqualTo(this.timeGreaterThanOrEqualTo).timeLessThanOrEqualTo(this.timeLessThanOrEqualTo).urgencyFilter(this.urgencyFilter).groupBy(this.groupBy).typeFilter(this.typeFilter).logSearchText(this.logSearchText).isRegularExpression(this.isRegularExpression).page(this.page).limit(this.limit).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",timeGreaterThanOrEqualTo=").append(String.valueOf(this.timeGreaterThanOrEqualTo));
        sb.append(",timeLessThanOrEqualTo=").append(String.valueOf(this.timeLessThanOrEqualTo));
        sb.append(",urgencyFilter=").append(String.valueOf((Object)this.urgencyFilter));
        sb.append(",groupBy=").append(String.valueOf((Object)this.groupBy));
        sb.append(",typeFilter=").append(String.valueOf((Object)this.typeFilter));
        sb.append(",logSearchText=").append(String.valueOf(this.logSearchText));
        sb.append(",isRegularExpression=").append(String.valueOf(this.isRegularExpression));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeAttentionLogCountsRequest)) {
            return false;
        }
        SummarizeAttentionLogCountsRequest other = (SummarizeAttentionLogCountsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.timeGreaterThanOrEqualTo, other.timeGreaterThanOrEqualTo) && Objects.equals(this.timeLessThanOrEqualTo, other.timeLessThanOrEqualTo) && Objects.equals((Object)this.urgencyFilter, (Object)other.urgencyFilter) && Objects.equals((Object)this.groupBy, (Object)other.groupBy) && Objects.equals((Object)this.typeFilter, (Object)other.typeFilter) && Objects.equals(this.logSearchText, other.logSearchText) && Objects.equals(this.isRegularExpression, other.isRegularExpression) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.timeGreaterThanOrEqualTo == null ? 43 : this.timeGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeLessThanOrEqualTo == null ? 43 : this.timeLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.urgencyFilter == null ? 43 : this.urgencyFilter.hashCode());
        result = result * 59 + (this.groupBy == null ? 43 : this.groupBy.hashCode());
        result = result * 59 + (this.typeFilter == null ? 43 : this.typeFilter.hashCode());
        result = result * 59 + (this.logSearchText == null ? 43 : this.logSearchText.hashCode());
        result = result * 59 + (this.isRegularExpression == null ? 43 : this.isRegularExpression.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeAttentionLogCountsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private Date timeGreaterThanOrEqualTo = null;
        private Date timeLessThanOrEqualTo = null;
        private UrgencyFilter urgencyFilter = null;
        private GroupBy groupBy = null;
        private TypeFilter typeFilter = null;
        private String logSearchText = null;
        private Boolean isRegularExpression = null;
        private String page = null;
        private Integer limit = null;
        private String opcRequestId = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder timeGreaterThanOrEqualTo(Date timeGreaterThanOrEqualTo) {
            this.timeGreaterThanOrEqualTo = timeGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeLessThanOrEqualTo(Date timeLessThanOrEqualTo) {
            this.timeLessThanOrEqualTo = timeLessThanOrEqualTo;
            return this;
        }

        public Builder urgencyFilter(UrgencyFilter urgencyFilter) {
            this.urgencyFilter = urgencyFilter;
            return this;
        }

        public Builder groupBy(GroupBy groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        public Builder typeFilter(TypeFilter typeFilter) {
            this.typeFilter = typeFilter;
            return this;
        }

        public Builder logSearchText(String logSearchText) {
            this.logSearchText = logSearchText;
            return this;
        }

        public Builder isRegularExpression(Boolean isRegularExpression) {
            this.isRegularExpression = isRegularExpression;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeAttentionLogCountsRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.timeGreaterThanOrEqualTo(o.getTimeGreaterThanOrEqualTo());
            this.timeLessThanOrEqualTo(o.getTimeLessThanOrEqualTo());
            this.urgencyFilter(o.getUrgencyFilter());
            this.groupBy(o.getGroupBy());
            this.typeFilter(o.getTypeFilter());
            this.logSearchText(o.getLogSearchText());
            this.isRegularExpression(o.getIsRegularExpression());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeAttentionLogCountsRequest build() {
            SummarizeAttentionLogCountsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public SummarizeAttentionLogCountsRequest buildWithoutInvocationCallback() {
            SummarizeAttentionLogCountsRequest request = new SummarizeAttentionLogCountsRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.timeGreaterThanOrEqualTo = this.timeGreaterThanOrEqualTo;
            request.timeLessThanOrEqualTo = this.timeLessThanOrEqualTo;
            request.urgencyFilter = this.urgencyFilter;
            request.groupBy = this.groupBy;
            request.typeFilter = this.typeFilter;
            request.logSearchText = this.logSearchText;
            request.isRegularExpression = this.isRegularExpression;
            request.page = this.page;
            request.limit = this.limit;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum TypeFilter implements BmcEnum
    {
        Unknown("UNKNOWN"),
        IncidentError("INCIDENT_ERROR"),
        Error("ERROR"),
        Warning("WARNING"),
        Notification("NOTIFICATION"),
        Trace("TRACE"),
        All("ALL");

        private final String value;
        private static Map<String, TypeFilter> map;

        private TypeFilter(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TypeFilter create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid TypeFilter: " + key);
        }

        static {
            map = new HashMap<String, TypeFilter>();
            for (TypeFilter v : TypeFilter.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum GroupBy implements BmcEnum
    {
        Urgency("URGENCY"),
        Type("TYPE");

        private final String value;
        private static Map<String, GroupBy> map;

        private GroupBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static GroupBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid GroupBy: " + key);
        }

        static {
            map = new HashMap<String, GroupBy>();
            for (GroupBy v : GroupBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum UrgencyFilter implements BmcEnum
    {
        Immediate("IMMEDIATE"),
        Soon("SOON"),
        Deferrable("DEFERRABLE"),
        Info("INFO"),
        All("ALL");

        private final String value;
        private static Map<String, UrgencyFilter> map;

        private UrgencyFilter(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UrgencyFilter create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid UrgencyFilter: " + key);
        }

        static {
            map = new HashMap<String, UrgencyFilter>();
            for (UrgencyFilter v : UrgencyFilter.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

