/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.databasemanagement.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListSqlTuningAdvisorTaskRecommendationsRequest
extends BmcRequest<Void> {
    private String managedDatabaseId;
    private Long sqlTuningAdvisorTaskId;
    private Long sqlObjectId;
    private Long executionId;
    private SortBy sortBy;
    private SortOrders sortOrder;
    private String page;
    private Integer limit;
    private String opcRequestId;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public Long getSqlTuningAdvisorTaskId() {
        return this.sqlTuningAdvisorTaskId;
    }

    public Long getSqlObjectId() {
        return this.sqlObjectId;
    }

    public Long getExecutionId() {
        return this.executionId;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).sqlTuningAdvisorTaskId(this.sqlTuningAdvisorTaskId).sqlObjectId(this.sqlObjectId).executionId(this.executionId).sortBy(this.sortBy).sortOrder(this.sortOrder).page(this.page).limit(this.limit).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",sqlTuningAdvisorTaskId=").append(String.valueOf(this.sqlTuningAdvisorTaskId));
        sb.append(",sqlObjectId=").append(String.valueOf(this.sqlObjectId));
        sb.append(",executionId=").append(String.valueOf(this.executionId));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSqlTuningAdvisorTaskRecommendationsRequest)) {
            return false;
        }
        ListSqlTuningAdvisorTaskRecommendationsRequest other = (ListSqlTuningAdvisorTaskRecommendationsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.sqlTuningAdvisorTaskId, other.sqlTuningAdvisorTaskId) && Objects.equals(this.sqlObjectId, other.sqlObjectId) && Objects.equals(this.executionId, other.executionId) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.sqlTuningAdvisorTaskId == null ? 43 : this.sqlTuningAdvisorTaskId.hashCode());
        result = result * 59 + (this.sqlObjectId == null ? 43 : this.sqlObjectId.hashCode());
        result = result * 59 + (this.executionId == null ? 43 : this.executionId.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSqlTuningAdvisorTaskRecommendationsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private Long sqlTuningAdvisorTaskId = null;
        private Long sqlObjectId = null;
        private Long executionId = null;
        private SortBy sortBy = null;
        private SortOrders sortOrder = null;
        private String page = null;
        private Integer limit = null;
        private String opcRequestId = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder sqlTuningAdvisorTaskId(Long sqlTuningAdvisorTaskId) {
            this.sqlTuningAdvisorTaskId = sqlTuningAdvisorTaskId;
            return this;
        }

        public Builder sqlObjectId(Long sqlObjectId) {
            this.sqlObjectId = sqlObjectId;
            return this;
        }

        public Builder executionId(Long executionId) {
            this.executionId = executionId;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSqlTuningAdvisorTaskRecommendationsRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.sqlTuningAdvisorTaskId(o.getSqlTuningAdvisorTaskId());
            this.sqlObjectId(o.getSqlObjectId());
            this.executionId(o.getExecutionId());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSqlTuningAdvisorTaskRecommendationsRequest build() {
            ListSqlTuningAdvisorTaskRecommendationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListSqlTuningAdvisorTaskRecommendationsRequest buildWithoutInvocationCallback() {
            ListSqlTuningAdvisorTaskRecommendationsRequest request = new ListSqlTuningAdvisorTaskRecommendationsRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.sqlTuningAdvisorTaskId = this.sqlTuningAdvisorTaskId;
            request.sqlObjectId = this.sqlObjectId;
            request.executionId = this.executionId;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.page = this.page;
            request.limit = this.limit;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        RecommendationType("RECOMMENDATION_TYPE"),
        Benefit("BENEFIT");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

