/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GetSqlExecutionPlanRequest
extends BmcRequest<Void> {
    private String managedDatabaseId;
    private Long sqlTuningAdvisorTaskId;
    private Long sqlObjectId;
    private Attribute attribute;
    private String opcRequestId;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public Long getSqlTuningAdvisorTaskId() {
        return this.sqlTuningAdvisorTaskId;
    }

    public Long getSqlObjectId() {
        return this.sqlObjectId;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).sqlTuningAdvisorTaskId(this.sqlTuningAdvisorTaskId).sqlObjectId(this.sqlObjectId).attribute(this.attribute).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",sqlTuningAdvisorTaskId=").append(String.valueOf(this.sqlTuningAdvisorTaskId));
        sb.append(",sqlObjectId=").append(String.valueOf(this.sqlObjectId));
        sb.append(",attribute=").append(String.valueOf((Object)this.attribute));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetSqlExecutionPlanRequest)) {
            return false;
        }
        GetSqlExecutionPlanRequest other = (GetSqlExecutionPlanRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.sqlTuningAdvisorTaskId, other.sqlTuningAdvisorTaskId) && Objects.equals(this.sqlObjectId, other.sqlObjectId) && Objects.equals((Object)this.attribute, (Object)other.attribute) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.sqlTuningAdvisorTaskId == null ? 43 : this.sqlTuningAdvisorTaskId.hashCode());
        result = result * 59 + (this.sqlObjectId == null ? 43 : this.sqlObjectId.hashCode());
        result = result * 59 + (this.attribute == null ? 43 : this.attribute.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSqlExecutionPlanRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private Long sqlTuningAdvisorTaskId = null;
        private Long sqlObjectId = null;
        private Attribute attribute = null;
        private String opcRequestId = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder sqlTuningAdvisorTaskId(Long sqlTuningAdvisorTaskId) {
            this.sqlTuningAdvisorTaskId = sqlTuningAdvisorTaskId;
            return this;
        }

        public Builder sqlObjectId(Long sqlObjectId) {
            this.sqlObjectId = sqlObjectId;
            return this;
        }

        public Builder attribute(Attribute attribute) {
            this.attribute = attribute;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSqlExecutionPlanRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.sqlTuningAdvisorTaskId(o.getSqlTuningAdvisorTaskId());
            this.sqlObjectId(o.getSqlObjectId());
            this.attribute(o.getAttribute());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSqlExecutionPlanRequest build() {
            GetSqlExecutionPlanRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetSqlExecutionPlanRequest buildWithoutInvocationCallback() {
            GetSqlExecutionPlanRequest request = new GetSqlExecutionPlanRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.sqlTuningAdvisorTaskId = this.sqlTuningAdvisorTaskId;
            request.sqlObjectId = this.sqlObjectId;
            request.attribute = this.attribute;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum Attribute implements BmcEnum
    {
        Original("ORIGINAL"),
        OriginalWithAdjustedCost("ORIGINAL_WITH_ADJUSTED_COST"),
        UsingSqlProfile("USING_SQL_PROFILE"),
        UsingNewIndices("USING_NEW_INDICES"),
        UsingParallelExecution("USING_PARALLEL_EXECUTION");

        private final String value;
        private static Map<String, Attribute> map;

        private Attribute(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Attribute create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Attribute: " + key);
        }

        static {
            map = new HashMap<String, Attribute>();
            for (Attribute v : Attribute.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

