/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetOptimizerStatisticsAdvisorExecutionScriptRequest
extends BmcRequest<Void> {
    private String managedDatabaseId;
    private String executionName;
    private String taskName;
    private String opcRequestId;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public String getExecutionName() {
        return this.executionName;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).executionName(this.executionName).taskName(this.taskName).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",executionName=").append(String.valueOf(this.executionName));
        sb.append(",taskName=").append(String.valueOf(this.taskName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetOptimizerStatisticsAdvisorExecutionScriptRequest)) {
            return false;
        }
        GetOptimizerStatisticsAdvisorExecutionScriptRequest other = (GetOptimizerStatisticsAdvisorExecutionScriptRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.executionName, other.executionName) && Objects.equals(this.taskName, other.taskName) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.executionName == null ? 43 : this.executionName.hashCode());
        result = result * 59 + (this.taskName == null ? 43 : this.taskName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetOptimizerStatisticsAdvisorExecutionScriptRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private String executionName = null;
        private String taskName = null;
        private String opcRequestId = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder executionName(String executionName) {
            this.executionName = executionName;
            return this;
        }

        public Builder taskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetOptimizerStatisticsAdvisorExecutionScriptRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.executionName(o.getExecutionName());
            this.taskName(o.getTaskName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetOptimizerStatisticsAdvisorExecutionScriptRequest build() {
            GetOptimizerStatisticsAdvisorExecutionScriptRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetOptimizerStatisticsAdvisorExecutionScriptRequest buildWithoutInvocationCallback() {
            GetOptimizerStatisticsAdvisorExecutionScriptRequest request = new GetOptimizerStatisticsAdvisorExecutionScriptRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.executionName = this.executionName;
            request.taskName = this.taskName;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

