/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.databasemanagement.model.DropTablespaceDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DropTablespaceRequest
extends BmcRequest<DropTablespaceDetails> {
    private String managedDatabaseId;
    private String tablespaceName;
    private DropTablespaceDetails dropTablespaceDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public String getTablespaceName() {
        return this.tablespaceName;
    }

    public DropTablespaceDetails getDropTablespaceDetails() {
        return this.dropTablespaceDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public DropTablespaceDetails getBody$() {
        return this.dropTablespaceDetails;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).tablespaceName(this.tablespaceName).dropTablespaceDetails(this.dropTablespaceDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",tablespaceName=").append(String.valueOf(this.tablespaceName));
        sb.append(",dropTablespaceDetails=").append(String.valueOf((Object)this.dropTablespaceDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DropTablespaceRequest)) {
            return false;
        }
        DropTablespaceRequest other = (DropTablespaceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.tablespaceName, other.tablespaceName) && Objects.equals((Object)this.dropTablespaceDetails, (Object)other.dropTablespaceDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.tablespaceName == null ? 43 : this.tablespaceName.hashCode());
        result = result * 59 + (this.dropTablespaceDetails == null ? 43 : this.dropTablespaceDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DropTablespaceRequest, DropTablespaceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private String tablespaceName = null;
        private DropTablespaceDetails dropTablespaceDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder tablespaceName(String tablespaceName) {
            this.tablespaceName = tablespaceName;
            return this;
        }

        public Builder dropTablespaceDetails(DropTablespaceDetails dropTablespaceDetails) {
            this.dropTablespaceDetails = dropTablespaceDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DropTablespaceRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.tablespaceName(o.getTablespaceName());
            this.dropTablespaceDetails(o.getDropTablespaceDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DropTablespaceRequest build() {
            DropTablespaceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(DropTablespaceDetails body) {
            this.dropTablespaceDetails(body);
            return this;
        }

        public DropTablespaceRequest buildWithoutInvocationCallback() {
            DropTablespaceRequest request = new DropTablespaceRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.tablespaceName = this.tablespaceName;
            request.dropTablespaceDetails = this.dropTablespaceDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

