/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteDbManagementPrivateEndpointRequest
extends BmcRequest<Void> {
    private String dbManagementPrivateEndpointId;
    private String opcRequestId;
    private String ifMatch;

    public String getDbManagementPrivateEndpointId() {
        return this.dbManagementPrivateEndpointId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().dbManagementPrivateEndpointId(this.dbManagementPrivateEndpointId).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dbManagementPrivateEndpointId=").append(String.valueOf(this.dbManagementPrivateEndpointId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteDbManagementPrivateEndpointRequest)) {
            return false;
        }
        DeleteDbManagementPrivateEndpointRequest other = (DeleteDbManagementPrivateEndpointRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dbManagementPrivateEndpointId, other.dbManagementPrivateEndpointId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dbManagementPrivateEndpointId == null ? 43 : this.dbManagementPrivateEndpointId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteDbManagementPrivateEndpointRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dbManagementPrivateEndpointId = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder dbManagementPrivateEndpointId(String dbManagementPrivateEndpointId) {
            this.dbManagementPrivateEndpointId = dbManagementPrivateEndpointId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDbManagementPrivateEndpointRequest o) {
            this.dbManagementPrivateEndpointId(o.getDbManagementPrivateEndpointId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDbManagementPrivateEndpointRequest build() {
            DeleteDbManagementPrivateEndpointRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteDbManagementPrivateEndpointRequest buildWithoutInvocationCallback() {
            DeleteDbManagementPrivateEndpointRequest request = new DeleteDbManagementPrivateEndpointRequest();
            request.dbManagementPrivateEndpointId = this.dbManagementPrivateEndpointId;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

