/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UserSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="timeExpiring")
    private final Date timeExpiring;
    @JsonProperty(value="defaultTablespace")
    private final String defaultTablespace;
    @JsonProperty(value="tempTablespace")
    private final String tempTablespace;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeLocked")
    private final Date timeLocked;
    @JsonProperty(value="profile")
    private final String profile;

    @Deprecated
    @ConstructorProperties(value={"name", "status", "timeExpiring", "defaultTablespace", "tempTablespace", "timeCreated", "timeLocked", "profile"})
    public UserSummary(String name, Status status, Date timeExpiring, String defaultTablespace, String tempTablespace, Date timeCreated, Date timeLocked, String profile) {
        this.name = name;
        this.status = status;
        this.timeExpiring = timeExpiring;
        this.defaultTablespace = defaultTablespace;
        this.tempTablespace = tempTablespace;
        this.timeCreated = timeCreated;
        this.timeLocked = timeLocked;
        this.profile = profile;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public Date getTimeExpiring() {
        return this.timeExpiring;
    }

    public String getDefaultTablespace() {
        return this.defaultTablespace;
    }

    public String getTempTablespace() {
        return this.tempTablespace;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeLocked() {
        return this.timeLocked;
    }

    public String getProfile() {
        return this.profile;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UserSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", timeExpiring=").append(String.valueOf(this.timeExpiring));
        sb.append(", defaultTablespace=").append(String.valueOf(this.defaultTablespace));
        sb.append(", tempTablespace=").append(String.valueOf(this.tempTablespace));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeLocked=").append(String.valueOf(this.timeLocked));
        sb.append(", profile=").append(String.valueOf(this.profile));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserSummary)) {
            return false;
        }
        UserSummary other = (UserSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.timeExpiring, other.timeExpiring) && Objects.equals(this.defaultTablespace, other.defaultTablespace) && Objects.equals(this.tempTablespace, other.tempTablespace) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeLocked, other.timeLocked) && Objects.equals(this.profile, other.profile) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.timeExpiring == null ? 43 : this.timeExpiring.hashCode());
        result = result * 59 + (this.defaultTablespace == null ? 43 : this.defaultTablespace.hashCode());
        result = result * 59 + (this.tempTablespace == null ? 43 : this.tempTablespace.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeLocked == null ? 43 : this.timeLocked.hashCode());
        result = result * 59 + (this.profile == null ? 43 : this.profile.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Open("OPEN"),
        Expired("EXPIRED"),
        ExpiredGrace("EXPIRED_GRACE"),
        Locked("LOCKED"),
        LockedTimed("LOCKED_TIMED"),
        ExpiredAndLocked("EXPIRED_AND_LOCKED"),
        ExpiredGraceAndLocked("EXPIRED_GRACE_AND_LOCKED"),
        ExpiredAndLockedTimed("EXPIRED_AND_LOCKED_TIMED"),
        ExpiredGraceAndLockedTimed("EXPIRED_GRACE_AND_LOCKED_TIMED"),
        OpenAndInRollover("OPEN_AND_IN_ROLLOVER"),
        ExpiredAndInRollover("EXPIRED_AND_IN_ROLLOVER"),
        LockedAndInRollover("LOCKED_AND_IN_ROLLOVER"),
        ExpiredAndLockedAndInRollover("EXPIRED_AND_LOCKED_AND_IN_ROLLOVER"),
        LockedTimedAndInRollover("LOCKED_TIMED_AND_IN_ROLLOVER"),
        ExpiredAndLockedTimedAndInRol("EXPIRED_AND_LOCKED_TIMED_AND_IN_ROL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="timeExpiring")
        private Date timeExpiring;
        @JsonProperty(value="defaultTablespace")
        private String defaultTablespace;
        @JsonProperty(value="tempTablespace")
        private String tempTablespace;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeLocked")
        private Date timeLocked;
        @JsonProperty(value="profile")
        private String profile;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder timeExpiring(Date timeExpiring) {
            this.timeExpiring = timeExpiring;
            this.__explicitlySet__.add("timeExpiring");
            return this;
        }

        public Builder defaultTablespace(String defaultTablespace) {
            this.defaultTablespace = defaultTablespace;
            this.__explicitlySet__.add("defaultTablespace");
            return this;
        }

        public Builder tempTablespace(String tempTablespace) {
            this.tempTablespace = tempTablespace;
            this.__explicitlySet__.add("tempTablespace");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeLocked(Date timeLocked) {
            this.timeLocked = timeLocked;
            this.__explicitlySet__.add("timeLocked");
            return this;
        }

        public Builder profile(String profile) {
            this.profile = profile;
            this.__explicitlySet__.add("profile");
            return this;
        }

        public UserSummary build() {
            UserSummary model = new UserSummary(this.name, this.status, this.timeExpiring, this.defaultTablespace, this.tempTablespace, this.timeCreated, this.timeLocked, this.profile);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UserSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("timeExpiring")) {
                this.timeExpiring(model.getTimeExpiring());
            }
            if (model.wasPropertyExplicitlySet("defaultTablespace")) {
                this.defaultTablespace(model.getDefaultTablespace());
            }
            if (model.wasPropertyExplicitlySet("tempTablespace")) {
                this.tempTablespace(model.getTempTablespace());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeLocked")) {
                this.timeLocked(model.getTimeLocked());
            }
            if (model.wasPropertyExplicitlySet("profile")) {
                this.profile(model.getProfile());
            }
            return this;
        }
    }
}

