/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.Datafile;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TablespaceSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="blockSizeBytes")
    private final BigDecimal blockSizeBytes;
    @JsonProperty(value="logging")
    private final Logging logging;
    @JsonProperty(value="isForceLogging")
    private final Boolean isForceLogging;
    @JsonProperty(value="extentManagement")
    private final ExtentManagement extentManagement;
    @JsonProperty(value="allocationType")
    private final AllocationType allocationType;
    @JsonProperty(value="isPluggedIn")
    private final Boolean isPluggedIn;
    @JsonProperty(value="segmentSpaceManagement")
    private final SegmentSpaceManagement segmentSpaceManagement;
    @JsonProperty(value="defaultTableCompression")
    private final DefaultTableCompression defaultTableCompression;
    @JsonProperty(value="retention")
    private final Retention retention;
    @JsonProperty(value="isBigfile")
    private final Boolean isBigfile;
    @JsonProperty(value="predicateEvaluation")
    private final PredicateEvaluation predicateEvaluation;
    @JsonProperty(value="isEncrypted")
    private final Boolean isEncrypted;
    @JsonProperty(value="compressFor")
    private final CompressFor compressFor;
    @JsonProperty(value="defaultInMemory")
    private final DefaultInMemory defaultInMemory;
    @JsonProperty(value="defaultInMemoryPriority")
    private final DefaultInMemoryPriority defaultInMemoryPriority;
    @JsonProperty(value="defaultInMemoryDistribute")
    private final DefaultInMemoryDistribute defaultInMemoryDistribute;
    @JsonProperty(value="defaultInMemoryCompression")
    private final DefaultInMemoryCompression defaultInMemoryCompression;
    @JsonProperty(value="defaultInMemoryDuplicate")
    private final DefaultInMemoryDuplicate defaultInMemoryDuplicate;
    @JsonProperty(value="shared")
    private final Shared shared;
    @JsonProperty(value="defaultIndexCompression")
    private final DefaultIndexCompression defaultIndexCompression;
    @JsonProperty(value="indexCompressFor")
    private final IndexCompressFor indexCompressFor;
    @JsonProperty(value="defaultCellMemory")
    private final String defaultCellMemory;
    @JsonProperty(value="defaultInMemoryService")
    private final DefaultInMemoryService defaultInMemoryService;
    @JsonProperty(value="defaultInMemoryServiceName")
    private final String defaultInMemoryServiceName;
    @JsonProperty(value="lostWriteProtect")
    private final LostWriteProtect lostWriteProtect;
    @JsonProperty(value="isChunkTablespace")
    private final Boolean isChunkTablespace;
    @JsonProperty(value="tempGroup")
    private final String tempGroup;
    @JsonProperty(value="maxSizeKB")
    private final BigDecimal maxSizeKB;
    @JsonProperty(value="allocatedSizeKB")
    private final BigDecimal allocatedSizeKB;
    @JsonProperty(value="userSizeKB")
    private final BigDecimal userSizeKB;
    @JsonProperty(value="freeSpaceKB")
    private final BigDecimal freeSpaceKB;
    @JsonProperty(value="usedSpaceKB")
    private final BigDecimal usedSpaceKB;
    @JsonProperty(value="usedPercentAvailable")
    private final Double usedPercentAvailable;
    @JsonProperty(value="usedPercentAllocated")
    private final Double usedPercentAllocated;
    @JsonProperty(value="isDefault")
    private final Boolean isDefault;
    @JsonProperty(value="datafiles")
    private final List<Datafile> datafiles;

    @Deprecated
    @ConstructorProperties(value={"name", "type", "status", "blockSizeBytes", "logging", "isForceLogging", "extentManagement", "allocationType", "isPluggedIn", "segmentSpaceManagement", "defaultTableCompression", "retention", "isBigfile", "predicateEvaluation", "isEncrypted", "compressFor", "defaultInMemory", "defaultInMemoryPriority", "defaultInMemoryDistribute", "defaultInMemoryCompression", "defaultInMemoryDuplicate", "shared", "defaultIndexCompression", "indexCompressFor", "defaultCellMemory", "defaultInMemoryService", "defaultInMemoryServiceName", "lostWriteProtect", "isChunkTablespace", "tempGroup", "maxSizeKB", "allocatedSizeKB", "userSizeKB", "freeSpaceKB", "usedSpaceKB", "usedPercentAvailable", "usedPercentAllocated", "isDefault", "datafiles"})
    public TablespaceSummary(String name, Type type, Status status, BigDecimal blockSizeBytes, Logging logging, Boolean isForceLogging, ExtentManagement extentManagement, AllocationType allocationType, Boolean isPluggedIn, SegmentSpaceManagement segmentSpaceManagement, DefaultTableCompression defaultTableCompression, Retention retention, Boolean isBigfile, PredicateEvaluation predicateEvaluation, Boolean isEncrypted, CompressFor compressFor, DefaultInMemory defaultInMemory, DefaultInMemoryPriority defaultInMemoryPriority, DefaultInMemoryDistribute defaultInMemoryDistribute, DefaultInMemoryCompression defaultInMemoryCompression, DefaultInMemoryDuplicate defaultInMemoryDuplicate, Shared shared, DefaultIndexCompression defaultIndexCompression, IndexCompressFor indexCompressFor, String defaultCellMemory, DefaultInMemoryService defaultInMemoryService, String defaultInMemoryServiceName, LostWriteProtect lostWriteProtect, Boolean isChunkTablespace, String tempGroup, BigDecimal maxSizeKB, BigDecimal allocatedSizeKB, BigDecimal userSizeKB, BigDecimal freeSpaceKB, BigDecimal usedSpaceKB, Double usedPercentAvailable, Double usedPercentAllocated, Boolean isDefault, List<Datafile> datafiles) {
        this.name = name;
        this.type = type;
        this.status = status;
        this.blockSizeBytes = blockSizeBytes;
        this.logging = logging;
        this.isForceLogging = isForceLogging;
        this.extentManagement = extentManagement;
        this.allocationType = allocationType;
        this.isPluggedIn = isPluggedIn;
        this.segmentSpaceManagement = segmentSpaceManagement;
        this.defaultTableCompression = defaultTableCompression;
        this.retention = retention;
        this.isBigfile = isBigfile;
        this.predicateEvaluation = predicateEvaluation;
        this.isEncrypted = isEncrypted;
        this.compressFor = compressFor;
        this.defaultInMemory = defaultInMemory;
        this.defaultInMemoryPriority = defaultInMemoryPriority;
        this.defaultInMemoryDistribute = defaultInMemoryDistribute;
        this.defaultInMemoryCompression = defaultInMemoryCompression;
        this.defaultInMemoryDuplicate = defaultInMemoryDuplicate;
        this.shared = shared;
        this.defaultIndexCompression = defaultIndexCompression;
        this.indexCompressFor = indexCompressFor;
        this.defaultCellMemory = defaultCellMemory;
        this.defaultInMemoryService = defaultInMemoryService;
        this.defaultInMemoryServiceName = defaultInMemoryServiceName;
        this.lostWriteProtect = lostWriteProtect;
        this.isChunkTablespace = isChunkTablespace;
        this.tempGroup = tempGroup;
        this.maxSizeKB = maxSizeKB;
        this.allocatedSizeKB = allocatedSizeKB;
        this.userSizeKB = userSizeKB;
        this.freeSpaceKB = freeSpaceKB;
        this.usedSpaceKB = usedSpaceKB;
        this.usedPercentAvailable = usedPercentAvailable;
        this.usedPercentAllocated = usedPercentAllocated;
        this.isDefault = isDefault;
        this.datafiles = datafiles;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Status getStatus() {
        return this.status;
    }

    public BigDecimal getBlockSizeBytes() {
        return this.blockSizeBytes;
    }

    public Logging getLogging() {
        return this.logging;
    }

    public Boolean getIsForceLogging() {
        return this.isForceLogging;
    }

    public ExtentManagement getExtentManagement() {
        return this.extentManagement;
    }

    public AllocationType getAllocationType() {
        return this.allocationType;
    }

    public Boolean getIsPluggedIn() {
        return this.isPluggedIn;
    }

    public SegmentSpaceManagement getSegmentSpaceManagement() {
        return this.segmentSpaceManagement;
    }

    public DefaultTableCompression getDefaultTableCompression() {
        return this.defaultTableCompression;
    }

    public Retention getRetention() {
        return this.retention;
    }

    public Boolean getIsBigfile() {
        return this.isBigfile;
    }

    public PredicateEvaluation getPredicateEvaluation() {
        return this.predicateEvaluation;
    }

    public Boolean getIsEncrypted() {
        return this.isEncrypted;
    }

    public CompressFor getCompressFor() {
        return this.compressFor;
    }

    public DefaultInMemory getDefaultInMemory() {
        return this.defaultInMemory;
    }

    public DefaultInMemoryPriority getDefaultInMemoryPriority() {
        return this.defaultInMemoryPriority;
    }

    public DefaultInMemoryDistribute getDefaultInMemoryDistribute() {
        return this.defaultInMemoryDistribute;
    }

    public DefaultInMemoryCompression getDefaultInMemoryCompression() {
        return this.defaultInMemoryCompression;
    }

    public DefaultInMemoryDuplicate getDefaultInMemoryDuplicate() {
        return this.defaultInMemoryDuplicate;
    }

    public Shared getShared() {
        return this.shared;
    }

    public DefaultIndexCompression getDefaultIndexCompression() {
        return this.defaultIndexCompression;
    }

    public IndexCompressFor getIndexCompressFor() {
        return this.indexCompressFor;
    }

    public String getDefaultCellMemory() {
        return this.defaultCellMemory;
    }

    public DefaultInMemoryService getDefaultInMemoryService() {
        return this.defaultInMemoryService;
    }

    public String getDefaultInMemoryServiceName() {
        return this.defaultInMemoryServiceName;
    }

    public LostWriteProtect getLostWriteProtect() {
        return this.lostWriteProtect;
    }

    public Boolean getIsChunkTablespace() {
        return this.isChunkTablespace;
    }

    public String getTempGroup() {
        return this.tempGroup;
    }

    public BigDecimal getMaxSizeKB() {
        return this.maxSizeKB;
    }

    public BigDecimal getAllocatedSizeKB() {
        return this.allocatedSizeKB;
    }

    public BigDecimal getUserSizeKB() {
        return this.userSizeKB;
    }

    public BigDecimal getFreeSpaceKB() {
        return this.freeSpaceKB;
    }

    public BigDecimal getUsedSpaceKB() {
        return this.usedSpaceKB;
    }

    public Double getUsedPercentAvailable() {
        return this.usedPercentAvailable;
    }

    public Double getUsedPercentAllocated() {
        return this.usedPercentAllocated;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public List<Datafile> getDatafiles() {
        return this.datafiles;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TablespaceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", blockSizeBytes=").append(String.valueOf(this.blockSizeBytes));
        sb.append(", logging=").append(String.valueOf((Object)this.logging));
        sb.append(", isForceLogging=").append(String.valueOf(this.isForceLogging));
        sb.append(", extentManagement=").append(String.valueOf((Object)this.extentManagement));
        sb.append(", allocationType=").append(String.valueOf((Object)this.allocationType));
        sb.append(", isPluggedIn=").append(String.valueOf(this.isPluggedIn));
        sb.append(", segmentSpaceManagement=").append(String.valueOf((Object)this.segmentSpaceManagement));
        sb.append(", defaultTableCompression=").append(String.valueOf((Object)this.defaultTableCompression));
        sb.append(", retention=").append(String.valueOf((Object)this.retention));
        sb.append(", isBigfile=").append(String.valueOf(this.isBigfile));
        sb.append(", predicateEvaluation=").append(String.valueOf((Object)this.predicateEvaluation));
        sb.append(", isEncrypted=").append(String.valueOf(this.isEncrypted));
        sb.append(", compressFor=").append(String.valueOf((Object)this.compressFor));
        sb.append(", defaultInMemory=").append(String.valueOf((Object)this.defaultInMemory));
        sb.append(", defaultInMemoryPriority=").append(String.valueOf((Object)this.defaultInMemoryPriority));
        sb.append(", defaultInMemoryDistribute=").append(String.valueOf((Object)this.defaultInMemoryDistribute));
        sb.append(", defaultInMemoryCompression=").append(String.valueOf((Object)this.defaultInMemoryCompression));
        sb.append(", defaultInMemoryDuplicate=").append(String.valueOf((Object)this.defaultInMemoryDuplicate));
        sb.append(", shared=").append(String.valueOf((Object)this.shared));
        sb.append(", defaultIndexCompression=").append(String.valueOf((Object)this.defaultIndexCompression));
        sb.append(", indexCompressFor=").append(String.valueOf((Object)this.indexCompressFor));
        sb.append(", defaultCellMemory=").append(String.valueOf(this.defaultCellMemory));
        sb.append(", defaultInMemoryService=").append(String.valueOf((Object)this.defaultInMemoryService));
        sb.append(", defaultInMemoryServiceName=").append(String.valueOf(this.defaultInMemoryServiceName));
        sb.append(", lostWriteProtect=").append(String.valueOf((Object)this.lostWriteProtect));
        sb.append(", isChunkTablespace=").append(String.valueOf(this.isChunkTablespace));
        sb.append(", tempGroup=").append(String.valueOf(this.tempGroup));
        sb.append(", maxSizeKB=").append(String.valueOf(this.maxSizeKB));
        sb.append(", allocatedSizeKB=").append(String.valueOf(this.allocatedSizeKB));
        sb.append(", userSizeKB=").append(String.valueOf(this.userSizeKB));
        sb.append(", freeSpaceKB=").append(String.valueOf(this.freeSpaceKB));
        sb.append(", usedSpaceKB=").append(String.valueOf(this.usedSpaceKB));
        sb.append(", usedPercentAvailable=").append(String.valueOf(this.usedPercentAvailable));
        sb.append(", usedPercentAllocated=").append(String.valueOf(this.usedPercentAllocated));
        sb.append(", isDefault=").append(String.valueOf(this.isDefault));
        sb.append(", datafiles=").append(String.valueOf(this.datafiles));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TablespaceSummary)) {
            return false;
        }
        TablespaceSummary other = (TablespaceSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.blockSizeBytes, other.blockSizeBytes) && Objects.equals((Object)this.logging, (Object)other.logging) && Objects.equals(this.isForceLogging, other.isForceLogging) && Objects.equals((Object)this.extentManagement, (Object)other.extentManagement) && Objects.equals((Object)this.allocationType, (Object)other.allocationType) && Objects.equals(this.isPluggedIn, other.isPluggedIn) && Objects.equals((Object)this.segmentSpaceManagement, (Object)other.segmentSpaceManagement) && Objects.equals((Object)this.defaultTableCompression, (Object)other.defaultTableCompression) && Objects.equals((Object)this.retention, (Object)other.retention) && Objects.equals(this.isBigfile, other.isBigfile) && Objects.equals((Object)this.predicateEvaluation, (Object)other.predicateEvaluation) && Objects.equals(this.isEncrypted, other.isEncrypted) && Objects.equals((Object)this.compressFor, (Object)other.compressFor) && Objects.equals((Object)this.defaultInMemory, (Object)other.defaultInMemory) && Objects.equals((Object)this.defaultInMemoryPriority, (Object)other.defaultInMemoryPriority) && Objects.equals((Object)this.defaultInMemoryDistribute, (Object)other.defaultInMemoryDistribute) && Objects.equals((Object)this.defaultInMemoryCompression, (Object)other.defaultInMemoryCompression) && Objects.equals((Object)this.defaultInMemoryDuplicate, (Object)other.defaultInMemoryDuplicate) && Objects.equals((Object)this.shared, (Object)other.shared) && Objects.equals((Object)this.defaultIndexCompression, (Object)other.defaultIndexCompression) && Objects.equals((Object)this.indexCompressFor, (Object)other.indexCompressFor) && Objects.equals(this.defaultCellMemory, other.defaultCellMemory) && Objects.equals((Object)this.defaultInMemoryService, (Object)other.defaultInMemoryService) && Objects.equals(this.defaultInMemoryServiceName, other.defaultInMemoryServiceName) && Objects.equals((Object)this.lostWriteProtect, (Object)other.lostWriteProtect) && Objects.equals(this.isChunkTablespace, other.isChunkTablespace) && Objects.equals(this.tempGroup, other.tempGroup) && Objects.equals(this.maxSizeKB, other.maxSizeKB) && Objects.equals(this.allocatedSizeKB, other.allocatedSizeKB) && Objects.equals(this.userSizeKB, other.userSizeKB) && Objects.equals(this.freeSpaceKB, other.freeSpaceKB) && Objects.equals(this.usedSpaceKB, other.usedSpaceKB) && Objects.equals(this.usedPercentAvailable, other.usedPercentAvailable) && Objects.equals(this.usedPercentAllocated, other.usedPercentAllocated) && Objects.equals(this.isDefault, other.isDefault) && Objects.equals(this.datafiles, other.datafiles) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.blockSizeBytes == null ? 43 : this.blockSizeBytes.hashCode());
        result = result * 59 + (this.logging == null ? 43 : this.logging.hashCode());
        result = result * 59 + (this.isForceLogging == null ? 43 : this.isForceLogging.hashCode());
        result = result * 59 + (this.extentManagement == null ? 43 : this.extentManagement.hashCode());
        result = result * 59 + (this.allocationType == null ? 43 : this.allocationType.hashCode());
        result = result * 59 + (this.isPluggedIn == null ? 43 : this.isPluggedIn.hashCode());
        result = result * 59 + (this.segmentSpaceManagement == null ? 43 : this.segmentSpaceManagement.hashCode());
        result = result * 59 + (this.defaultTableCompression == null ? 43 : this.defaultTableCompression.hashCode());
        result = result * 59 + (this.retention == null ? 43 : this.retention.hashCode());
        result = result * 59 + (this.isBigfile == null ? 43 : this.isBigfile.hashCode());
        result = result * 59 + (this.predicateEvaluation == null ? 43 : this.predicateEvaluation.hashCode());
        result = result * 59 + (this.isEncrypted == null ? 43 : this.isEncrypted.hashCode());
        result = result * 59 + (this.compressFor == null ? 43 : this.compressFor.hashCode());
        result = result * 59 + (this.defaultInMemory == null ? 43 : this.defaultInMemory.hashCode());
        result = result * 59 + (this.defaultInMemoryPriority == null ? 43 : this.defaultInMemoryPriority.hashCode());
        result = result * 59 + (this.defaultInMemoryDistribute == null ? 43 : this.defaultInMemoryDistribute.hashCode());
        result = result * 59 + (this.defaultInMemoryCompression == null ? 43 : this.defaultInMemoryCompression.hashCode());
        result = result * 59 + (this.defaultInMemoryDuplicate == null ? 43 : this.defaultInMemoryDuplicate.hashCode());
        result = result * 59 + (this.shared == null ? 43 : this.shared.hashCode());
        result = result * 59 + (this.defaultIndexCompression == null ? 43 : this.defaultIndexCompression.hashCode());
        result = result * 59 + (this.indexCompressFor == null ? 43 : this.indexCompressFor.hashCode());
        result = result * 59 + (this.defaultCellMemory == null ? 43 : this.defaultCellMemory.hashCode());
        result = result * 59 + (this.defaultInMemoryService == null ? 43 : this.defaultInMemoryService.hashCode());
        result = result * 59 + (this.defaultInMemoryServiceName == null ? 43 : this.defaultInMemoryServiceName.hashCode());
        result = result * 59 + (this.lostWriteProtect == null ? 43 : this.lostWriteProtect.hashCode());
        result = result * 59 + (this.isChunkTablespace == null ? 43 : this.isChunkTablespace.hashCode());
        result = result * 59 + (this.tempGroup == null ? 43 : this.tempGroup.hashCode());
        result = result * 59 + (this.maxSizeKB == null ? 43 : this.maxSizeKB.hashCode());
        result = result * 59 + (this.allocatedSizeKB == null ? 43 : this.allocatedSizeKB.hashCode());
        result = result * 59 + (this.userSizeKB == null ? 43 : this.userSizeKB.hashCode());
        result = result * 59 + (this.freeSpaceKB == null ? 43 : this.freeSpaceKB.hashCode());
        result = result * 59 + (this.usedSpaceKB == null ? 43 : this.usedSpaceKB.hashCode());
        result = result * 59 + (this.usedPercentAvailable == null ? 43 : this.usedPercentAvailable.hashCode());
        result = result * 59 + (this.usedPercentAllocated == null ? 43 : this.usedPercentAllocated.hashCode());
        result = result * 59 + (this.isDefault == null ? 43 : this.isDefault.hashCode());
        result = result * 59 + (this.datafiles == null ? 43 : this.datafiles.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LostWriteProtect implements BmcEnum
    {
        Enabled("ENABLED"),
        ProtectOff("PROTECT_OFF"),
        Suspend("SUSPEND"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LostWriteProtect> map;

        private LostWriteProtect(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LostWriteProtect create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LostWriteProtect', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LostWriteProtect.class);
            map = new HashMap<String, LostWriteProtect>();
            for (LostWriteProtect v : LostWriteProtect.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DefaultInMemoryService implements BmcEnum
    {
        Default("DEFAULT"),
        None("NONE"),
        All("ALL"),
        UserDefined("USER_DEFINED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DefaultInMemoryService> map;

        private DefaultInMemoryService(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DefaultInMemoryService create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DefaultInMemoryService', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DefaultInMemoryService.class);
            map = new HashMap<String, DefaultInMemoryService>();
            for (DefaultInMemoryService v : DefaultInMemoryService.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum IndexCompressFor implements BmcEnum
    {
        AdvancedLow("ADVANCED_LOW"),
        AdvancedHigh("ADVANCED_HIGH"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, IndexCompressFor> map;

        private IndexCompressFor(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IndexCompressFor create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'IndexCompressFor', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(IndexCompressFor.class);
            map = new HashMap<String, IndexCompressFor>();
            for (IndexCompressFor v : IndexCompressFor.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DefaultIndexCompression implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DefaultIndexCompression> map;

        private DefaultIndexCompression(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DefaultIndexCompression create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DefaultIndexCompression', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DefaultIndexCompression.class);
            map = new HashMap<String, DefaultIndexCompression>();
            for (DefaultIndexCompression v : DefaultIndexCompression.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Shared implements BmcEnum
    {
        Shared("SHARED"),
        LocalOnLeaf("LOCAL_ON_LEAF"),
        LocalOnAll("LOCAL_ON_ALL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Shared> map;

        private Shared(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Shared create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Shared', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Shared.class);
            map = new HashMap<String, Shared>();
            for (Shared v : Shared.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DefaultInMemoryDuplicate implements BmcEnum
    {
        NoDuplicate("NO_DUPLICATE"),
        Duplicate("DUPLICATE"),
        DuplicateAll("DUPLICATE_ALL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DefaultInMemoryDuplicate> map;

        private DefaultInMemoryDuplicate(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DefaultInMemoryDuplicate create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DefaultInMemoryDuplicate', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DefaultInMemoryDuplicate.class);
            map = new HashMap<String, DefaultInMemoryDuplicate>();
            for (DefaultInMemoryDuplicate v : DefaultInMemoryDuplicate.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DefaultInMemoryCompression implements BmcEnum
    {
        NoMemcompress("NO_MEMCOMPRESS"),
        ForDml("FOR_DML"),
        ForQueryLow("FOR_QUERY_LOW"),
        ForQueryHigh("FOR_QUERY_HIGH"),
        ForCapacityLow("FOR_CAPACITY_LOW"),
        ForCapacityHigh("FOR_CAPACITY_HIGH"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DefaultInMemoryCompression> map;

        private DefaultInMemoryCompression(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DefaultInMemoryCompression create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DefaultInMemoryCompression', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DefaultInMemoryCompression.class);
            map = new HashMap<String, DefaultInMemoryCompression>();
            for (DefaultInMemoryCompression v : DefaultInMemoryCompression.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DefaultInMemoryDistribute implements BmcEnum
    {
        Auto("AUTO"),
        ByRowidRange("BY_ROWID_RANGE"),
        ByPartition("BY_PARTITION"),
        BySubpartition("BY_SUBPARTITION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DefaultInMemoryDistribute> map;

        private DefaultInMemoryDistribute(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DefaultInMemoryDistribute create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DefaultInMemoryDistribute', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DefaultInMemoryDistribute.class);
            map = new HashMap<String, DefaultInMemoryDistribute>();
            for (DefaultInMemoryDistribute v : DefaultInMemoryDistribute.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DefaultInMemoryPriority implements BmcEnum
    {
        Low("LOW"),
        Medium("MEDIUM"),
        High("HIGH"),
        Critical("CRITICAL"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DefaultInMemoryPriority> map;

        private DefaultInMemoryPriority(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DefaultInMemoryPriority create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DefaultInMemoryPriority', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DefaultInMemoryPriority.class);
            map = new HashMap<String, DefaultInMemoryPriority>();
            for (DefaultInMemoryPriority v : DefaultInMemoryPriority.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DefaultInMemory implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DefaultInMemory> map;

        private DefaultInMemory(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DefaultInMemory create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DefaultInMemory', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DefaultInMemory.class);
            map = new HashMap<String, DefaultInMemory>();
            for (DefaultInMemory v : DefaultInMemory.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum CompressFor implements BmcEnum
    {
        Basic("BASIC"),
        Advanced("ADVANCED"),
        QueryLow("QUERY_LOW"),
        QueryHigh("QUERY_HIGH"),
        ArchiveLow("ARCHIVE_LOW"),
        ArchiveHigh("ARCHIVE_HIGH"),
        DirectLoadOnly("DIRECT_LOAD_ONLY"),
        ForAllOperations("FOR_ALL_OPERATIONS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CompressFor> map;

        private CompressFor(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CompressFor create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CompressFor', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CompressFor.class);
            map = new HashMap<String, CompressFor>();
            for (CompressFor v : CompressFor.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PredicateEvaluation implements BmcEnum
    {
        Host("HOST"),
        Storage("STORAGE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PredicateEvaluation> map;

        private PredicateEvaluation(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PredicateEvaluation create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PredicateEvaluation', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PredicateEvaluation.class);
            map = new HashMap<String, PredicateEvaluation>();
            for (PredicateEvaluation v : PredicateEvaluation.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Retention implements BmcEnum
    {
        Guarantee("GUARANTEE"),
        Noguarantee("NOGUARANTEE"),
        NotApply("NOT_APPLY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Retention> map;

        private Retention(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Retention create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Retention', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Retention.class);
            map = new HashMap<String, Retention>();
            for (Retention v : Retention.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DefaultTableCompression implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DefaultTableCompression> map;

        private DefaultTableCompression(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DefaultTableCompression create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DefaultTableCompression', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DefaultTableCompression.class);
            map = new HashMap<String, DefaultTableCompression>();
            for (DefaultTableCompression v : DefaultTableCompression.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SegmentSpaceManagement implements BmcEnum
    {
        Manual("MANUAL"),
        Auto("AUTO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SegmentSpaceManagement> map;

        private SegmentSpaceManagement(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SegmentSpaceManagement create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SegmentSpaceManagement', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SegmentSpaceManagement.class);
            map = new HashMap<String, SegmentSpaceManagement>();
            for (SegmentSpaceManagement v : SegmentSpaceManagement.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AllocationType implements BmcEnum
    {
        System("SYSTEM"),
        Uniform("UNIFORM"),
        User("USER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AllocationType> map;

        private AllocationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AllocationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AllocationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AllocationType.class);
            map = new HashMap<String, AllocationType>();
            for (AllocationType v : AllocationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ExtentManagement implements BmcEnum
    {
        Local("LOCAL"),
        Dictionary("DICTIONARY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ExtentManagement> map;

        private ExtentManagement(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExtentManagement create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ExtentManagement', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ExtentManagement.class);
            map = new HashMap<String, ExtentManagement>();
            for (ExtentManagement v : ExtentManagement.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Logging implements BmcEnum
    {
        Logging("LOGGING"),
        Nologging("NOLOGGING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Logging> map;

        private Logging(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Logging create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Logging', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Logging.class);
            map = new HashMap<String, Logging>();
            for (Logging v : Logging.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        Online("ONLINE"),
        Offline("OFFLINE"),
        ReadOnly("READ_ONLY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Type implements BmcEnum
    {
        Undo("UNDO"),
        LostWriteProtection("LOST_WRITE_PROTECTION"),
        Permanent("PERMANENT"),
        Temporary("TEMPORARY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="blockSizeBytes")
        private BigDecimal blockSizeBytes;
        @JsonProperty(value="logging")
        private Logging logging;
        @JsonProperty(value="isForceLogging")
        private Boolean isForceLogging;
        @JsonProperty(value="extentManagement")
        private ExtentManagement extentManagement;
        @JsonProperty(value="allocationType")
        private AllocationType allocationType;
        @JsonProperty(value="isPluggedIn")
        private Boolean isPluggedIn;
        @JsonProperty(value="segmentSpaceManagement")
        private SegmentSpaceManagement segmentSpaceManagement;
        @JsonProperty(value="defaultTableCompression")
        private DefaultTableCompression defaultTableCompression;
        @JsonProperty(value="retention")
        private Retention retention;
        @JsonProperty(value="isBigfile")
        private Boolean isBigfile;
        @JsonProperty(value="predicateEvaluation")
        private PredicateEvaluation predicateEvaluation;
        @JsonProperty(value="isEncrypted")
        private Boolean isEncrypted;
        @JsonProperty(value="compressFor")
        private CompressFor compressFor;
        @JsonProperty(value="defaultInMemory")
        private DefaultInMemory defaultInMemory;
        @JsonProperty(value="defaultInMemoryPriority")
        private DefaultInMemoryPriority defaultInMemoryPriority;
        @JsonProperty(value="defaultInMemoryDistribute")
        private DefaultInMemoryDistribute defaultInMemoryDistribute;
        @JsonProperty(value="defaultInMemoryCompression")
        private DefaultInMemoryCompression defaultInMemoryCompression;
        @JsonProperty(value="defaultInMemoryDuplicate")
        private DefaultInMemoryDuplicate defaultInMemoryDuplicate;
        @JsonProperty(value="shared")
        private Shared shared;
        @JsonProperty(value="defaultIndexCompression")
        private DefaultIndexCompression defaultIndexCompression;
        @JsonProperty(value="indexCompressFor")
        private IndexCompressFor indexCompressFor;
        @JsonProperty(value="defaultCellMemory")
        private String defaultCellMemory;
        @JsonProperty(value="defaultInMemoryService")
        private DefaultInMemoryService defaultInMemoryService;
        @JsonProperty(value="defaultInMemoryServiceName")
        private String defaultInMemoryServiceName;
        @JsonProperty(value="lostWriteProtect")
        private LostWriteProtect lostWriteProtect;
        @JsonProperty(value="isChunkTablespace")
        private Boolean isChunkTablespace;
        @JsonProperty(value="tempGroup")
        private String tempGroup;
        @JsonProperty(value="maxSizeKB")
        private BigDecimal maxSizeKB;
        @JsonProperty(value="allocatedSizeKB")
        private BigDecimal allocatedSizeKB;
        @JsonProperty(value="userSizeKB")
        private BigDecimal userSizeKB;
        @JsonProperty(value="freeSpaceKB")
        private BigDecimal freeSpaceKB;
        @JsonProperty(value="usedSpaceKB")
        private BigDecimal usedSpaceKB;
        @JsonProperty(value="usedPercentAvailable")
        private Double usedPercentAvailable;
        @JsonProperty(value="usedPercentAllocated")
        private Double usedPercentAllocated;
        @JsonProperty(value="isDefault")
        private Boolean isDefault;
        @JsonProperty(value="datafiles")
        private List<Datafile> datafiles;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder blockSizeBytes(BigDecimal blockSizeBytes) {
            this.blockSizeBytes = blockSizeBytes;
            this.__explicitlySet__.add("blockSizeBytes");
            return this;
        }

        public Builder logging(Logging logging) {
            this.logging = logging;
            this.__explicitlySet__.add("logging");
            return this;
        }

        public Builder isForceLogging(Boolean isForceLogging) {
            this.isForceLogging = isForceLogging;
            this.__explicitlySet__.add("isForceLogging");
            return this;
        }

        public Builder extentManagement(ExtentManagement extentManagement) {
            this.extentManagement = extentManagement;
            this.__explicitlySet__.add("extentManagement");
            return this;
        }

        public Builder allocationType(AllocationType allocationType) {
            this.allocationType = allocationType;
            this.__explicitlySet__.add("allocationType");
            return this;
        }

        public Builder isPluggedIn(Boolean isPluggedIn) {
            this.isPluggedIn = isPluggedIn;
            this.__explicitlySet__.add("isPluggedIn");
            return this;
        }

        public Builder segmentSpaceManagement(SegmentSpaceManagement segmentSpaceManagement) {
            this.segmentSpaceManagement = segmentSpaceManagement;
            this.__explicitlySet__.add("segmentSpaceManagement");
            return this;
        }

        public Builder defaultTableCompression(DefaultTableCompression defaultTableCompression) {
            this.defaultTableCompression = defaultTableCompression;
            this.__explicitlySet__.add("defaultTableCompression");
            return this;
        }

        public Builder retention(Retention retention) {
            this.retention = retention;
            this.__explicitlySet__.add("retention");
            return this;
        }

        public Builder isBigfile(Boolean isBigfile) {
            this.isBigfile = isBigfile;
            this.__explicitlySet__.add("isBigfile");
            return this;
        }

        public Builder predicateEvaluation(PredicateEvaluation predicateEvaluation) {
            this.predicateEvaluation = predicateEvaluation;
            this.__explicitlySet__.add("predicateEvaluation");
            return this;
        }

        public Builder isEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            this.__explicitlySet__.add("isEncrypted");
            return this;
        }

        public Builder compressFor(CompressFor compressFor) {
            this.compressFor = compressFor;
            this.__explicitlySet__.add("compressFor");
            return this;
        }

        public Builder defaultInMemory(DefaultInMemory defaultInMemory) {
            this.defaultInMemory = defaultInMemory;
            this.__explicitlySet__.add("defaultInMemory");
            return this;
        }

        public Builder defaultInMemoryPriority(DefaultInMemoryPriority defaultInMemoryPriority) {
            this.defaultInMemoryPriority = defaultInMemoryPriority;
            this.__explicitlySet__.add("defaultInMemoryPriority");
            return this;
        }

        public Builder defaultInMemoryDistribute(DefaultInMemoryDistribute defaultInMemoryDistribute) {
            this.defaultInMemoryDistribute = defaultInMemoryDistribute;
            this.__explicitlySet__.add("defaultInMemoryDistribute");
            return this;
        }

        public Builder defaultInMemoryCompression(DefaultInMemoryCompression defaultInMemoryCompression) {
            this.defaultInMemoryCompression = defaultInMemoryCompression;
            this.__explicitlySet__.add("defaultInMemoryCompression");
            return this;
        }

        public Builder defaultInMemoryDuplicate(DefaultInMemoryDuplicate defaultInMemoryDuplicate) {
            this.defaultInMemoryDuplicate = defaultInMemoryDuplicate;
            this.__explicitlySet__.add("defaultInMemoryDuplicate");
            return this;
        }

        public Builder shared(Shared shared) {
            this.shared = shared;
            this.__explicitlySet__.add("shared");
            return this;
        }

        public Builder defaultIndexCompression(DefaultIndexCompression defaultIndexCompression) {
            this.defaultIndexCompression = defaultIndexCompression;
            this.__explicitlySet__.add("defaultIndexCompression");
            return this;
        }

        public Builder indexCompressFor(IndexCompressFor indexCompressFor) {
            this.indexCompressFor = indexCompressFor;
            this.__explicitlySet__.add("indexCompressFor");
            return this;
        }

        public Builder defaultCellMemory(String defaultCellMemory) {
            this.defaultCellMemory = defaultCellMemory;
            this.__explicitlySet__.add("defaultCellMemory");
            return this;
        }

        public Builder defaultInMemoryService(DefaultInMemoryService defaultInMemoryService) {
            this.defaultInMemoryService = defaultInMemoryService;
            this.__explicitlySet__.add("defaultInMemoryService");
            return this;
        }

        public Builder defaultInMemoryServiceName(String defaultInMemoryServiceName) {
            this.defaultInMemoryServiceName = defaultInMemoryServiceName;
            this.__explicitlySet__.add("defaultInMemoryServiceName");
            return this;
        }

        public Builder lostWriteProtect(LostWriteProtect lostWriteProtect) {
            this.lostWriteProtect = lostWriteProtect;
            this.__explicitlySet__.add("lostWriteProtect");
            return this;
        }

        public Builder isChunkTablespace(Boolean isChunkTablespace) {
            this.isChunkTablespace = isChunkTablespace;
            this.__explicitlySet__.add("isChunkTablespace");
            return this;
        }

        public Builder tempGroup(String tempGroup) {
            this.tempGroup = tempGroup;
            this.__explicitlySet__.add("tempGroup");
            return this;
        }

        public Builder maxSizeKB(BigDecimal maxSizeKB) {
            this.maxSizeKB = maxSizeKB;
            this.__explicitlySet__.add("maxSizeKB");
            return this;
        }

        public Builder allocatedSizeKB(BigDecimal allocatedSizeKB) {
            this.allocatedSizeKB = allocatedSizeKB;
            this.__explicitlySet__.add("allocatedSizeKB");
            return this;
        }

        public Builder userSizeKB(BigDecimal userSizeKB) {
            this.userSizeKB = userSizeKB;
            this.__explicitlySet__.add("userSizeKB");
            return this;
        }

        public Builder freeSpaceKB(BigDecimal freeSpaceKB) {
            this.freeSpaceKB = freeSpaceKB;
            this.__explicitlySet__.add("freeSpaceKB");
            return this;
        }

        public Builder usedSpaceKB(BigDecimal usedSpaceKB) {
            this.usedSpaceKB = usedSpaceKB;
            this.__explicitlySet__.add("usedSpaceKB");
            return this;
        }

        public Builder usedPercentAvailable(Double usedPercentAvailable) {
            this.usedPercentAvailable = usedPercentAvailable;
            this.__explicitlySet__.add("usedPercentAvailable");
            return this;
        }

        public Builder usedPercentAllocated(Double usedPercentAllocated) {
            this.usedPercentAllocated = usedPercentAllocated;
            this.__explicitlySet__.add("usedPercentAllocated");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.__explicitlySet__.add("isDefault");
            return this;
        }

        public Builder datafiles(List<Datafile> datafiles) {
            this.datafiles = datafiles;
            this.__explicitlySet__.add("datafiles");
            return this;
        }

        public TablespaceSummary build() {
            TablespaceSummary model = new TablespaceSummary(this.name, this.type, this.status, this.blockSizeBytes, this.logging, this.isForceLogging, this.extentManagement, this.allocationType, this.isPluggedIn, this.segmentSpaceManagement, this.defaultTableCompression, this.retention, this.isBigfile, this.predicateEvaluation, this.isEncrypted, this.compressFor, this.defaultInMemory, this.defaultInMemoryPriority, this.defaultInMemoryDistribute, this.defaultInMemoryCompression, this.defaultInMemoryDuplicate, this.shared, this.defaultIndexCompression, this.indexCompressFor, this.defaultCellMemory, this.defaultInMemoryService, this.defaultInMemoryServiceName, this.lostWriteProtect, this.isChunkTablespace, this.tempGroup, this.maxSizeKB, this.allocatedSizeKB, this.userSizeKB, this.freeSpaceKB, this.usedSpaceKB, this.usedPercentAvailable, this.usedPercentAllocated, this.isDefault, this.datafiles);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TablespaceSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("blockSizeBytes")) {
                this.blockSizeBytes(model.getBlockSizeBytes());
            }
            if (model.wasPropertyExplicitlySet("logging")) {
                this.logging(model.getLogging());
            }
            if (model.wasPropertyExplicitlySet("isForceLogging")) {
                this.isForceLogging(model.getIsForceLogging());
            }
            if (model.wasPropertyExplicitlySet("extentManagement")) {
                this.extentManagement(model.getExtentManagement());
            }
            if (model.wasPropertyExplicitlySet("allocationType")) {
                this.allocationType(model.getAllocationType());
            }
            if (model.wasPropertyExplicitlySet("isPluggedIn")) {
                this.isPluggedIn(model.getIsPluggedIn());
            }
            if (model.wasPropertyExplicitlySet("segmentSpaceManagement")) {
                this.segmentSpaceManagement(model.getSegmentSpaceManagement());
            }
            if (model.wasPropertyExplicitlySet("defaultTableCompression")) {
                this.defaultTableCompression(model.getDefaultTableCompression());
            }
            if (model.wasPropertyExplicitlySet("retention")) {
                this.retention(model.getRetention());
            }
            if (model.wasPropertyExplicitlySet("isBigfile")) {
                this.isBigfile(model.getIsBigfile());
            }
            if (model.wasPropertyExplicitlySet("predicateEvaluation")) {
                this.predicateEvaluation(model.getPredicateEvaluation());
            }
            if (model.wasPropertyExplicitlySet("isEncrypted")) {
                this.isEncrypted(model.getIsEncrypted());
            }
            if (model.wasPropertyExplicitlySet("compressFor")) {
                this.compressFor(model.getCompressFor());
            }
            if (model.wasPropertyExplicitlySet("defaultInMemory")) {
                this.defaultInMemory(model.getDefaultInMemory());
            }
            if (model.wasPropertyExplicitlySet("defaultInMemoryPriority")) {
                this.defaultInMemoryPriority(model.getDefaultInMemoryPriority());
            }
            if (model.wasPropertyExplicitlySet("defaultInMemoryDistribute")) {
                this.defaultInMemoryDistribute(model.getDefaultInMemoryDistribute());
            }
            if (model.wasPropertyExplicitlySet("defaultInMemoryCompression")) {
                this.defaultInMemoryCompression(model.getDefaultInMemoryCompression());
            }
            if (model.wasPropertyExplicitlySet("defaultInMemoryDuplicate")) {
                this.defaultInMemoryDuplicate(model.getDefaultInMemoryDuplicate());
            }
            if (model.wasPropertyExplicitlySet("shared")) {
                this.shared(model.getShared());
            }
            if (model.wasPropertyExplicitlySet("defaultIndexCompression")) {
                this.defaultIndexCompression(model.getDefaultIndexCompression());
            }
            if (model.wasPropertyExplicitlySet("indexCompressFor")) {
                this.indexCompressFor(model.getIndexCompressFor());
            }
            if (model.wasPropertyExplicitlySet("defaultCellMemory")) {
                this.defaultCellMemory(model.getDefaultCellMemory());
            }
            if (model.wasPropertyExplicitlySet("defaultInMemoryService")) {
                this.defaultInMemoryService(model.getDefaultInMemoryService());
            }
            if (model.wasPropertyExplicitlySet("defaultInMemoryServiceName")) {
                this.defaultInMemoryServiceName(model.getDefaultInMemoryServiceName());
            }
            if (model.wasPropertyExplicitlySet("lostWriteProtect")) {
                this.lostWriteProtect(model.getLostWriteProtect());
            }
            if (model.wasPropertyExplicitlySet("isChunkTablespace")) {
                this.isChunkTablespace(model.getIsChunkTablespace());
            }
            if (model.wasPropertyExplicitlySet("tempGroup")) {
                this.tempGroup(model.getTempGroup());
            }
            if (model.wasPropertyExplicitlySet("maxSizeKB")) {
                this.maxSizeKB(model.getMaxSizeKB());
            }
            if (model.wasPropertyExplicitlySet("allocatedSizeKB")) {
                this.allocatedSizeKB(model.getAllocatedSizeKB());
            }
            if (model.wasPropertyExplicitlySet("userSizeKB")) {
                this.userSizeKB(model.getUserSizeKB());
            }
            if (model.wasPropertyExplicitlySet("freeSpaceKB")) {
                this.freeSpaceKB(model.getFreeSpaceKB());
            }
            if (model.wasPropertyExplicitlySet("usedSpaceKB")) {
                this.usedSpaceKB(model.getUsedSpaceKB());
            }
            if (model.wasPropertyExplicitlySet("usedPercentAvailable")) {
                this.usedPercentAvailable(model.getUsedPercentAvailable());
            }
            if (model.wasPropertyExplicitlySet("usedPercentAllocated")) {
                this.usedPercentAllocated(model.getUsedPercentAllocated());
            }
            if (model.wasPropertyExplicitlySet("isDefault")) {
                this.isDefault(model.getIsDefault());
            }
            if (model.wasPropertyExplicitlySet("datafiles")) {
                this.datafiles(model.getDatafiles());
            }
            return this;
        }
    }
}

