/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.MetricDataPoint;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class StatementsAggregateMetrics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="queuedStatements")
    private final MetricDataPoint queuedStatements;
    @JsonProperty(value="runningStatements")
    private final MetricDataPoint runningStatements;

    @Deprecated
    @ConstructorProperties(value={"queuedStatements", "runningStatements"})
    public StatementsAggregateMetrics(MetricDataPoint queuedStatements, MetricDataPoint runningStatements) {
        this.queuedStatements = queuedStatements;
        this.runningStatements = runningStatements;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public MetricDataPoint getQueuedStatements() {
        return this.queuedStatements;
    }

    public MetricDataPoint getRunningStatements() {
        return this.runningStatements;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StatementsAggregateMetrics(");
        sb.append("super=").append(super.toString());
        sb.append("queuedStatements=").append(String.valueOf((Object)this.queuedStatements));
        sb.append(", runningStatements=").append(String.valueOf((Object)this.runningStatements));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StatementsAggregateMetrics)) {
            return false;
        }
        StatementsAggregateMetrics other = (StatementsAggregateMetrics)((Object)o);
        return Objects.equals((Object)this.queuedStatements, (Object)other.queuedStatements) && Objects.equals((Object)this.runningStatements, (Object)other.runningStatements) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.queuedStatements == null ? 43 : this.queuedStatements.hashCode());
        result = result * 59 + (this.runningStatements == null ? 43 : this.runningStatements.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="queuedStatements")
        private MetricDataPoint queuedStatements;
        @JsonProperty(value="runningStatements")
        private MetricDataPoint runningStatements;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder queuedStatements(MetricDataPoint queuedStatements) {
            this.queuedStatements = queuedStatements;
            this.__explicitlySet__.add("queuedStatements");
            return this;
        }

        public Builder runningStatements(MetricDataPoint runningStatements) {
            this.runningStatements = runningStatements;
            this.__explicitlySet__.add("runningStatements");
            return this;
        }

        public StatementsAggregateMetrics build() {
            StatementsAggregateMetrics model = new StatementsAggregateMetrics(this.queuedStatements, this.runningStatements);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StatementsAggregateMetrics model) {
            if (model.wasPropertyExplicitlySet("queuedStatements")) {
                this.queuedStatements(model.getQueuedStatements());
            }
            if (model.wasPropertyExplicitlySet("runningStatements")) {
                this.runningStatements(model.getRunningStatements());
            }
            return this;
        }
    }
}

