/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.RecommendationExample;
import com.oracle.bmc.databasemanagement.model.RecommendationRationale;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Recommendation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="example")
    private final RecommendationExample example;
    @JsonProperty(value="rationales")
    private final List<RecommendationRationale> rationales;

    @Deprecated
    @ConstructorProperties(value={"message", "example", "rationales"})
    public Recommendation(String message, RecommendationExample example, List<RecommendationRationale> rationales) {
        this.message = message;
        this.example = example;
        this.rationales = rationales;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getMessage() {
        return this.message;
    }

    public RecommendationExample getExample() {
        return this.example;
    }

    public List<RecommendationRationale> getRationales() {
        return this.rationales;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Recommendation(");
        sb.append("super=").append(super.toString());
        sb.append("message=").append(String.valueOf(this.message));
        sb.append(", example=").append(String.valueOf((Object)this.example));
        sb.append(", rationales=").append(String.valueOf(this.rationales));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Recommendation)) {
            return false;
        }
        Recommendation other = (Recommendation)((Object)o);
        return Objects.equals(this.message, other.message) && Objects.equals((Object)this.example, (Object)other.example) && Objects.equals(this.rationales, other.rationales) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.message == null ? 43 : this.message.hashCode());
        result = result * 59 + (this.example == null ? 43 : this.example.hashCode());
        result = result * 59 + (this.rationales == null ? 43 : this.rationales.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="example")
        private RecommendationExample example;
        @JsonProperty(value="rationales")
        private List<RecommendationRationale> rationales;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public Builder example(RecommendationExample example) {
            this.example = example;
            this.__explicitlySet__.add("example");
            return this;
        }

        public Builder rationales(List<RecommendationRationale> rationales) {
            this.rationales = rationales;
            this.__explicitlySet__.add("rationales");
            return this;
        }

        public Recommendation build() {
            Recommendation model = new Recommendation(this.message, this.example, this.rationales);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Recommendation model) {
            if (model.wasPropertyExplicitlySet("message")) {
                this.message(model.getMessage());
            }
            if (model.wasPropertyExplicitlySet("example")) {
                this.example(model.getExample());
            }
            if (model.wasPropertyExplicitlySet("rationales")) {
                this.rationales(model.getRationales());
            }
            return this;
        }
    }
}

