/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.databasemanagement.model.ManagedDatabasePasswordCredential;
import com.oracle.bmc.databasemanagement.model.ManagedDatabaseSecretCredential;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="credentialType", defaultImpl=ManagedDatabaseCredential.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ManagedDatabasePasswordCredential.class, name="PASSWORD"), @JsonSubTypes.Type(value=ManagedDatabaseSecretCredential.class, name="SECRET")})
@JsonFilter(value="explicitlySetFilter")
public class ManagedDatabaseCredential
extends ExplicitlySetBmcModel {
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="role")
    private final Role role;

    @Deprecated
    @ConstructorProperties(value={"username", "role"})
    protected ManagedDatabaseCredential(String username, Role role) {
        this.username = username;
        this.role = role;
    }

    public String getUsername() {
        return this.username;
    }

    public Role getRole() {
        return this.role;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ManagedDatabaseCredential(");
        sb.append("super=").append(super.toString());
        sb.append("username=").append(String.valueOf(this.username));
        sb.append(", role=").append(String.valueOf((Object)this.role));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManagedDatabaseCredential)) {
            return false;
        }
        ManagedDatabaseCredential other = (ManagedDatabaseCredential)((Object)o);
        return Objects.equals(this.username, other.username) && Objects.equals((Object)this.role, (Object)other.role) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.username == null ? 43 : this.username.hashCode());
        result = result * 59 + (this.role == null ? 43 : this.role.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum CredentialType implements BmcEnum
    {
        Secret("SECRET"),
        Password("PASSWORD");

        private final String value;
        private static Map<String, CredentialType> map;

        private CredentialType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CredentialType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid CredentialType: " + key);
        }

        static {
            map = new HashMap<String, CredentialType>();
            for (CredentialType v : CredentialType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Role implements BmcEnum
    {
        Normal("NORMAL"),
        Sysdba("SYSDBA");

        private final String value;
        private static Map<String, Role> map;

        private Role(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Role create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Role: " + key);
        }

        static {
            map = new HashMap<String, Role>();
            for (Role v : Role.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

