/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.databasemanagement.model.DatabaseSubType;
import com.oracle.bmc.databasemanagement.model.JobDatabase;
import com.oracle.bmc.databasemanagement.model.JobExecutionResultLocation;
import com.oracle.bmc.databasemanagement.model.JobScheduleDetails;
import com.oracle.bmc.databasemanagement.model.SqlJob;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="jobType", defaultImpl=Job.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=SqlJob.class, name="SQL")})
@JsonFilter(value="explicitlySetFilter")
public class Job
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="managedDatabaseGroupId")
    private final String managedDatabaseGroupId;
    @JsonProperty(value="managedDatabaseId")
    private final String managedDatabaseId;
    @JsonProperty(value="managedDatabasesDetails")
    private final List<JobDatabase> managedDatabasesDetails;
    @JsonProperty(value="databaseSubType")
    private final DatabaseSubType databaseSubType;
    @JsonProperty(value="scheduleType")
    private final ScheduleType scheduleType;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="timeout")
    private final String timeout;
    @JsonProperty(value="resultLocation")
    private final JobExecutionResultLocation resultLocation;
    @JsonProperty(value="scheduleDetails")
    private final JobScheduleDetails scheduleDetails;
    @JsonProperty(value="submissionErrorMessage")
    private final String submissionErrorMessage;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "name", "description", "managedDatabaseGroupId", "managedDatabaseId", "managedDatabasesDetails", "databaseSubType", "scheduleType", "lifecycleState", "timeout", "resultLocation", "scheduleDetails", "submissionErrorMessage", "timeCreated", "timeUpdated"})
    protected Job(String id, String compartmentId, String name, String description, String managedDatabaseGroupId, String managedDatabaseId, List<JobDatabase> managedDatabasesDetails, DatabaseSubType databaseSubType, ScheduleType scheduleType, LifecycleState lifecycleState, String timeout, JobExecutionResultLocation resultLocation, JobScheduleDetails scheduleDetails, String submissionErrorMessage, Date timeCreated, Date timeUpdated) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.name = name;
        this.description = description;
        this.managedDatabaseGroupId = managedDatabaseGroupId;
        this.managedDatabaseId = managedDatabaseId;
        this.managedDatabasesDetails = managedDatabasesDetails;
        this.databaseSubType = databaseSubType;
        this.scheduleType = scheduleType;
        this.lifecycleState = lifecycleState;
        this.timeout = timeout;
        this.resultLocation = resultLocation;
        this.scheduleDetails = scheduleDetails;
        this.submissionErrorMessage = submissionErrorMessage;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getManagedDatabaseGroupId() {
        return this.managedDatabaseGroupId;
    }

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public List<JobDatabase> getManagedDatabasesDetails() {
        return this.managedDatabasesDetails;
    }

    public DatabaseSubType getDatabaseSubType() {
        return this.databaseSubType;
    }

    public ScheduleType getScheduleType() {
        return this.scheduleType;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public JobExecutionResultLocation getResultLocation() {
        return this.resultLocation;
    }

    public JobScheduleDetails getScheduleDetails() {
        return this.scheduleDetails;
    }

    public String getSubmissionErrorMessage() {
        return this.submissionErrorMessage;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Job(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", managedDatabaseGroupId=").append(String.valueOf(this.managedDatabaseGroupId));
        sb.append(", managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(", managedDatabasesDetails=").append(String.valueOf(this.managedDatabasesDetails));
        sb.append(", databaseSubType=").append(String.valueOf((Object)this.databaseSubType));
        sb.append(", scheduleType=").append(String.valueOf((Object)this.scheduleType));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeout=").append(String.valueOf(this.timeout));
        sb.append(", resultLocation=").append(String.valueOf((Object)this.resultLocation));
        sb.append(", scheduleDetails=").append(String.valueOf((Object)this.scheduleDetails));
        sb.append(", submissionErrorMessage=").append(String.valueOf(this.submissionErrorMessage));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Job)) {
            return false;
        }
        Job other = (Job)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.managedDatabaseGroupId, other.managedDatabaseGroupId) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.managedDatabasesDetails, other.managedDatabasesDetails) && Objects.equals((Object)this.databaseSubType, (Object)other.databaseSubType) && Objects.equals((Object)this.scheduleType, (Object)other.scheduleType) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeout, other.timeout) && Objects.equals((Object)this.resultLocation, (Object)other.resultLocation) && Objects.equals((Object)this.scheduleDetails, (Object)other.scheduleDetails) && Objects.equals(this.submissionErrorMessage, other.submissionErrorMessage) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.managedDatabaseGroupId == null ? 43 : this.managedDatabaseGroupId.hashCode());
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.managedDatabasesDetails == null ? 43 : this.managedDatabasesDetails.hashCode());
        result = result * 59 + (this.databaseSubType == null ? 43 : this.databaseSubType.hashCode());
        result = result * 59 + (this.scheduleType == null ? 43 : this.scheduleType.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeout == null ? 43 : this.timeout.hashCode());
        result = result * 59 + (this.resultLocation == null ? 43 : this.resultLocation.hashCode());
        result = result * 59 + (this.scheduleDetails == null ? 43 : this.scheduleDetails.hashCode());
        result = result * 59 + (this.submissionErrorMessage == null ? 43 : this.submissionErrorMessage.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ScheduleType implements BmcEnum
    {
        Immediate("IMMEDIATE"),
        Later("LATER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ScheduleType> map;

        private ScheduleType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ScheduleType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ScheduleType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ScheduleType.class);
            map = new HashMap<String, ScheduleType>();
            for (ScheduleType v : ScheduleType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

