/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class HistoricAddmResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="isNewlyCreated")
    private final Boolean isNewlyCreated;
    @JsonProperty(value="taskName")
    private final String taskName;
    @JsonProperty(value="taskId")
    private final Long taskId;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="dbUser")
    private final String dbUser;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="howCreated")
    private final HowCreated howCreated;
    @JsonProperty(value="startSnapshotTime")
    private final Date startSnapshotTime;
    @JsonProperty(value="endSnapshotTime")
    private final Date endSnapshotTime;
    @JsonProperty(value="beginSnapshotId")
    private final Long beginSnapshotId;
    @JsonProperty(value="endSnapshotId")
    private final Long endSnapshotId;
    @JsonProperty(value="findings")
    private final Long findings;

    @Deprecated
    @ConstructorProperties(value={"isNewlyCreated", "taskName", "taskId", "description", "dbUser", "status", "timeCreated", "howCreated", "startSnapshotTime", "endSnapshotTime", "beginSnapshotId", "endSnapshotId", "findings"})
    public HistoricAddmResult(Boolean isNewlyCreated, String taskName, Long taskId, String description, String dbUser, Status status, Date timeCreated, HowCreated howCreated, Date startSnapshotTime, Date endSnapshotTime, Long beginSnapshotId, Long endSnapshotId, Long findings) {
        this.isNewlyCreated = isNewlyCreated;
        this.taskName = taskName;
        this.taskId = taskId;
        this.description = description;
        this.dbUser = dbUser;
        this.status = status;
        this.timeCreated = timeCreated;
        this.howCreated = howCreated;
        this.startSnapshotTime = startSnapshotTime;
        this.endSnapshotTime = endSnapshotTime;
        this.beginSnapshotId = beginSnapshotId;
        this.endSnapshotId = endSnapshotId;
        this.findings = findings;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Boolean getIsNewlyCreated() {
        return this.isNewlyCreated;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public Status getStatus() {
        return this.status;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public HowCreated getHowCreated() {
        return this.howCreated;
    }

    public Date getStartSnapshotTime() {
        return this.startSnapshotTime;
    }

    public Date getEndSnapshotTime() {
        return this.endSnapshotTime;
    }

    public Long getBeginSnapshotId() {
        return this.beginSnapshotId;
    }

    public Long getEndSnapshotId() {
        return this.endSnapshotId;
    }

    public Long getFindings() {
        return this.findings;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HistoricAddmResult(");
        sb.append("super=").append(super.toString());
        sb.append("isNewlyCreated=").append(String.valueOf(this.isNewlyCreated));
        sb.append(", taskName=").append(String.valueOf(this.taskName));
        sb.append(", taskId=").append(String.valueOf(this.taskId));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", dbUser=").append(String.valueOf(this.dbUser));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", howCreated=").append(String.valueOf((Object)this.howCreated));
        sb.append(", startSnapshotTime=").append(String.valueOf(this.startSnapshotTime));
        sb.append(", endSnapshotTime=").append(String.valueOf(this.endSnapshotTime));
        sb.append(", beginSnapshotId=").append(String.valueOf(this.beginSnapshotId));
        sb.append(", endSnapshotId=").append(String.valueOf(this.endSnapshotId));
        sb.append(", findings=").append(String.valueOf(this.findings));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HistoricAddmResult)) {
            return false;
        }
        HistoricAddmResult other = (HistoricAddmResult)((Object)o);
        return Objects.equals(this.isNewlyCreated, other.isNewlyCreated) && Objects.equals(this.taskName, other.taskName) && Objects.equals(this.taskId, other.taskId) && Objects.equals(this.description, other.description) && Objects.equals(this.dbUser, other.dbUser) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.howCreated, (Object)other.howCreated) && Objects.equals(this.startSnapshotTime, other.startSnapshotTime) && Objects.equals(this.endSnapshotTime, other.endSnapshotTime) && Objects.equals(this.beginSnapshotId, other.beginSnapshotId) && Objects.equals(this.endSnapshotId, other.endSnapshotId) && Objects.equals(this.findings, other.findings) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNewlyCreated == null ? 43 : this.isNewlyCreated.hashCode());
        result = result * 59 + (this.taskName == null ? 43 : this.taskName.hashCode());
        result = result * 59 + (this.taskId == null ? 43 : this.taskId.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.dbUser == null ? 43 : this.dbUser.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.howCreated == null ? 43 : this.howCreated.hashCode());
        result = result * 59 + (this.startSnapshotTime == null ? 43 : this.startSnapshotTime.hashCode());
        result = result * 59 + (this.endSnapshotTime == null ? 43 : this.endSnapshotTime.hashCode());
        result = result * 59 + (this.beginSnapshotId == null ? 43 : this.beginSnapshotId.hashCode());
        result = result * 59 + (this.endSnapshotId == null ? 43 : this.endSnapshotId.hashCode());
        result = result * 59 + (this.findings == null ? 43 : this.findings.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum HowCreated implements BmcEnum
    {
        Auto("AUTO"),
        Manual("MANUAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, HowCreated> map;

        private HowCreated(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static HowCreated create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'HowCreated', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(HowCreated.class);
            map = new HashMap<String, HowCreated>();
            for (HowCreated v : HowCreated.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        Initial("INITIAL"),
        Executing("EXECUTING"),
        Interrupted("INTERRUPTED"),
        Completed("COMPLETED"),
        Error("ERROR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isNewlyCreated")
        private Boolean isNewlyCreated;
        @JsonProperty(value="taskName")
        private String taskName;
        @JsonProperty(value="taskId")
        private Long taskId;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="dbUser")
        private String dbUser;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="howCreated")
        private HowCreated howCreated;
        @JsonProperty(value="startSnapshotTime")
        private Date startSnapshotTime;
        @JsonProperty(value="endSnapshotTime")
        private Date endSnapshotTime;
        @JsonProperty(value="beginSnapshotId")
        private Long beginSnapshotId;
        @JsonProperty(value="endSnapshotId")
        private Long endSnapshotId;
        @JsonProperty(value="findings")
        private Long findings;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isNewlyCreated(Boolean isNewlyCreated) {
            this.isNewlyCreated = isNewlyCreated;
            this.__explicitlySet__.add("isNewlyCreated");
            return this;
        }

        public Builder taskName(String taskName) {
            this.taskName = taskName;
            this.__explicitlySet__.add("taskName");
            return this;
        }

        public Builder taskId(Long taskId) {
            this.taskId = taskId;
            this.__explicitlySet__.add("taskId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            this.__explicitlySet__.add("dbUser");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder howCreated(HowCreated howCreated) {
            this.howCreated = howCreated;
            this.__explicitlySet__.add("howCreated");
            return this;
        }

        public Builder startSnapshotTime(Date startSnapshotTime) {
            this.startSnapshotTime = startSnapshotTime;
            this.__explicitlySet__.add("startSnapshotTime");
            return this;
        }

        public Builder endSnapshotTime(Date endSnapshotTime) {
            this.endSnapshotTime = endSnapshotTime;
            this.__explicitlySet__.add("endSnapshotTime");
            return this;
        }

        public Builder beginSnapshotId(Long beginSnapshotId) {
            this.beginSnapshotId = beginSnapshotId;
            this.__explicitlySet__.add("beginSnapshotId");
            return this;
        }

        public Builder endSnapshotId(Long endSnapshotId) {
            this.endSnapshotId = endSnapshotId;
            this.__explicitlySet__.add("endSnapshotId");
            return this;
        }

        public Builder findings(Long findings) {
            this.findings = findings;
            this.__explicitlySet__.add("findings");
            return this;
        }

        public HistoricAddmResult build() {
            HistoricAddmResult model = new HistoricAddmResult(this.isNewlyCreated, this.taskName, this.taskId, this.description, this.dbUser, this.status, this.timeCreated, this.howCreated, this.startSnapshotTime, this.endSnapshotTime, this.beginSnapshotId, this.endSnapshotId, this.findings);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HistoricAddmResult model) {
            if (model.wasPropertyExplicitlySet("isNewlyCreated")) {
                this.isNewlyCreated(model.getIsNewlyCreated());
            }
            if (model.wasPropertyExplicitlySet("taskName")) {
                this.taskName(model.getTaskName());
            }
            if (model.wasPropertyExplicitlySet("taskId")) {
                this.taskId(model.getTaskId());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("dbUser")) {
                this.dbUser(model.getDbUser());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("howCreated")) {
                this.howCreated(model.getHowCreated());
            }
            if (model.wasPropertyExplicitlySet("startSnapshotTime")) {
                this.startSnapshotTime(model.getStartSnapshotTime());
            }
            if (model.wasPropertyExplicitlySet("endSnapshotTime")) {
                this.endSnapshotTime(model.getEndSnapshotTime());
            }
            if (model.wasPropertyExplicitlySet("beginSnapshotId")) {
                this.beginSnapshotId(model.getBeginSnapshotId());
            }
            if (model.wasPropertyExplicitlySet("endSnapshotId")) {
                this.endSnapshotId(model.getEndSnapshotId());
            }
            if (model.wasPropertyExplicitlySet("findings")) {
                this.findings(model.getFindings());
            }
            return this;
        }
    }
}

