/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Datafile
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="onlineStatus")
    private final OnlineStatus onlineStatus;
    @JsonProperty(value="isAutoExtensible")
    private final Boolean isAutoExtensible;
    @JsonProperty(value="lostWriteProtect")
    private final LostWriteProtect lostWriteProtect;
    @JsonProperty(value="shared")
    private final Shared shared;
    @JsonProperty(value="instanceId")
    private final BigDecimal instanceId;
    @JsonProperty(value="maxSizeKB")
    private final BigDecimal maxSizeKB;
    @JsonProperty(value="allocatedSizeKB")
    private final BigDecimal allocatedSizeKB;
    @JsonProperty(value="userSizeKB")
    private final BigDecimal userSizeKB;
    @JsonProperty(value="incrementBy")
    private final BigDecimal incrementBy;
    @JsonProperty(value="freeSpaceKB")
    private final BigDecimal freeSpaceKB;
    @JsonProperty(value="usedSpaceKB")
    private final BigDecimal usedSpaceKB;
    @JsonProperty(value="usedPercentAvailable")
    private final Double usedPercentAvailable;
    @JsonProperty(value="usedPercentAllocated")
    private final Double usedPercentAllocated;

    @Deprecated
    @ConstructorProperties(value={"name", "status", "onlineStatus", "isAutoExtensible", "lostWriteProtect", "shared", "instanceId", "maxSizeKB", "allocatedSizeKB", "userSizeKB", "incrementBy", "freeSpaceKB", "usedSpaceKB", "usedPercentAvailable", "usedPercentAllocated"})
    public Datafile(String name, Status status, OnlineStatus onlineStatus, Boolean isAutoExtensible, LostWriteProtect lostWriteProtect, Shared shared, BigDecimal instanceId, BigDecimal maxSizeKB, BigDecimal allocatedSizeKB, BigDecimal userSizeKB, BigDecimal incrementBy, BigDecimal freeSpaceKB, BigDecimal usedSpaceKB, Double usedPercentAvailable, Double usedPercentAllocated) {
        this.name = name;
        this.status = status;
        this.onlineStatus = onlineStatus;
        this.isAutoExtensible = isAutoExtensible;
        this.lostWriteProtect = lostWriteProtect;
        this.shared = shared;
        this.instanceId = instanceId;
        this.maxSizeKB = maxSizeKB;
        this.allocatedSizeKB = allocatedSizeKB;
        this.userSizeKB = userSizeKB;
        this.incrementBy = incrementBy;
        this.freeSpaceKB = freeSpaceKB;
        this.usedSpaceKB = usedSpaceKB;
        this.usedPercentAvailable = usedPercentAvailable;
        this.usedPercentAllocated = usedPercentAllocated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public OnlineStatus getOnlineStatus() {
        return this.onlineStatus;
    }

    public Boolean getIsAutoExtensible() {
        return this.isAutoExtensible;
    }

    public LostWriteProtect getLostWriteProtect() {
        return this.lostWriteProtect;
    }

    public Shared getShared() {
        return this.shared;
    }

    public BigDecimal getInstanceId() {
        return this.instanceId;
    }

    public BigDecimal getMaxSizeKB() {
        return this.maxSizeKB;
    }

    public BigDecimal getAllocatedSizeKB() {
        return this.allocatedSizeKB;
    }

    public BigDecimal getUserSizeKB() {
        return this.userSizeKB;
    }

    public BigDecimal getIncrementBy() {
        return this.incrementBy;
    }

    public BigDecimal getFreeSpaceKB() {
        return this.freeSpaceKB;
    }

    public BigDecimal getUsedSpaceKB() {
        return this.usedSpaceKB;
    }

    public Double getUsedPercentAvailable() {
        return this.usedPercentAvailable;
    }

    public Double getUsedPercentAllocated() {
        return this.usedPercentAllocated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Datafile(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", onlineStatus=").append(String.valueOf((Object)this.onlineStatus));
        sb.append(", isAutoExtensible=").append(String.valueOf(this.isAutoExtensible));
        sb.append(", lostWriteProtect=").append(String.valueOf((Object)this.lostWriteProtect));
        sb.append(", shared=").append(String.valueOf((Object)this.shared));
        sb.append(", instanceId=").append(String.valueOf(this.instanceId));
        sb.append(", maxSizeKB=").append(String.valueOf(this.maxSizeKB));
        sb.append(", allocatedSizeKB=").append(String.valueOf(this.allocatedSizeKB));
        sb.append(", userSizeKB=").append(String.valueOf(this.userSizeKB));
        sb.append(", incrementBy=").append(String.valueOf(this.incrementBy));
        sb.append(", freeSpaceKB=").append(String.valueOf(this.freeSpaceKB));
        sb.append(", usedSpaceKB=").append(String.valueOf(this.usedSpaceKB));
        sb.append(", usedPercentAvailable=").append(String.valueOf(this.usedPercentAvailable));
        sb.append(", usedPercentAllocated=").append(String.valueOf(this.usedPercentAllocated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Datafile)) {
            return false;
        }
        Datafile other = (Datafile)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.onlineStatus, (Object)other.onlineStatus) && Objects.equals(this.isAutoExtensible, other.isAutoExtensible) && Objects.equals((Object)this.lostWriteProtect, (Object)other.lostWriteProtect) && Objects.equals((Object)this.shared, (Object)other.shared) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals(this.maxSizeKB, other.maxSizeKB) && Objects.equals(this.allocatedSizeKB, other.allocatedSizeKB) && Objects.equals(this.userSizeKB, other.userSizeKB) && Objects.equals(this.incrementBy, other.incrementBy) && Objects.equals(this.freeSpaceKB, other.freeSpaceKB) && Objects.equals(this.usedSpaceKB, other.usedSpaceKB) && Objects.equals(this.usedPercentAvailable, other.usedPercentAvailable) && Objects.equals(this.usedPercentAllocated, other.usedPercentAllocated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.onlineStatus == null ? 43 : this.onlineStatus.hashCode());
        result = result * 59 + (this.isAutoExtensible == null ? 43 : this.isAutoExtensible.hashCode());
        result = result * 59 + (this.lostWriteProtect == null ? 43 : this.lostWriteProtect.hashCode());
        result = result * 59 + (this.shared == null ? 43 : this.shared.hashCode());
        result = result * 59 + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result = result * 59 + (this.maxSizeKB == null ? 43 : this.maxSizeKB.hashCode());
        result = result * 59 + (this.allocatedSizeKB == null ? 43 : this.allocatedSizeKB.hashCode());
        result = result * 59 + (this.userSizeKB == null ? 43 : this.userSizeKB.hashCode());
        result = result * 59 + (this.incrementBy == null ? 43 : this.incrementBy.hashCode());
        result = result * 59 + (this.freeSpaceKB == null ? 43 : this.freeSpaceKB.hashCode());
        result = result * 59 + (this.usedSpaceKB == null ? 43 : this.usedSpaceKB.hashCode());
        result = result * 59 + (this.usedPercentAvailable == null ? 43 : this.usedPercentAvailable.hashCode());
        result = result * 59 + (this.usedPercentAllocated == null ? 43 : this.usedPercentAllocated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Shared implements BmcEnum
    {
        Shared("SHARED"),
        LocalForRim("LOCAL_FOR_RIM"),
        LocalForAll("LOCAL_FOR_ALL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Shared> map;

        private Shared(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Shared create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Shared', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Shared.class);
            map = new HashMap<String, Shared>();
            for (Shared v : Shared.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LostWriteProtect implements BmcEnum
    {
        Enabled("ENABLED"),
        ProtectOff("PROTECT_OFF"),
        Suspend("SUSPEND"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LostWriteProtect> map;

        private LostWriteProtect(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LostWriteProtect create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LostWriteProtect', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LostWriteProtect.class);
            map = new HashMap<String, LostWriteProtect>();
            for (LostWriteProtect v : LostWriteProtect.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum OnlineStatus implements BmcEnum
    {
        Sysoff("SYSOFF"),
        System("SYSTEM"),
        Offline("OFFLINE"),
        Online("ONLINE"),
        Recover("RECOVER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OnlineStatus> map;

        private OnlineStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OnlineStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OnlineStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OnlineStatus.class);
            map = new HashMap<String, OnlineStatus>();
            for (OnlineStatus v : OnlineStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        Available("AVAILABLE"),
        Invalid("INVALID"),
        Offline("OFFLINE"),
        Online("ONLINE"),
        Unknown("UNKNOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="onlineStatus")
        private OnlineStatus onlineStatus;
        @JsonProperty(value="isAutoExtensible")
        private Boolean isAutoExtensible;
        @JsonProperty(value="lostWriteProtect")
        private LostWriteProtect lostWriteProtect;
        @JsonProperty(value="shared")
        private Shared shared;
        @JsonProperty(value="instanceId")
        private BigDecimal instanceId;
        @JsonProperty(value="maxSizeKB")
        private BigDecimal maxSizeKB;
        @JsonProperty(value="allocatedSizeKB")
        private BigDecimal allocatedSizeKB;
        @JsonProperty(value="userSizeKB")
        private BigDecimal userSizeKB;
        @JsonProperty(value="incrementBy")
        private BigDecimal incrementBy;
        @JsonProperty(value="freeSpaceKB")
        private BigDecimal freeSpaceKB;
        @JsonProperty(value="usedSpaceKB")
        private BigDecimal usedSpaceKB;
        @JsonProperty(value="usedPercentAvailable")
        private Double usedPercentAvailable;
        @JsonProperty(value="usedPercentAllocated")
        private Double usedPercentAllocated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder onlineStatus(OnlineStatus onlineStatus) {
            this.onlineStatus = onlineStatus;
            this.__explicitlySet__.add("onlineStatus");
            return this;
        }

        public Builder isAutoExtensible(Boolean isAutoExtensible) {
            this.isAutoExtensible = isAutoExtensible;
            this.__explicitlySet__.add("isAutoExtensible");
            return this;
        }

        public Builder lostWriteProtect(LostWriteProtect lostWriteProtect) {
            this.lostWriteProtect = lostWriteProtect;
            this.__explicitlySet__.add("lostWriteProtect");
            return this;
        }

        public Builder shared(Shared shared) {
            this.shared = shared;
            this.__explicitlySet__.add("shared");
            return this;
        }

        public Builder instanceId(BigDecimal instanceId) {
            this.instanceId = instanceId;
            this.__explicitlySet__.add("instanceId");
            return this;
        }

        public Builder maxSizeKB(BigDecimal maxSizeKB) {
            this.maxSizeKB = maxSizeKB;
            this.__explicitlySet__.add("maxSizeKB");
            return this;
        }

        public Builder allocatedSizeKB(BigDecimal allocatedSizeKB) {
            this.allocatedSizeKB = allocatedSizeKB;
            this.__explicitlySet__.add("allocatedSizeKB");
            return this;
        }

        public Builder userSizeKB(BigDecimal userSizeKB) {
            this.userSizeKB = userSizeKB;
            this.__explicitlySet__.add("userSizeKB");
            return this;
        }

        public Builder incrementBy(BigDecimal incrementBy) {
            this.incrementBy = incrementBy;
            this.__explicitlySet__.add("incrementBy");
            return this;
        }

        public Builder freeSpaceKB(BigDecimal freeSpaceKB) {
            this.freeSpaceKB = freeSpaceKB;
            this.__explicitlySet__.add("freeSpaceKB");
            return this;
        }

        public Builder usedSpaceKB(BigDecimal usedSpaceKB) {
            this.usedSpaceKB = usedSpaceKB;
            this.__explicitlySet__.add("usedSpaceKB");
            return this;
        }

        public Builder usedPercentAvailable(Double usedPercentAvailable) {
            this.usedPercentAvailable = usedPercentAvailable;
            this.__explicitlySet__.add("usedPercentAvailable");
            return this;
        }

        public Builder usedPercentAllocated(Double usedPercentAllocated) {
            this.usedPercentAllocated = usedPercentAllocated;
            this.__explicitlySet__.add("usedPercentAllocated");
            return this;
        }

        public Datafile build() {
            Datafile model = new Datafile(this.name, this.status, this.onlineStatus, this.isAutoExtensible, this.lostWriteProtect, this.shared, this.instanceId, this.maxSizeKB, this.allocatedSizeKB, this.userSizeKB, this.incrementBy, this.freeSpaceKB, this.usedSpaceKB, this.usedPercentAvailable, this.usedPercentAllocated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Datafile model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("onlineStatus")) {
                this.onlineStatus(model.getOnlineStatus());
            }
            if (model.wasPropertyExplicitlySet("isAutoExtensible")) {
                this.isAutoExtensible(model.getIsAutoExtensible());
            }
            if (model.wasPropertyExplicitlySet("lostWriteProtect")) {
                this.lostWriteProtect(model.getLostWriteProtect());
            }
            if (model.wasPropertyExplicitlySet("shared")) {
                this.shared(model.getShared());
            }
            if (model.wasPropertyExplicitlySet("instanceId")) {
                this.instanceId(model.getInstanceId());
            }
            if (model.wasPropertyExplicitlySet("maxSizeKB")) {
                this.maxSizeKB(model.getMaxSizeKB());
            }
            if (model.wasPropertyExplicitlySet("allocatedSizeKB")) {
                this.allocatedSizeKB(model.getAllocatedSizeKB());
            }
            if (model.wasPropertyExplicitlySet("userSizeKB")) {
                this.userSizeKB(model.getUserSizeKB());
            }
            if (model.wasPropertyExplicitlySet("incrementBy")) {
                this.incrementBy(model.getIncrementBy());
            }
            if (model.wasPropertyExplicitlySet("freeSpaceKB")) {
                this.freeSpaceKB(model.getFreeSpaceKB());
            }
            if (model.wasPropertyExplicitlySet("usedSpaceKB")) {
                this.usedSpaceKB(model.getUsedSpaceKB());
            }
            if (model.wasPropertyExplicitlySet("usedPercentAvailable")) {
                this.usedPercentAvailable(model.getUsedPercentAvailable());
            }
            if (model.wasPropertyExplicitlySet("usedPercentAllocated")) {
                this.usedPercentAllocated(model.getUsedPercentAllocated());
            }
            return this;
        }
    }
}

