/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.AllowedParameterValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseParameterSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="value")
    private final String value;
    @JsonProperty(value="displayValue")
    private final String displayValue;
    @JsonProperty(value="number")
    private final BigDecimal number;
    @JsonProperty(value="isDefault")
    private final Boolean isDefault;
    @JsonProperty(value="isSessionModifiable")
    private final Boolean isSessionModifiable;
    @JsonProperty(value="isSystemModifiable")
    private final IsSystemModifiable isSystemModifiable;
    @JsonProperty(value="isPdbModifiable")
    private final Boolean isPdbModifiable;
    @JsonProperty(value="isInstanceModifiable")
    private final Boolean isInstanceModifiable;
    @JsonProperty(value="isModified")
    private final IsModified isModified;
    @JsonProperty(value="isAdjusted")
    private final Boolean isAdjusted;
    @JsonProperty(value="isDeprecated")
    private final Boolean isDeprecated;
    @JsonProperty(value="isBasic")
    private final Boolean isBasic;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="ordinal")
    private final BigDecimal ordinal;
    @JsonProperty(value="updateComment")
    private final String updateComment;
    @JsonProperty(value="containerId")
    private final BigDecimal containerId;
    @JsonProperty(value="category")
    private final String category;
    @JsonProperty(value="constraint")
    private final Constraint constraint;
    @JsonProperty(value="sid")
    private final String sid;
    @JsonProperty(value="isSpecified")
    private final Boolean isSpecified;
    @JsonProperty(value="allowedValues")
    private final List<AllowedParameterValue> allowedValues;

    @Deprecated
    @ConstructorProperties(value={"name", "type", "value", "displayValue", "number", "isDefault", "isSessionModifiable", "isSystemModifiable", "isPdbModifiable", "isInstanceModifiable", "isModified", "isAdjusted", "isDeprecated", "isBasic", "description", "ordinal", "updateComment", "containerId", "category", "constraint", "sid", "isSpecified", "allowedValues"})
    public DatabaseParameterSummary(String name, Type type, String value, String displayValue, BigDecimal number, Boolean isDefault, Boolean isSessionModifiable, IsSystemModifiable isSystemModifiable, Boolean isPdbModifiable, Boolean isInstanceModifiable, IsModified isModified, Boolean isAdjusted, Boolean isDeprecated, Boolean isBasic, String description, BigDecimal ordinal, String updateComment, BigDecimal containerId, String category, Constraint constraint, String sid, Boolean isSpecified, List<AllowedParameterValue> allowedValues) {
        this.name = name;
        this.type = type;
        this.value = value;
        this.displayValue = displayValue;
        this.number = number;
        this.isDefault = isDefault;
        this.isSessionModifiable = isSessionModifiable;
        this.isSystemModifiable = isSystemModifiable;
        this.isPdbModifiable = isPdbModifiable;
        this.isInstanceModifiable = isInstanceModifiable;
        this.isModified = isModified;
        this.isAdjusted = isAdjusted;
        this.isDeprecated = isDeprecated;
        this.isBasic = isBasic;
        this.description = description;
        this.ordinal = ordinal;
        this.updateComment = updateComment;
        this.containerId = containerId;
        this.category = category;
        this.constraint = constraint;
        this.sid = sid;
        this.isSpecified = isSpecified;
        this.allowedValues = allowedValues;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public BigDecimal getNumber() {
        return this.number;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public Boolean getIsSessionModifiable() {
        return this.isSessionModifiable;
    }

    public IsSystemModifiable getIsSystemModifiable() {
        return this.isSystemModifiable;
    }

    public Boolean getIsPdbModifiable() {
        return this.isPdbModifiable;
    }

    public Boolean getIsInstanceModifiable() {
        return this.isInstanceModifiable;
    }

    public IsModified getIsModified() {
        return this.isModified;
    }

    public Boolean getIsAdjusted() {
        return this.isAdjusted;
    }

    public Boolean getIsDeprecated() {
        return this.isDeprecated;
    }

    public Boolean getIsBasic() {
        return this.isBasic;
    }

    public String getDescription() {
        return this.description;
    }

    public BigDecimal getOrdinal() {
        return this.ordinal;
    }

    public String getUpdateComment() {
        return this.updateComment;
    }

    public BigDecimal getContainerId() {
        return this.containerId;
    }

    public String getCategory() {
        return this.category;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public String getSid() {
        return this.sid;
    }

    public Boolean getIsSpecified() {
        return this.isSpecified;
    }

    public List<AllowedParameterValue> getAllowedValues() {
        return this.allowedValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseParameterSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(", displayValue=").append(String.valueOf(this.displayValue));
        sb.append(", number=").append(String.valueOf(this.number));
        sb.append(", isDefault=").append(String.valueOf(this.isDefault));
        sb.append(", isSessionModifiable=").append(String.valueOf(this.isSessionModifiable));
        sb.append(", isSystemModifiable=").append(String.valueOf((Object)this.isSystemModifiable));
        sb.append(", isPdbModifiable=").append(String.valueOf(this.isPdbModifiable));
        sb.append(", isInstanceModifiable=").append(String.valueOf(this.isInstanceModifiable));
        sb.append(", isModified=").append(String.valueOf((Object)this.isModified));
        sb.append(", isAdjusted=").append(String.valueOf(this.isAdjusted));
        sb.append(", isDeprecated=").append(String.valueOf(this.isDeprecated));
        sb.append(", isBasic=").append(String.valueOf(this.isBasic));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", ordinal=").append(String.valueOf(this.ordinal));
        sb.append(", updateComment=").append(String.valueOf(this.updateComment));
        sb.append(", containerId=").append(String.valueOf(this.containerId));
        sb.append(", category=").append(String.valueOf(this.category));
        sb.append(", constraint=").append(String.valueOf((Object)this.constraint));
        sb.append(", sid=").append(String.valueOf(this.sid));
        sb.append(", isSpecified=").append(String.valueOf(this.isSpecified));
        sb.append(", allowedValues=").append(String.valueOf(this.allowedValues));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseParameterSummary)) {
            return false;
        }
        DatabaseParameterSummary other = (DatabaseParameterSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.value, other.value) && Objects.equals(this.displayValue, other.displayValue) && Objects.equals(this.number, other.number) && Objects.equals(this.isDefault, other.isDefault) && Objects.equals(this.isSessionModifiable, other.isSessionModifiable) && Objects.equals((Object)this.isSystemModifiable, (Object)other.isSystemModifiable) && Objects.equals(this.isPdbModifiable, other.isPdbModifiable) && Objects.equals(this.isInstanceModifiable, other.isInstanceModifiable) && Objects.equals((Object)this.isModified, (Object)other.isModified) && Objects.equals(this.isAdjusted, other.isAdjusted) && Objects.equals(this.isDeprecated, other.isDeprecated) && Objects.equals(this.isBasic, other.isBasic) && Objects.equals(this.description, other.description) && Objects.equals(this.ordinal, other.ordinal) && Objects.equals(this.updateComment, other.updateComment) && Objects.equals(this.containerId, other.containerId) && Objects.equals(this.category, other.category) && Objects.equals((Object)this.constraint, (Object)other.constraint) && Objects.equals(this.sid, other.sid) && Objects.equals(this.isSpecified, other.isSpecified) && Objects.equals(this.allowedValues, other.allowedValues) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.displayValue == null ? 43 : this.displayValue.hashCode());
        result = result * 59 + (this.number == null ? 43 : this.number.hashCode());
        result = result * 59 + (this.isDefault == null ? 43 : this.isDefault.hashCode());
        result = result * 59 + (this.isSessionModifiable == null ? 43 : this.isSessionModifiable.hashCode());
        result = result * 59 + (this.isSystemModifiable == null ? 43 : this.isSystemModifiable.hashCode());
        result = result * 59 + (this.isPdbModifiable == null ? 43 : this.isPdbModifiable.hashCode());
        result = result * 59 + (this.isInstanceModifiable == null ? 43 : this.isInstanceModifiable.hashCode());
        result = result * 59 + (this.isModified == null ? 43 : this.isModified.hashCode());
        result = result * 59 + (this.isAdjusted == null ? 43 : this.isAdjusted.hashCode());
        result = result * 59 + (this.isDeprecated == null ? 43 : this.isDeprecated.hashCode());
        result = result * 59 + (this.isBasic == null ? 43 : this.isBasic.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.ordinal == null ? 43 : this.ordinal.hashCode());
        result = result * 59 + (this.updateComment == null ? 43 : this.updateComment.hashCode());
        result = result * 59 + (this.containerId == null ? 43 : this.containerId.hashCode());
        result = result * 59 + (this.category == null ? 43 : this.category.hashCode());
        result = result * 59 + (this.constraint == null ? 43 : this.constraint.hashCode());
        result = result * 59 + (this.sid == null ? 43 : this.sid.hashCode());
        result = result * 59 + (this.isSpecified == null ? 43 : this.isSpecified.hashCode());
        result = result * 59 + (this.allowedValues == null ? 43 : this.allowedValues.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Constraint implements BmcEnum
    {
        Unique("UNIQUE"),
        Identical("IDENTICAL"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Constraint> map;

        private Constraint(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Constraint create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Constraint', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Constraint.class);
            map = new HashMap<String, Constraint>();
            for (Constraint v : Constraint.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum IsModified implements BmcEnum
    {
        Modified("MODIFIED"),
        False("FALSE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, IsModified> map;

        private IsModified(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IsModified create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'IsModified', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(IsModified.class);
            map = new HashMap<String, IsModified>();
            for (IsModified v : IsModified.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum IsSystemModifiable implements BmcEnum
    {
        Immediate("IMMEDIATE"),
        Deferred("DEFERRED"),
        False("FALSE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, IsSystemModifiable> map;

        private IsSystemModifiable(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IsSystemModifiable create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'IsSystemModifiable', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(IsSystemModifiable.class);
            map = new HashMap<String, IsSystemModifiable>();
            for (IsSystemModifiable v : IsSystemModifiable.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Type implements BmcEnum
    {
        Boolean("BOOLEAN"),
        String("STRING"),
        Integer("INTEGER"),
        Filename("FILENAME"),
        BigInteger("BIG_INTEGER"),
        Reserved("RESERVED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="value")
        private String value;
        @JsonProperty(value="displayValue")
        private String displayValue;
        @JsonProperty(value="number")
        private BigDecimal number;
        @JsonProperty(value="isDefault")
        private Boolean isDefault;
        @JsonProperty(value="isSessionModifiable")
        private Boolean isSessionModifiable;
        @JsonProperty(value="isSystemModifiable")
        private IsSystemModifiable isSystemModifiable;
        @JsonProperty(value="isPdbModifiable")
        private Boolean isPdbModifiable;
        @JsonProperty(value="isInstanceModifiable")
        private Boolean isInstanceModifiable;
        @JsonProperty(value="isModified")
        private IsModified isModified;
        @JsonProperty(value="isAdjusted")
        private Boolean isAdjusted;
        @JsonProperty(value="isDeprecated")
        private Boolean isDeprecated;
        @JsonProperty(value="isBasic")
        private Boolean isBasic;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="ordinal")
        private BigDecimal ordinal;
        @JsonProperty(value="updateComment")
        private String updateComment;
        @JsonProperty(value="containerId")
        private BigDecimal containerId;
        @JsonProperty(value="category")
        private String category;
        @JsonProperty(value="constraint")
        private Constraint constraint;
        @JsonProperty(value="sid")
        private String sid;
        @JsonProperty(value="isSpecified")
        private Boolean isSpecified;
        @JsonProperty(value="allowedValues")
        private List<AllowedParameterValue> allowedValues;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder displayValue(String displayValue) {
            this.displayValue = displayValue;
            this.__explicitlySet__.add("displayValue");
            return this;
        }

        public Builder number(BigDecimal number) {
            this.number = number;
            this.__explicitlySet__.add("number");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.__explicitlySet__.add("isDefault");
            return this;
        }

        public Builder isSessionModifiable(Boolean isSessionModifiable) {
            this.isSessionModifiable = isSessionModifiable;
            this.__explicitlySet__.add("isSessionModifiable");
            return this;
        }

        public Builder isSystemModifiable(IsSystemModifiable isSystemModifiable) {
            this.isSystemModifiable = isSystemModifiable;
            this.__explicitlySet__.add("isSystemModifiable");
            return this;
        }

        public Builder isPdbModifiable(Boolean isPdbModifiable) {
            this.isPdbModifiable = isPdbModifiable;
            this.__explicitlySet__.add("isPdbModifiable");
            return this;
        }

        public Builder isInstanceModifiable(Boolean isInstanceModifiable) {
            this.isInstanceModifiable = isInstanceModifiable;
            this.__explicitlySet__.add("isInstanceModifiable");
            return this;
        }

        public Builder isModified(IsModified isModified) {
            this.isModified = isModified;
            this.__explicitlySet__.add("isModified");
            return this;
        }

        public Builder isAdjusted(Boolean isAdjusted) {
            this.isAdjusted = isAdjusted;
            this.__explicitlySet__.add("isAdjusted");
            return this;
        }

        public Builder isDeprecated(Boolean isDeprecated) {
            this.isDeprecated = isDeprecated;
            this.__explicitlySet__.add("isDeprecated");
            return this;
        }

        public Builder isBasic(Boolean isBasic) {
            this.isBasic = isBasic;
            this.__explicitlySet__.add("isBasic");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder ordinal(BigDecimal ordinal) {
            this.ordinal = ordinal;
            this.__explicitlySet__.add("ordinal");
            return this;
        }

        public Builder updateComment(String updateComment) {
            this.updateComment = updateComment;
            this.__explicitlySet__.add("updateComment");
            return this;
        }

        public Builder containerId(BigDecimal containerId) {
            this.containerId = containerId;
            this.__explicitlySet__.add("containerId");
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder constraint(Constraint constraint) {
            this.constraint = constraint;
            this.__explicitlySet__.add("constraint");
            return this;
        }

        public Builder sid(String sid) {
            this.sid = sid;
            this.__explicitlySet__.add("sid");
            return this;
        }

        public Builder isSpecified(Boolean isSpecified) {
            this.isSpecified = isSpecified;
            this.__explicitlySet__.add("isSpecified");
            return this;
        }

        public Builder allowedValues(List<AllowedParameterValue> allowedValues) {
            this.allowedValues = allowedValues;
            this.__explicitlySet__.add("allowedValues");
            return this;
        }

        public DatabaseParameterSummary build() {
            DatabaseParameterSummary model = new DatabaseParameterSummary(this.name, this.type, this.value, this.displayValue, this.number, this.isDefault, this.isSessionModifiable, this.isSystemModifiable, this.isPdbModifiable, this.isInstanceModifiable, this.isModified, this.isAdjusted, this.isDeprecated, this.isBasic, this.description, this.ordinal, this.updateComment, this.containerId, this.category, this.constraint, this.sid, this.isSpecified, this.allowedValues);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseParameterSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("displayValue")) {
                this.displayValue(model.getDisplayValue());
            }
            if (model.wasPropertyExplicitlySet("number")) {
                this.number(model.getNumber());
            }
            if (model.wasPropertyExplicitlySet("isDefault")) {
                this.isDefault(model.getIsDefault());
            }
            if (model.wasPropertyExplicitlySet("isSessionModifiable")) {
                this.isSessionModifiable(model.getIsSessionModifiable());
            }
            if (model.wasPropertyExplicitlySet("isSystemModifiable")) {
                this.isSystemModifiable(model.getIsSystemModifiable());
            }
            if (model.wasPropertyExplicitlySet("isPdbModifiable")) {
                this.isPdbModifiable(model.getIsPdbModifiable());
            }
            if (model.wasPropertyExplicitlySet("isInstanceModifiable")) {
                this.isInstanceModifiable(model.getIsInstanceModifiable());
            }
            if (model.wasPropertyExplicitlySet("isModified")) {
                this.isModified(model.getIsModified());
            }
            if (model.wasPropertyExplicitlySet("isAdjusted")) {
                this.isAdjusted(model.getIsAdjusted());
            }
            if (model.wasPropertyExplicitlySet("isDeprecated")) {
                this.isDeprecated(model.getIsDeprecated());
            }
            if (model.wasPropertyExplicitlySet("isBasic")) {
                this.isBasic(model.getIsBasic());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("ordinal")) {
                this.ordinal(model.getOrdinal());
            }
            if (model.wasPropertyExplicitlySet("updateComment")) {
                this.updateComment(model.getUpdateComment());
            }
            if (model.wasPropertyExplicitlySet("containerId")) {
                this.containerId(model.getContainerId());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("constraint")) {
                this.constraint(model.getConstraint());
            }
            if (model.wasPropertyExplicitlySet("sid")) {
                this.sid(model.getSid());
            }
            if (model.wasPropertyExplicitlySet("isSpecified")) {
                this.isSpecified(model.getIsSpecified());
            }
            if (model.wasPropertyExplicitlySet("allowedValues")) {
                this.allowedValues(model.getAllowedValues());
            }
            return this;
        }
    }
}

