/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.ActivityTimeSeriesMetrics;
import com.oracle.bmc.databasemanagement.model.CpuUtilizationAggregateMetrics;
import com.oracle.bmc.databasemanagement.model.DatabaseIOAggregateMetrics;
import com.oracle.bmc.databasemanagement.model.DatabaseStorageAggregateMetrics;
import com.oracle.bmc.databasemanagement.model.DatabaseTimeAggregateMetrics;
import com.oracle.bmc.databasemanagement.model.FailedConnectionsAggregateMetrics;
import com.oracle.bmc.databasemanagement.model.MemoryAggregateMetrics;
import com.oracle.bmc.databasemanagement.model.StatementsAggregateMetrics;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseHomeMetricDefinition
extends ExplicitlySetBmcModel {
    @JsonProperty(value="activityTimeSeriesMetrics")
    private final List<ActivityTimeSeriesMetrics> activityTimeSeriesMetrics;
    @JsonProperty(value="dbTimeAggregateMetrics")
    private final DatabaseTimeAggregateMetrics dbTimeAggregateMetrics;
    @JsonProperty(value="ioAggregateMetrics")
    private final DatabaseIOAggregateMetrics ioAggregateMetrics;
    @JsonProperty(value="memoryAggregateMetrics")
    private final MemoryAggregateMetrics memoryAggregateMetrics;
    @JsonProperty(value="dbStorageAggregateMetrics")
    private final DatabaseStorageAggregateMetrics dbStorageAggregateMetrics;
    @JsonProperty(value="cpuUtilizationAggregateMetrics")
    private final CpuUtilizationAggregateMetrics cpuUtilizationAggregateMetrics;
    @JsonProperty(value="statementsAggregateMetrics")
    private final StatementsAggregateMetrics statementsAggregateMetrics;
    @JsonProperty(value="failedConnectionsAggregateMetrics")
    private final FailedConnectionsAggregateMetrics failedConnectionsAggregateMetrics;

    @Deprecated
    @ConstructorProperties(value={"activityTimeSeriesMetrics", "dbTimeAggregateMetrics", "ioAggregateMetrics", "memoryAggregateMetrics", "dbStorageAggregateMetrics", "cpuUtilizationAggregateMetrics", "statementsAggregateMetrics", "failedConnectionsAggregateMetrics"})
    public DatabaseHomeMetricDefinition(List<ActivityTimeSeriesMetrics> activityTimeSeriesMetrics, DatabaseTimeAggregateMetrics dbTimeAggregateMetrics, DatabaseIOAggregateMetrics ioAggregateMetrics, MemoryAggregateMetrics memoryAggregateMetrics, DatabaseStorageAggregateMetrics dbStorageAggregateMetrics, CpuUtilizationAggregateMetrics cpuUtilizationAggregateMetrics, StatementsAggregateMetrics statementsAggregateMetrics, FailedConnectionsAggregateMetrics failedConnectionsAggregateMetrics) {
        this.activityTimeSeriesMetrics = activityTimeSeriesMetrics;
        this.dbTimeAggregateMetrics = dbTimeAggregateMetrics;
        this.ioAggregateMetrics = ioAggregateMetrics;
        this.memoryAggregateMetrics = memoryAggregateMetrics;
        this.dbStorageAggregateMetrics = dbStorageAggregateMetrics;
        this.cpuUtilizationAggregateMetrics = cpuUtilizationAggregateMetrics;
        this.statementsAggregateMetrics = statementsAggregateMetrics;
        this.failedConnectionsAggregateMetrics = failedConnectionsAggregateMetrics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<ActivityTimeSeriesMetrics> getActivityTimeSeriesMetrics() {
        return this.activityTimeSeriesMetrics;
    }

    public DatabaseTimeAggregateMetrics getDbTimeAggregateMetrics() {
        return this.dbTimeAggregateMetrics;
    }

    public DatabaseIOAggregateMetrics getIoAggregateMetrics() {
        return this.ioAggregateMetrics;
    }

    public MemoryAggregateMetrics getMemoryAggregateMetrics() {
        return this.memoryAggregateMetrics;
    }

    public DatabaseStorageAggregateMetrics getDbStorageAggregateMetrics() {
        return this.dbStorageAggregateMetrics;
    }

    public CpuUtilizationAggregateMetrics getCpuUtilizationAggregateMetrics() {
        return this.cpuUtilizationAggregateMetrics;
    }

    public StatementsAggregateMetrics getStatementsAggregateMetrics() {
        return this.statementsAggregateMetrics;
    }

    public FailedConnectionsAggregateMetrics getFailedConnectionsAggregateMetrics() {
        return this.failedConnectionsAggregateMetrics;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseHomeMetricDefinition(");
        sb.append("super=").append(super.toString());
        sb.append("activityTimeSeriesMetrics=").append(String.valueOf(this.activityTimeSeriesMetrics));
        sb.append(", dbTimeAggregateMetrics=").append(String.valueOf((Object)this.dbTimeAggregateMetrics));
        sb.append(", ioAggregateMetrics=").append(String.valueOf((Object)this.ioAggregateMetrics));
        sb.append(", memoryAggregateMetrics=").append(String.valueOf((Object)this.memoryAggregateMetrics));
        sb.append(", dbStorageAggregateMetrics=").append(String.valueOf((Object)this.dbStorageAggregateMetrics));
        sb.append(", cpuUtilizationAggregateMetrics=").append(String.valueOf((Object)this.cpuUtilizationAggregateMetrics));
        sb.append(", statementsAggregateMetrics=").append(String.valueOf((Object)this.statementsAggregateMetrics));
        sb.append(", failedConnectionsAggregateMetrics=").append(String.valueOf((Object)this.failedConnectionsAggregateMetrics));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseHomeMetricDefinition)) {
            return false;
        }
        DatabaseHomeMetricDefinition other = (DatabaseHomeMetricDefinition)((Object)o);
        return Objects.equals(this.activityTimeSeriesMetrics, other.activityTimeSeriesMetrics) && Objects.equals((Object)this.dbTimeAggregateMetrics, (Object)other.dbTimeAggregateMetrics) && Objects.equals((Object)this.ioAggregateMetrics, (Object)other.ioAggregateMetrics) && Objects.equals((Object)this.memoryAggregateMetrics, (Object)other.memoryAggregateMetrics) && Objects.equals((Object)this.dbStorageAggregateMetrics, (Object)other.dbStorageAggregateMetrics) && Objects.equals((Object)this.cpuUtilizationAggregateMetrics, (Object)other.cpuUtilizationAggregateMetrics) && Objects.equals((Object)this.statementsAggregateMetrics, (Object)other.statementsAggregateMetrics) && Objects.equals((Object)this.failedConnectionsAggregateMetrics, (Object)other.failedConnectionsAggregateMetrics) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.activityTimeSeriesMetrics == null ? 43 : this.activityTimeSeriesMetrics.hashCode());
        result = result * 59 + (this.dbTimeAggregateMetrics == null ? 43 : this.dbTimeAggregateMetrics.hashCode());
        result = result * 59 + (this.ioAggregateMetrics == null ? 43 : this.ioAggregateMetrics.hashCode());
        result = result * 59 + (this.memoryAggregateMetrics == null ? 43 : this.memoryAggregateMetrics.hashCode());
        result = result * 59 + (this.dbStorageAggregateMetrics == null ? 43 : this.dbStorageAggregateMetrics.hashCode());
        result = result * 59 + (this.cpuUtilizationAggregateMetrics == null ? 43 : this.cpuUtilizationAggregateMetrics.hashCode());
        result = result * 59 + (this.statementsAggregateMetrics == null ? 43 : this.statementsAggregateMetrics.hashCode());
        result = result * 59 + (this.failedConnectionsAggregateMetrics == null ? 43 : this.failedConnectionsAggregateMetrics.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="activityTimeSeriesMetrics")
        private List<ActivityTimeSeriesMetrics> activityTimeSeriesMetrics;
        @JsonProperty(value="dbTimeAggregateMetrics")
        private DatabaseTimeAggregateMetrics dbTimeAggregateMetrics;
        @JsonProperty(value="ioAggregateMetrics")
        private DatabaseIOAggregateMetrics ioAggregateMetrics;
        @JsonProperty(value="memoryAggregateMetrics")
        private MemoryAggregateMetrics memoryAggregateMetrics;
        @JsonProperty(value="dbStorageAggregateMetrics")
        private DatabaseStorageAggregateMetrics dbStorageAggregateMetrics;
        @JsonProperty(value="cpuUtilizationAggregateMetrics")
        private CpuUtilizationAggregateMetrics cpuUtilizationAggregateMetrics;
        @JsonProperty(value="statementsAggregateMetrics")
        private StatementsAggregateMetrics statementsAggregateMetrics;
        @JsonProperty(value="failedConnectionsAggregateMetrics")
        private FailedConnectionsAggregateMetrics failedConnectionsAggregateMetrics;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder activityTimeSeriesMetrics(List<ActivityTimeSeriesMetrics> activityTimeSeriesMetrics) {
            this.activityTimeSeriesMetrics = activityTimeSeriesMetrics;
            this.__explicitlySet__.add("activityTimeSeriesMetrics");
            return this;
        }

        public Builder dbTimeAggregateMetrics(DatabaseTimeAggregateMetrics dbTimeAggregateMetrics) {
            this.dbTimeAggregateMetrics = dbTimeAggregateMetrics;
            this.__explicitlySet__.add("dbTimeAggregateMetrics");
            return this;
        }

        public Builder ioAggregateMetrics(DatabaseIOAggregateMetrics ioAggregateMetrics) {
            this.ioAggregateMetrics = ioAggregateMetrics;
            this.__explicitlySet__.add("ioAggregateMetrics");
            return this;
        }

        public Builder memoryAggregateMetrics(MemoryAggregateMetrics memoryAggregateMetrics) {
            this.memoryAggregateMetrics = memoryAggregateMetrics;
            this.__explicitlySet__.add("memoryAggregateMetrics");
            return this;
        }

        public Builder dbStorageAggregateMetrics(DatabaseStorageAggregateMetrics dbStorageAggregateMetrics) {
            this.dbStorageAggregateMetrics = dbStorageAggregateMetrics;
            this.__explicitlySet__.add("dbStorageAggregateMetrics");
            return this;
        }

        public Builder cpuUtilizationAggregateMetrics(CpuUtilizationAggregateMetrics cpuUtilizationAggregateMetrics) {
            this.cpuUtilizationAggregateMetrics = cpuUtilizationAggregateMetrics;
            this.__explicitlySet__.add("cpuUtilizationAggregateMetrics");
            return this;
        }

        public Builder statementsAggregateMetrics(StatementsAggregateMetrics statementsAggregateMetrics) {
            this.statementsAggregateMetrics = statementsAggregateMetrics;
            this.__explicitlySet__.add("statementsAggregateMetrics");
            return this;
        }

        public Builder failedConnectionsAggregateMetrics(FailedConnectionsAggregateMetrics failedConnectionsAggregateMetrics) {
            this.failedConnectionsAggregateMetrics = failedConnectionsAggregateMetrics;
            this.__explicitlySet__.add("failedConnectionsAggregateMetrics");
            return this;
        }

        public DatabaseHomeMetricDefinition build() {
            DatabaseHomeMetricDefinition model = new DatabaseHomeMetricDefinition(this.activityTimeSeriesMetrics, this.dbTimeAggregateMetrics, this.ioAggregateMetrics, this.memoryAggregateMetrics, this.dbStorageAggregateMetrics, this.cpuUtilizationAggregateMetrics, this.statementsAggregateMetrics, this.failedConnectionsAggregateMetrics);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseHomeMetricDefinition model) {
            if (model.wasPropertyExplicitlySet("activityTimeSeriesMetrics")) {
                this.activityTimeSeriesMetrics(model.getActivityTimeSeriesMetrics());
            }
            if (model.wasPropertyExplicitlySet("dbTimeAggregateMetrics")) {
                this.dbTimeAggregateMetrics(model.getDbTimeAggregateMetrics());
            }
            if (model.wasPropertyExplicitlySet("ioAggregateMetrics")) {
                this.ioAggregateMetrics(model.getIoAggregateMetrics());
            }
            if (model.wasPropertyExplicitlySet("memoryAggregateMetrics")) {
                this.memoryAggregateMetrics(model.getMemoryAggregateMetrics());
            }
            if (model.wasPropertyExplicitlySet("dbStorageAggregateMetrics")) {
                this.dbStorageAggregateMetrics(model.getDbStorageAggregateMetrics());
            }
            if (model.wasPropertyExplicitlySet("cpuUtilizationAggregateMetrics")) {
                this.cpuUtilizationAggregateMetrics(model.getCpuUtilizationAggregateMetrics());
            }
            if (model.wasPropertyExplicitlySet("statementsAggregateMetrics")) {
                this.statementsAggregateMetrics(model.getStatementsAggregateMetrics());
            }
            if (model.wasPropertyExplicitlySet("failedConnectionsAggregateMetrics")) {
                this.failedConnectionsAggregateMetrics(model.getFailedConnectionsAggregateMetrics());
            }
            return this;
        }
    }
}

