/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.CompareType;
import com.oracle.bmc.databasemanagement.model.DatabaseUsageMetrics;
import com.oracle.bmc.databasemanagement.model.FleetSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseFleetHealthMetrics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compareBaselineTime")
    private final String compareBaselineTime;
    @JsonProperty(value="compareTargetTime")
    private final String compareTargetTime;
    @JsonProperty(value="compareType")
    private final CompareType compareType;
    @JsonProperty(value="fleetSummary")
    private final FleetSummary fleetSummary;
    @JsonProperty(value="fleetDatabases")
    private final List<DatabaseUsageMetrics> fleetDatabases;

    @Deprecated
    @ConstructorProperties(value={"compareBaselineTime", "compareTargetTime", "compareType", "fleetSummary", "fleetDatabases"})
    public DatabaseFleetHealthMetrics(String compareBaselineTime, String compareTargetTime, CompareType compareType, FleetSummary fleetSummary, List<DatabaseUsageMetrics> fleetDatabases) {
        this.compareBaselineTime = compareBaselineTime;
        this.compareTargetTime = compareTargetTime;
        this.compareType = compareType;
        this.fleetSummary = fleetSummary;
        this.fleetDatabases = fleetDatabases;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompareBaselineTime() {
        return this.compareBaselineTime;
    }

    public String getCompareTargetTime() {
        return this.compareTargetTime;
    }

    public CompareType getCompareType() {
        return this.compareType;
    }

    public FleetSummary getFleetSummary() {
        return this.fleetSummary;
    }

    public List<DatabaseUsageMetrics> getFleetDatabases() {
        return this.fleetDatabases;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseFleetHealthMetrics(");
        sb.append("super=").append(super.toString());
        sb.append("compareBaselineTime=").append(String.valueOf(this.compareBaselineTime));
        sb.append(", compareTargetTime=").append(String.valueOf(this.compareTargetTime));
        sb.append(", compareType=").append(String.valueOf((Object)this.compareType));
        sb.append(", fleetSummary=").append(String.valueOf((Object)this.fleetSummary));
        sb.append(", fleetDatabases=").append(String.valueOf(this.fleetDatabases));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseFleetHealthMetrics)) {
            return false;
        }
        DatabaseFleetHealthMetrics other = (DatabaseFleetHealthMetrics)((Object)o);
        return Objects.equals(this.compareBaselineTime, other.compareBaselineTime) && Objects.equals(this.compareTargetTime, other.compareTargetTime) && Objects.equals((Object)this.compareType, (Object)other.compareType) && Objects.equals((Object)this.fleetSummary, (Object)other.fleetSummary) && Objects.equals(this.fleetDatabases, other.fleetDatabases) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compareBaselineTime == null ? 43 : this.compareBaselineTime.hashCode());
        result = result * 59 + (this.compareTargetTime == null ? 43 : this.compareTargetTime.hashCode());
        result = result * 59 + (this.compareType == null ? 43 : this.compareType.hashCode());
        result = result * 59 + (this.fleetSummary == null ? 43 : this.fleetSummary.hashCode());
        result = result * 59 + (this.fleetDatabases == null ? 43 : this.fleetDatabases.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compareBaselineTime")
        private String compareBaselineTime;
        @JsonProperty(value="compareTargetTime")
        private String compareTargetTime;
        @JsonProperty(value="compareType")
        private CompareType compareType;
        @JsonProperty(value="fleetSummary")
        private FleetSummary fleetSummary;
        @JsonProperty(value="fleetDatabases")
        private List<DatabaseUsageMetrics> fleetDatabases;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compareBaselineTime(String compareBaselineTime) {
            this.compareBaselineTime = compareBaselineTime;
            this.__explicitlySet__.add("compareBaselineTime");
            return this;
        }

        public Builder compareTargetTime(String compareTargetTime) {
            this.compareTargetTime = compareTargetTime;
            this.__explicitlySet__.add("compareTargetTime");
            return this;
        }

        public Builder compareType(CompareType compareType) {
            this.compareType = compareType;
            this.__explicitlySet__.add("compareType");
            return this;
        }

        public Builder fleetSummary(FleetSummary fleetSummary) {
            this.fleetSummary = fleetSummary;
            this.__explicitlySet__.add("fleetSummary");
            return this;
        }

        public Builder fleetDatabases(List<DatabaseUsageMetrics> fleetDatabases) {
            this.fleetDatabases = fleetDatabases;
            this.__explicitlySet__.add("fleetDatabases");
            return this;
        }

        public DatabaseFleetHealthMetrics build() {
            DatabaseFleetHealthMetrics model = new DatabaseFleetHealthMetrics(this.compareBaselineTime, this.compareTargetTime, this.compareType, this.fleetSummary, this.fleetDatabases);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseFleetHealthMetrics model) {
            if (model.wasPropertyExplicitlySet("compareBaselineTime")) {
                this.compareBaselineTime(model.getCompareBaselineTime());
            }
            if (model.wasPropertyExplicitlySet("compareTargetTime")) {
                this.compareTargetTime(model.getCompareTargetTime());
            }
            if (model.wasPropertyExplicitlySet("compareType")) {
                this.compareType(model.getCompareType());
            }
            if (model.wasPropertyExplicitlySet("fleetSummary")) {
                this.fleetSummary(model.getFleetSummary());
            }
            if (model.wasPropertyExplicitlySet("fleetDatabases")) {
                this.fleetDatabases(model.getFleetDatabases());
            }
            return this;
        }
    }
}

