/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.CreateJobDetails;
import com.oracle.bmc.databasemanagement.model.DatabaseSubType;
import com.oracle.bmc.databasemanagement.model.Job;
import com.oracle.bmc.databasemanagement.model.JobExecutionResultLocation;
import com.oracle.bmc.databasemanagement.model.JobScheduleDetails;
import com.oracle.bmc.databasemanagement.model.SqlJob;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="jobType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateSqlJobDetails
extends CreateJobDetails {
    @JsonProperty(value="sqlText")
    private final String sqlText;
    @JsonProperty(value="sqlType")
    private final SqlJob.SqlType sqlType;
    @JsonProperty(value="operationType")
    private final SqlJob.OperationType operationType;
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="password")
    private final String password;
    @JsonProperty(value="secretId")
    private final String secretId;
    @JsonProperty(value="role")
    private final SqlJob.Role role;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateSqlJobDetails(String name, String description, String compartmentId, String managedDatabaseGroupId, String managedDatabaseId, DatabaseSubType databaseSubType, Job.ScheduleType scheduleType, String timeout, JobExecutionResultLocation resultLocation, JobScheduleDetails scheduleDetails, String sqlText, SqlJob.SqlType sqlType, SqlJob.OperationType operationType, String userName, String password, String secretId, SqlJob.Role role) {
        super(name, description, compartmentId, managedDatabaseGroupId, managedDatabaseId, databaseSubType, scheduleType, timeout, resultLocation, scheduleDetails);
        this.sqlText = sqlText;
        this.sqlType = sqlType;
        this.operationType = operationType;
        this.userName = userName;
        this.password = password;
        this.secretId = secretId;
        this.role = role;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public SqlJob.SqlType getSqlType() {
        return this.sqlType;
    }

    public SqlJob.OperationType getOperationType() {
        return this.operationType;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public SqlJob.Role getRole() {
        return this.role;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateSqlJobDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", sqlText=").append(String.valueOf(this.sqlText));
        sb.append(", sqlType=").append(String.valueOf((Object)this.sqlType));
        sb.append(", operationType=").append(String.valueOf((Object)this.operationType));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", password=").append(String.valueOf(this.password));
        sb.append(", secretId=").append(String.valueOf(this.secretId));
        sb.append(", role=").append(String.valueOf((Object)this.role));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateSqlJobDetails)) {
            return false;
        }
        CreateSqlJobDetails other = (CreateSqlJobDetails)((Object)o);
        return Objects.equals(this.sqlText, other.sqlText) && Objects.equals((Object)this.sqlType, (Object)other.sqlType) && Objects.equals((Object)this.operationType, (Object)other.operationType) && Objects.equals(this.userName, other.userName) && Objects.equals(this.password, other.password) && Objects.equals(this.secretId, other.secretId) && Objects.equals((Object)this.role, (Object)other.role) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.sqlText == null ? 43 : this.sqlText.hashCode());
        result = result * 59 + (this.sqlType == null ? 43 : this.sqlType.hashCode());
        result = result * 59 + (this.operationType == null ? 43 : this.operationType.hashCode());
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.password == null ? 43 : this.password.hashCode());
        result = result * 59 + (this.secretId == null ? 43 : this.secretId.hashCode());
        result = result * 59 + (this.role == null ? 43 : this.role.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="managedDatabaseGroupId")
        private String managedDatabaseGroupId;
        @JsonProperty(value="managedDatabaseId")
        private String managedDatabaseId;
        @JsonProperty(value="databaseSubType")
        private DatabaseSubType databaseSubType;
        @JsonProperty(value="scheduleType")
        private Job.ScheduleType scheduleType;
        @JsonProperty(value="timeout")
        private String timeout;
        @JsonProperty(value="resultLocation")
        private JobExecutionResultLocation resultLocation;
        @JsonProperty(value="scheduleDetails")
        private JobScheduleDetails scheduleDetails;
        @JsonProperty(value="sqlText")
        private String sqlText;
        @JsonProperty(value="sqlType")
        private SqlJob.SqlType sqlType;
        @JsonProperty(value="operationType")
        private SqlJob.OperationType operationType;
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="password")
        private String password;
        @JsonProperty(value="secretId")
        private String secretId;
        @JsonProperty(value="role")
        private SqlJob.Role role;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder managedDatabaseGroupId(String managedDatabaseGroupId) {
            this.managedDatabaseGroupId = managedDatabaseGroupId;
            this.__explicitlySet__.add("managedDatabaseGroupId");
            return this;
        }

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            this.__explicitlySet__.add("managedDatabaseId");
            return this;
        }

        public Builder databaseSubType(DatabaseSubType databaseSubType) {
            this.databaseSubType = databaseSubType;
            this.__explicitlySet__.add("databaseSubType");
            return this;
        }

        public Builder scheduleType(Job.ScheduleType scheduleType) {
            this.scheduleType = scheduleType;
            this.__explicitlySet__.add("scheduleType");
            return this;
        }

        public Builder timeout(String timeout) {
            this.timeout = timeout;
            this.__explicitlySet__.add("timeout");
            return this;
        }

        public Builder resultLocation(JobExecutionResultLocation resultLocation) {
            this.resultLocation = resultLocation;
            this.__explicitlySet__.add("resultLocation");
            return this;
        }

        public Builder scheduleDetails(JobScheduleDetails scheduleDetails) {
            this.scheduleDetails = scheduleDetails;
            this.__explicitlySet__.add("scheduleDetails");
            return this;
        }

        public Builder sqlText(String sqlText) {
            this.sqlText = sqlText;
            this.__explicitlySet__.add("sqlText");
            return this;
        }

        public Builder sqlType(SqlJob.SqlType sqlType) {
            this.sqlType = sqlType;
            this.__explicitlySet__.add("sqlType");
            return this;
        }

        public Builder operationType(SqlJob.OperationType operationType) {
            this.operationType = operationType;
            this.__explicitlySet__.add("operationType");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            this.__explicitlySet__.add("password");
            return this;
        }

        public Builder secretId(String secretId) {
            this.secretId = secretId;
            this.__explicitlySet__.add("secretId");
            return this;
        }

        public Builder role(SqlJob.Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public CreateSqlJobDetails build() {
            CreateSqlJobDetails model = new CreateSqlJobDetails(this.name, this.description, this.compartmentId, this.managedDatabaseGroupId, this.managedDatabaseId, this.databaseSubType, this.scheduleType, this.timeout, this.resultLocation, this.scheduleDetails, this.sqlText, this.sqlType, this.operationType, this.userName, this.password, this.secretId, this.role);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateSqlJobDetails model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("managedDatabaseGroupId")) {
                this.managedDatabaseGroupId(model.getManagedDatabaseGroupId());
            }
            if (model.wasPropertyExplicitlySet("managedDatabaseId")) {
                this.managedDatabaseId(model.getManagedDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("databaseSubType")) {
                this.databaseSubType(model.getDatabaseSubType());
            }
            if (model.wasPropertyExplicitlySet("scheduleType")) {
                this.scheduleType(model.getScheduleType());
            }
            if (model.wasPropertyExplicitlySet("timeout")) {
                this.timeout(model.getTimeout());
            }
            if (model.wasPropertyExplicitlySet("resultLocation")) {
                this.resultLocation(model.getResultLocation());
            }
            if (model.wasPropertyExplicitlySet("scheduleDetails")) {
                this.scheduleDetails(model.getScheduleDetails());
            }
            if (model.wasPropertyExplicitlySet("sqlText")) {
                this.sqlText(model.getSqlText());
            }
            if (model.wasPropertyExplicitlySet("sqlType")) {
                this.sqlType(model.getSqlType());
            }
            if (model.wasPropertyExplicitlySet("operationType")) {
                this.operationType(model.getOperationType());
            }
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("password")) {
                this.password(model.getPassword());
            }
            if (model.wasPropertyExplicitlySet("secretId")) {
                this.secretId(model.getSecretId());
            }
            if (model.wasPropertyExplicitlySet("role")) {
                this.role(model.getRole());
            }
            return this;
        }
    }
}

