/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.AwrDbCpuUsageSummary;
import com.oracle.bmc.databasemanagement.model.AwrQueryResult;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="awrResultType")
@JsonFilter(value="explicitlySetFilter")
public final class AwrDbCpuUsageCollection
extends AwrQueryResult {
    @JsonProperty(value="numCpuCores")
    private final Integer numCpuCores;
    @JsonProperty(value="cpuCount")
    private final Integer cpuCount;
    @JsonProperty(value="numCpus")
    private final Double numCpus;
    @JsonProperty(value="items")
    private final List<AwrDbCpuUsageSummary> items;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public AwrDbCpuUsageCollection(String name, String version, String queryKey, Double dbQueryTimeInSecs, Integer numCpuCores, Integer cpuCount, Double numCpus, List<AwrDbCpuUsageSummary> items) {
        super(name, version, queryKey, dbQueryTimeInSecs);
        this.numCpuCores = numCpuCores;
        this.cpuCount = cpuCount;
        this.numCpus = numCpus;
        this.items = items;
    }

    public Integer getNumCpuCores() {
        return this.numCpuCores;
    }

    public Integer getCpuCount() {
        return this.cpuCount;
    }

    public Double getNumCpus() {
        return this.numCpus;
    }

    public List<AwrDbCpuUsageSummary> getItems() {
        return this.items;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AwrDbCpuUsageCollection(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", numCpuCores=").append(String.valueOf(this.numCpuCores));
        sb.append(", cpuCount=").append(String.valueOf(this.cpuCount));
        sb.append(", numCpus=").append(String.valueOf(this.numCpus));
        sb.append(", items=").append(String.valueOf(this.items));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AwrDbCpuUsageCollection)) {
            return false;
        }
        AwrDbCpuUsageCollection other = (AwrDbCpuUsageCollection)((Object)o);
        return Objects.equals(this.numCpuCores, other.numCpuCores) && Objects.equals(this.cpuCount, other.cpuCount) && Objects.equals(this.numCpus, other.numCpus) && Objects.equals(this.items, other.items) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.numCpuCores == null ? 43 : this.numCpuCores.hashCode());
        result = result * 59 + (this.cpuCount == null ? 43 : this.cpuCount.hashCode());
        result = result * 59 + (this.numCpus == null ? 43 : this.numCpus.hashCode());
        result = result * 59 + (this.items == null ? 43 : this.items.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="queryKey")
        private String queryKey;
        @JsonProperty(value="dbQueryTimeInSecs")
        private Double dbQueryTimeInSecs;
        @JsonProperty(value="numCpuCores")
        private Integer numCpuCores;
        @JsonProperty(value="cpuCount")
        private Integer cpuCount;
        @JsonProperty(value="numCpus")
        private Double numCpus;
        @JsonProperty(value="items")
        private List<AwrDbCpuUsageSummary> items;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder queryKey(String queryKey) {
            this.queryKey = queryKey;
            this.__explicitlySet__.add("queryKey");
            return this;
        }

        public Builder dbQueryTimeInSecs(Double dbQueryTimeInSecs) {
            this.dbQueryTimeInSecs = dbQueryTimeInSecs;
            this.__explicitlySet__.add("dbQueryTimeInSecs");
            return this;
        }

        public Builder numCpuCores(Integer numCpuCores) {
            this.numCpuCores = numCpuCores;
            this.__explicitlySet__.add("numCpuCores");
            return this;
        }

        public Builder cpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
            this.__explicitlySet__.add("cpuCount");
            return this;
        }

        public Builder numCpus(Double numCpus) {
            this.numCpus = numCpus;
            this.__explicitlySet__.add("numCpus");
            return this;
        }

        public Builder items(List<AwrDbCpuUsageSummary> items) {
            this.items = items;
            this.__explicitlySet__.add("items");
            return this;
        }

        public AwrDbCpuUsageCollection build() {
            AwrDbCpuUsageCollection model = new AwrDbCpuUsageCollection(this.name, this.version, this.queryKey, this.dbQueryTimeInSecs, this.numCpuCores, this.cpuCount, this.numCpus, this.items);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AwrDbCpuUsageCollection model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("queryKey")) {
                this.queryKey(model.getQueryKey());
            }
            if (model.wasPropertyExplicitlySet("dbQueryTimeInSecs")) {
                this.dbQueryTimeInSecs(model.getDbQueryTimeInSecs());
            }
            if (model.wasPropertyExplicitlySet("numCpuCores")) {
                this.numCpuCores(model.getNumCpuCores());
            }
            if (model.wasPropertyExplicitlySet("cpuCount")) {
                this.cpuCount(model.getCpuCount());
            }
            if (model.wasPropertyExplicitlySet("numCpus")) {
                this.numCpus(model.getNumCpus());
            }
            if (model.wasPropertyExplicitlySet("items")) {
                this.items(model.getItems());
            }
            return this;
        }
    }
}

