/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AttentionLogCountSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="category")
    private final Category category;
    @JsonProperty(value="count")
    private final Integer count;

    @Deprecated
    @ConstructorProperties(value={"category", "count"})
    public AttentionLogCountSummary(Category category, Integer count) {
        this.category = category;
        this.count = count;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Category getCategory() {
        return this.category;
    }

    public Integer getCount() {
        return this.count;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AttentionLogCountSummary(");
        sb.append("super=").append(super.toString());
        sb.append("category=").append(String.valueOf((Object)this.category));
        sb.append(", count=").append(String.valueOf(this.count));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttentionLogCountSummary)) {
            return false;
        }
        AttentionLogCountSummary other = (AttentionLogCountSummary)((Object)o);
        return Objects.equals((Object)this.category, (Object)other.category) && Objects.equals(this.count, other.count) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.category == null ? 43 : this.category.hashCode());
        result = result * 59 + (this.count == null ? 43 : this.count.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Category implements BmcEnum
    {
        Unknown("UNKNOWN"),
        IncidentError("INCIDENT_ERROR"),
        Error("ERROR"),
        Warning("WARNING"),
        Notification("NOTIFICATION"),
        Trace("TRACE"),
        Immediate("IMMEDIATE"),
        Soon("SOON"),
        Deferrable("DEFERRABLE"),
        Info("INFO"),
        Other("OTHER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Category> map;

        private Category(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Category create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Category', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Category.class);
            map = new HashMap<String, Category>();
            for (Category v : Category.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="category")
        private Category category;
        @JsonProperty(value="count")
        private Integer count;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder category(Category category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            this.__explicitlySet__.add("count");
            return this;
        }

        public AttentionLogCountSummary build() {
            AttentionLogCountSummary model = new AttentionLogCountSummary(this.category, this.count);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AttentionLogCountSummary model) {
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("count")) {
                this.count(model.getCount());
            }
            return this;
        }
    }
}

