/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement;

import com.oracle.bmc.databasemanagement.Diagnosability;
import com.oracle.bmc.databasemanagement.model.AlertLogSummary;
import com.oracle.bmc.databasemanagement.model.AttentionLogSummary;
import com.oracle.bmc.databasemanagement.requests.ListAlertLogsRequest;
import com.oracle.bmc.databasemanagement.requests.ListAttentionLogsRequest;
import com.oracle.bmc.databasemanagement.responses.ListAlertLogsResponse;
import com.oracle.bmc.databasemanagement.responses.ListAttentionLogsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class DiagnosabilityPaginators {
    private final Diagnosability client;

    public DiagnosabilityPaginators(Diagnosability client) {
        this.client = client;
    }

    public Iterable<ListAlertLogsResponse> listAlertLogsResponseIterator(final ListAlertLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAlertLogsRequest.Builder>(){

            @Override
            public ListAlertLogsRequest.Builder get() {
                return ListAlertLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAlertLogsResponse, String>(){

            @Override
            public String apply(ListAlertLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAlertLogsRequest.Builder>, ListAlertLogsRequest>(){

            @Override
            public ListAlertLogsRequest apply(RequestBuilderAndToken<ListAlertLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAlertLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAlertLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAlertLogsRequest, ListAlertLogsResponse>(){

            @Override
            public ListAlertLogsResponse apply(ListAlertLogsRequest request) {
                return DiagnosabilityPaginators.this.client.listAlertLogs(request);
            }
        });
    }

    public Iterable<AlertLogSummary> listAlertLogsRecordIterator(final ListAlertLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAlertLogsRequest.Builder>(){

            @Override
            public ListAlertLogsRequest.Builder get() {
                return ListAlertLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAlertLogsResponse, String>(){

            @Override
            public String apply(ListAlertLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAlertLogsRequest.Builder>, ListAlertLogsRequest>(){

            @Override
            public ListAlertLogsRequest apply(RequestBuilderAndToken<ListAlertLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAlertLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAlertLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAlertLogsRequest, ListAlertLogsResponse>(){

            @Override
            public ListAlertLogsResponse apply(ListAlertLogsRequest request) {
                return DiagnosabilityPaginators.this.client.listAlertLogs(request);
            }
        }, (Function)new Function<ListAlertLogsResponse, List<AlertLogSummary>>(){

            @Override
            public List<AlertLogSummary> apply(ListAlertLogsResponse response) {
                return response.getAlertLogCollection().getItems();
            }
        });
    }

    public Iterable<ListAttentionLogsResponse> listAttentionLogsResponseIterator(final ListAttentionLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAttentionLogsRequest.Builder>(){

            @Override
            public ListAttentionLogsRequest.Builder get() {
                return ListAttentionLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAttentionLogsResponse, String>(){

            @Override
            public String apply(ListAttentionLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAttentionLogsRequest.Builder>, ListAttentionLogsRequest>(){

            @Override
            public ListAttentionLogsRequest apply(RequestBuilderAndToken<ListAttentionLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAttentionLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAttentionLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAttentionLogsRequest, ListAttentionLogsResponse>(){

            @Override
            public ListAttentionLogsResponse apply(ListAttentionLogsRequest request) {
                return DiagnosabilityPaginators.this.client.listAttentionLogs(request);
            }
        });
    }

    public Iterable<AttentionLogSummary> listAttentionLogsRecordIterator(final ListAttentionLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAttentionLogsRequest.Builder>(){

            @Override
            public ListAttentionLogsRequest.Builder get() {
                return ListAttentionLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAttentionLogsResponse, String>(){

            @Override
            public String apply(ListAttentionLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAttentionLogsRequest.Builder>, ListAttentionLogsRequest>(){

            @Override
            public ListAttentionLogsRequest apply(RequestBuilderAndToken<ListAttentionLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAttentionLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAttentionLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAttentionLogsRequest, ListAttentionLogsResponse>(){

            @Override
            public ListAttentionLogsResponse apply(ListAttentionLogsRequest request) {
                return DiagnosabilityPaginators.this.client.listAttentionLogs(request);
            }
        }, (Function)new Function<ListAttentionLogsResponse, List<AttentionLogSummary>>(){

            @Override
            public List<AttentionLogSummary> apply(ListAttentionLogsResponse response) {
                return response.getAttentionLogCollection().getItems();
            }
        });
    }
}

