/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.databasemanagement.DbManagement;
import com.oracle.bmc.databasemanagement.DbManagementAsyncClient;
import com.oracle.bmc.databasemanagement.DbManagementPaginators;
import com.oracle.bmc.databasemanagement.DbManagementWaiters;
import com.oracle.bmc.databasemanagement.model.AddmTasksCollection;
import com.oracle.bmc.databasemanagement.model.AsmPropertyCollection;
import com.oracle.bmc.databasemanagement.model.AssociatedDatabaseCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbCpuUsageCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbMetricCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbParameterChangeCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbParameterCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbReport;
import com.oracle.bmc.databasemanagement.model.AwrDbSnapshotCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbSnapshotRangeCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbSqlReport;
import com.oracle.bmc.databasemanagement.model.AwrDbSysstatCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbTopWaitEventCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbWaitEventBucketCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbWaitEventCollection;
import com.oracle.bmc.databasemanagement.model.ClusterCacheMetric;
import com.oracle.bmc.databasemanagement.model.ConsumerGroupPrivilegeCollection;
import com.oracle.bmc.databasemanagement.model.DataAccessContainerCollection;
import com.oracle.bmc.databasemanagement.model.DatabaseFleetHealthMetrics;
import com.oracle.bmc.databasemanagement.model.DatabaseHomeMetrics;
import com.oracle.bmc.databasemanagement.model.DatabaseParametersCollection;
import com.oracle.bmc.databasemanagement.model.DbManagementPrivateEndpoint;
import com.oracle.bmc.databasemanagement.model.DbManagementPrivateEndpointCollection;
import com.oracle.bmc.databasemanagement.model.HistoricAddmResult;
import com.oracle.bmc.databasemanagement.model.Job;
import com.oracle.bmc.databasemanagement.model.JobCollection;
import com.oracle.bmc.databasemanagement.model.JobExecution;
import com.oracle.bmc.databasemanagement.model.JobExecutionCollection;
import com.oracle.bmc.databasemanagement.model.JobExecutionsStatusSummaryCollection;
import com.oracle.bmc.databasemanagement.model.JobRun;
import com.oracle.bmc.databasemanagement.model.JobRunCollection;
import com.oracle.bmc.databasemanagement.model.ManagedDatabase;
import com.oracle.bmc.databasemanagement.model.ManagedDatabaseCollection;
import com.oracle.bmc.databasemanagement.model.ManagedDatabaseGroup;
import com.oracle.bmc.databasemanagement.model.ManagedDatabaseGroupCollection;
import com.oracle.bmc.databasemanagement.model.ObjectPrivilegeCollection;
import com.oracle.bmc.databasemanagement.model.OptimizerStatisticsAdvisorExecution;
import com.oracle.bmc.databasemanagement.model.OptimizerStatisticsAdvisorExecutionScript;
import com.oracle.bmc.databasemanagement.model.OptimizerStatisticsAdvisorExecutionsCollection;
import com.oracle.bmc.databasemanagement.model.OptimizerStatisticsCollectionAggregationsCollection;
import com.oracle.bmc.databasemanagement.model.OptimizerStatisticsCollectionOperation;
import com.oracle.bmc.databasemanagement.model.OptimizerStatisticsCollectionOperationsCollection;
import com.oracle.bmc.databasemanagement.model.PdbMetrics;
import com.oracle.bmc.databasemanagement.model.PreferredCredential;
import com.oracle.bmc.databasemanagement.model.PreferredCredentialCollection;
import com.oracle.bmc.databasemanagement.model.ProxiedForUserCollection;
import com.oracle.bmc.databasemanagement.model.ProxyUserCollection;
import com.oracle.bmc.databasemanagement.model.RoleCollection;
import com.oracle.bmc.databasemanagement.model.SnapshotDetails;
import com.oracle.bmc.databasemanagement.model.SystemPrivilegeCollection;
import com.oracle.bmc.databasemanagement.model.TableStatisticsCollection;
import com.oracle.bmc.databasemanagement.model.Tablespace;
import com.oracle.bmc.databasemanagement.model.TablespaceAdminStatus;
import com.oracle.bmc.databasemanagement.model.TablespaceCollection;
import com.oracle.bmc.databasemanagement.model.TestPreferredCredentialStatus;
import com.oracle.bmc.databasemanagement.model.UpdateDatabaseParametersResult;
import com.oracle.bmc.databasemanagement.model.User;
import com.oracle.bmc.databasemanagement.model.UserCollection;
import com.oracle.bmc.databasemanagement.model.WorkRequest;
import com.oracle.bmc.databasemanagement.model.WorkRequestCollection;
import com.oracle.bmc.databasemanagement.model.WorkRequestErrorCollection;
import com.oracle.bmc.databasemanagement.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.databasemanagement.requests.AddDataFilesRequest;
import com.oracle.bmc.databasemanagement.requests.AddManagedDatabaseToManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.AddmTasksRequest;
import com.oracle.bmc.databasemanagement.requests.ChangeDatabaseParametersRequest;
import com.oracle.bmc.databasemanagement.requests.ChangeDbManagementPrivateEndpointCompartmentRequest;
import com.oracle.bmc.databasemanagement.requests.ChangeJobCompartmentRequest;
import com.oracle.bmc.databasemanagement.requests.ChangeManagedDatabaseGroupCompartmentRequest;
import com.oracle.bmc.databasemanagement.requests.CreateDbManagementPrivateEndpointRequest;
import com.oracle.bmc.databasemanagement.requests.CreateJobRequest;
import com.oracle.bmc.databasemanagement.requests.CreateManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.CreateTablespaceRequest;
import com.oracle.bmc.databasemanagement.requests.DeleteDbManagementPrivateEndpointRequest;
import com.oracle.bmc.databasemanagement.requests.DeleteJobRequest;
import com.oracle.bmc.databasemanagement.requests.DeleteManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.DeletePreferredCredentialRequest;
import com.oracle.bmc.databasemanagement.requests.DropTablespaceRequest;
import com.oracle.bmc.databasemanagement.requests.GenerateAwrSnapshotRequest;
import com.oracle.bmc.databasemanagement.requests.GetAwrDbReportRequest;
import com.oracle.bmc.databasemanagement.requests.GetAwrDbSqlReportRequest;
import com.oracle.bmc.databasemanagement.requests.GetClusterCacheMetricRequest;
import com.oracle.bmc.databasemanagement.requests.GetDatabaseFleetHealthMetricsRequest;
import com.oracle.bmc.databasemanagement.requests.GetDatabaseHomeMetricsRequest;
import com.oracle.bmc.databasemanagement.requests.GetDbManagementPrivateEndpointRequest;
import com.oracle.bmc.databasemanagement.requests.GetJobExecutionRequest;
import com.oracle.bmc.databasemanagement.requests.GetJobRequest;
import com.oracle.bmc.databasemanagement.requests.GetJobRunRequest;
import com.oracle.bmc.databasemanagement.requests.GetManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.GetManagedDatabaseRequest;
import com.oracle.bmc.databasemanagement.requests.GetOptimizerStatisticsAdvisorExecutionRequest;
import com.oracle.bmc.databasemanagement.requests.GetOptimizerStatisticsAdvisorExecutionScriptRequest;
import com.oracle.bmc.databasemanagement.requests.GetOptimizerStatisticsCollectionOperationRequest;
import com.oracle.bmc.databasemanagement.requests.GetPdbMetricsRequest;
import com.oracle.bmc.databasemanagement.requests.GetPreferredCredentialRequest;
import com.oracle.bmc.databasemanagement.requests.GetTablespaceRequest;
import com.oracle.bmc.databasemanagement.requests.GetUserRequest;
import com.oracle.bmc.databasemanagement.requests.GetWorkRequestRequest;
import com.oracle.bmc.databasemanagement.requests.ImplementOptimizerStatisticsAdvisorRecommendationsRequest;
import com.oracle.bmc.databasemanagement.requests.ListAsmPropertiesRequest;
import com.oracle.bmc.databasemanagement.requests.ListAssociatedDatabasesRequest;
import com.oracle.bmc.databasemanagement.requests.ListAwrDbSnapshotsRequest;
import com.oracle.bmc.databasemanagement.requests.ListAwrDbsRequest;
import com.oracle.bmc.databasemanagement.requests.ListConsumerGroupPrivilegesRequest;
import com.oracle.bmc.databasemanagement.requests.ListDataAccessContainersRequest;
import com.oracle.bmc.databasemanagement.requests.ListDatabaseParametersRequest;
import com.oracle.bmc.databasemanagement.requests.ListDbManagementPrivateEndpointsRequest;
import com.oracle.bmc.databasemanagement.requests.ListJobExecutionsRequest;
import com.oracle.bmc.databasemanagement.requests.ListJobRunsRequest;
import com.oracle.bmc.databasemanagement.requests.ListJobsRequest;
import com.oracle.bmc.databasemanagement.requests.ListManagedDatabaseGroupsRequest;
import com.oracle.bmc.databasemanagement.requests.ListManagedDatabasesRequest;
import com.oracle.bmc.databasemanagement.requests.ListObjectPrivilegesRequest;
import com.oracle.bmc.databasemanagement.requests.ListOptimizerStatisticsAdvisorExecutionsRequest;
import com.oracle.bmc.databasemanagement.requests.ListOptimizerStatisticsCollectionAggregationsRequest;
import com.oracle.bmc.databasemanagement.requests.ListOptimizerStatisticsCollectionOperationsRequest;
import com.oracle.bmc.databasemanagement.requests.ListPreferredCredentialsRequest;
import com.oracle.bmc.databasemanagement.requests.ListProxiedForUsersRequest;
import com.oracle.bmc.databasemanagement.requests.ListProxyUsersRequest;
import com.oracle.bmc.databasemanagement.requests.ListRolesRequest;
import com.oracle.bmc.databasemanagement.requests.ListSystemPrivilegesRequest;
import com.oracle.bmc.databasemanagement.requests.ListTableStatisticsRequest;
import com.oracle.bmc.databasemanagement.requests.ListTablespacesRequest;
import com.oracle.bmc.databasemanagement.requests.ListUsersRequest;
import com.oracle.bmc.databasemanagement.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.databasemanagement.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.databasemanagement.requests.ListWorkRequestsRequest;
import com.oracle.bmc.databasemanagement.requests.RemoveDataFileRequest;
import com.oracle.bmc.databasemanagement.requests.RemoveManagedDatabaseFromManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.ResetDatabaseParametersRequest;
import com.oracle.bmc.databasemanagement.requests.ResizeDataFileRequest;
import com.oracle.bmc.databasemanagement.requests.RunHistoricAddmRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAwrDbCpuUsagesRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAwrDbMetricsRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAwrDbParameterChangesRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAwrDbParametersRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAwrDbSnapshotRangesRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAwrDbSysstatsRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAwrDbTopWaitEventsRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAwrDbWaitEventBucketsRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAwrDbWaitEventsRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeJobExecutionsStatusesRequest;
import com.oracle.bmc.databasemanagement.requests.TestPreferredCredentialRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateDbManagementPrivateEndpointRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateJobRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.UpdatePreferredCredentialRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateTablespaceRequest;
import com.oracle.bmc.databasemanagement.responses.AddDataFilesResponse;
import com.oracle.bmc.databasemanagement.responses.AddManagedDatabaseToManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.AddmTasksResponse;
import com.oracle.bmc.databasemanagement.responses.ChangeDatabaseParametersResponse;
import com.oracle.bmc.databasemanagement.responses.ChangeDbManagementPrivateEndpointCompartmentResponse;
import com.oracle.bmc.databasemanagement.responses.ChangeJobCompartmentResponse;
import com.oracle.bmc.databasemanagement.responses.ChangeManagedDatabaseGroupCompartmentResponse;
import com.oracle.bmc.databasemanagement.responses.CreateDbManagementPrivateEndpointResponse;
import com.oracle.bmc.databasemanagement.responses.CreateJobResponse;
import com.oracle.bmc.databasemanagement.responses.CreateManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.CreateTablespaceResponse;
import com.oracle.bmc.databasemanagement.responses.DeleteDbManagementPrivateEndpointResponse;
import com.oracle.bmc.databasemanagement.responses.DeleteJobResponse;
import com.oracle.bmc.databasemanagement.responses.DeleteManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.DeletePreferredCredentialResponse;
import com.oracle.bmc.databasemanagement.responses.DropTablespaceResponse;
import com.oracle.bmc.databasemanagement.responses.GenerateAwrSnapshotResponse;
import com.oracle.bmc.databasemanagement.responses.GetAwrDbReportResponse;
import com.oracle.bmc.databasemanagement.responses.GetAwrDbSqlReportResponse;
import com.oracle.bmc.databasemanagement.responses.GetClusterCacheMetricResponse;
import com.oracle.bmc.databasemanagement.responses.GetDatabaseFleetHealthMetricsResponse;
import com.oracle.bmc.databasemanagement.responses.GetDatabaseHomeMetricsResponse;
import com.oracle.bmc.databasemanagement.responses.GetDbManagementPrivateEndpointResponse;
import com.oracle.bmc.databasemanagement.responses.GetJobExecutionResponse;
import com.oracle.bmc.databasemanagement.responses.GetJobResponse;
import com.oracle.bmc.databasemanagement.responses.GetJobRunResponse;
import com.oracle.bmc.databasemanagement.responses.GetManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.GetManagedDatabaseResponse;
import com.oracle.bmc.databasemanagement.responses.GetOptimizerStatisticsAdvisorExecutionResponse;
import com.oracle.bmc.databasemanagement.responses.GetOptimizerStatisticsAdvisorExecutionScriptResponse;
import com.oracle.bmc.databasemanagement.responses.GetOptimizerStatisticsCollectionOperationResponse;
import com.oracle.bmc.databasemanagement.responses.GetPdbMetricsResponse;
import com.oracle.bmc.databasemanagement.responses.GetPreferredCredentialResponse;
import com.oracle.bmc.databasemanagement.responses.GetTablespaceResponse;
import com.oracle.bmc.databasemanagement.responses.GetUserResponse;
import com.oracle.bmc.databasemanagement.responses.GetWorkRequestResponse;
import com.oracle.bmc.databasemanagement.responses.ImplementOptimizerStatisticsAdvisorRecommendationsResponse;
import com.oracle.bmc.databasemanagement.responses.ListAsmPropertiesResponse;
import com.oracle.bmc.databasemanagement.responses.ListAssociatedDatabasesResponse;
import com.oracle.bmc.databasemanagement.responses.ListAwrDbSnapshotsResponse;
import com.oracle.bmc.databasemanagement.responses.ListAwrDbsResponse;
import com.oracle.bmc.databasemanagement.responses.ListConsumerGroupPrivilegesResponse;
import com.oracle.bmc.databasemanagement.responses.ListDataAccessContainersResponse;
import com.oracle.bmc.databasemanagement.responses.ListDatabaseParametersResponse;
import com.oracle.bmc.databasemanagement.responses.ListDbManagementPrivateEndpointsResponse;
import com.oracle.bmc.databasemanagement.responses.ListJobExecutionsResponse;
import com.oracle.bmc.databasemanagement.responses.ListJobRunsResponse;
import com.oracle.bmc.databasemanagement.responses.ListJobsResponse;
import com.oracle.bmc.databasemanagement.responses.ListManagedDatabaseGroupsResponse;
import com.oracle.bmc.databasemanagement.responses.ListManagedDatabasesResponse;
import com.oracle.bmc.databasemanagement.responses.ListObjectPrivilegesResponse;
import com.oracle.bmc.databasemanagement.responses.ListOptimizerStatisticsAdvisorExecutionsResponse;
import com.oracle.bmc.databasemanagement.responses.ListOptimizerStatisticsCollectionAggregationsResponse;
import com.oracle.bmc.databasemanagement.responses.ListOptimizerStatisticsCollectionOperationsResponse;
import com.oracle.bmc.databasemanagement.responses.ListPreferredCredentialsResponse;
import com.oracle.bmc.databasemanagement.responses.ListProxiedForUsersResponse;
import com.oracle.bmc.databasemanagement.responses.ListProxyUsersResponse;
import com.oracle.bmc.databasemanagement.responses.ListRolesResponse;
import com.oracle.bmc.databasemanagement.responses.ListSystemPrivilegesResponse;
import com.oracle.bmc.databasemanagement.responses.ListTableStatisticsResponse;
import com.oracle.bmc.databasemanagement.responses.ListTablespacesResponse;
import com.oracle.bmc.databasemanagement.responses.ListUsersResponse;
import com.oracle.bmc.databasemanagement.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.databasemanagement.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.databasemanagement.responses.ListWorkRequestsResponse;
import com.oracle.bmc.databasemanagement.responses.RemoveDataFileResponse;
import com.oracle.bmc.databasemanagement.responses.RemoveManagedDatabaseFromManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.ResetDatabaseParametersResponse;
import com.oracle.bmc.databasemanagement.responses.ResizeDataFileResponse;
import com.oracle.bmc.databasemanagement.responses.RunHistoricAddmResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAwrDbCpuUsagesResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAwrDbMetricsResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAwrDbParameterChangesResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAwrDbParametersResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAwrDbSnapshotRangesResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAwrDbSysstatsResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAwrDbTopWaitEventsResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAwrDbWaitEventBucketsResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAwrDbWaitEventsResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeJobExecutionsStatusesResponse;
import com.oracle.bmc.databasemanagement.responses.TestPreferredCredentialResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateDbManagementPrivateEndpointResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateJobResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.UpdatePreferredCredentialResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateTablespaceResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbManagementClient
extends BaseSyncClient
implements DbManagement {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DBMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://dbmgmt.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DbManagementAsyncClient.class);
    private final DbManagementWaiters waiters;
    private final DbManagementPaginators paginators;

    private DbManagementClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("DbManagement-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DbManagementWaiters(executorService, this);
        this.paginators = new DbManagementPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AddDataFilesResponse addDataFiles(AddDataFilesRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTablespaceName(), (String)"tablespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddDataFilesDetails(), "addDataFilesDetails is required");
        return (AddDataFilesResponse)this.clientCall(request, AddDataFilesResponse::builder).logger(LOG, "addDataFiles").serviceDetails("DbManagement", "AddDataFiles", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Tablespace/AddDataFiles").method(Method.POST).requestBuilder(AddDataFilesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("tablespaces").appendPathParam(request.getTablespaceName()).appendPathParam("actions").appendPathParam("addDataFiles").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TablespaceAdminStatus.class, AddDataFilesResponse.Builder::tablespaceAdminStatus).handleResponseHeaderString("opc-request-id", AddDataFilesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public AddManagedDatabaseToManagedDatabaseGroupResponse addManagedDatabaseToManagedDatabaseGroup(AddManagedDatabaseToManagedDatabaseGroupRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseGroupId(), (String)"managedDatabaseGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddManagedDatabaseToManagedDatabaseGroupDetails(), "addManagedDatabaseToManagedDatabaseGroupDetails is required");
        return (AddManagedDatabaseToManagedDatabaseGroupResponse)this.clientCall(request, AddManagedDatabaseToManagedDatabaseGroupResponse::builder).logger(LOG, "addManagedDatabaseToManagedDatabaseGroup").serviceDetails("DbManagement", "AddManagedDatabaseToManagedDatabaseGroup", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabaseGroup/AddManagedDatabaseToManagedDatabaseGroup").method(Method.POST).requestBuilder(AddManagedDatabaseToManagedDatabaseGroupRequest::builder).basePath("/20201101").appendPathParam("managedDatabaseGroups").appendPathParam(request.getManagedDatabaseGroupId()).appendPathParam("actions").appendPathParam("addManagedDatabase").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", AddManagedDatabaseToManagedDatabaseGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public AddmTasksResponse addmTasks(AddmTasksRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getTimeStart(), "timeStart is required");
        Objects.requireNonNull(request.getTimeEnd(), "timeEnd is required");
        return (AddmTasksResponse)this.clientCall(request, AddmTasksResponse::builder).logger(LOG, "addmTasks").serviceDetails("DbManagement", "AddmTasks", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/AddmTasksCollection/AddmTasks").method(Method.GET).requestBuilder(AddmTasksRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("addmTasks").appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AddmTasksCollection.class, AddmTasksResponse.Builder::addmTasksCollection).handleResponseHeaderString("opc-request-id", AddmTasksResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", AddmTasksResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ChangeDatabaseParametersResponse changeDatabaseParameters(ChangeDatabaseParametersRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDatabaseParametersDetails(), "changeDatabaseParametersDetails is required");
        return (ChangeDatabaseParametersResponse)this.clientCall(request, ChangeDatabaseParametersResponse::builder).logger(LOG, "changeDatabaseParameters").serviceDetails("DbManagement", "ChangeDatabaseParameters", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ChangeDatabaseParameters").method(Method.POST).requestBuilder(ChangeDatabaseParametersRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("actions").appendPathParam("changeDatabaseParameters").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(UpdateDatabaseParametersResult.class, ChangeDatabaseParametersResponse.Builder::updateDatabaseParametersResult).handleResponseHeaderString("opc-request-id", ChangeDatabaseParametersResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeDbManagementPrivateEndpointCompartmentResponse changeDbManagementPrivateEndpointCompartment(ChangeDbManagementPrivateEndpointCompartmentRequest request) {
        Validate.notBlank((String)request.getDbManagementPrivateEndpointId(), (String)"dbManagementPrivateEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDbManagementPrivateEndpointCompartmentDetails(), "changeDbManagementPrivateEndpointCompartmentDetails is required");
        return (ChangeDbManagementPrivateEndpointCompartmentResponse)this.clientCall(request, ChangeDbManagementPrivateEndpointCompartmentResponse::builder).logger(LOG, "changeDbManagementPrivateEndpointCompartment").serviceDetails("DbManagement", "ChangeDbManagementPrivateEndpointCompartment", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/DbManagementPrivateEndpoint/ChangeDbManagementPrivateEndpointCompartment").method(Method.POST).requestBuilder(ChangeDbManagementPrivateEndpointCompartmentRequest::builder).basePath("/20201101").appendPathParam("dbManagementPrivateEndpoints").appendPathParam(request.getDbManagementPrivateEndpointId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangeDbManagementPrivateEndpointCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeJobCompartmentResponse changeJobCompartment(ChangeJobCompartmentRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeJobCompartmentDetails(), "changeJobCompartmentDetails is required");
        return (ChangeJobCompartmentResponse)this.clientCall(request, ChangeJobCompartmentResponse::builder).logger(LOG, "changeJobCompartment").serviceDetails("DbManagement", "ChangeJobCompartment", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Job/ChangeJobCompartment").method(Method.POST).requestBuilder(ChangeJobCompartmentRequest::builder).basePath("/20201101").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangeJobCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeManagedDatabaseGroupCompartmentResponse changeManagedDatabaseGroupCompartment(ChangeManagedDatabaseGroupCompartmentRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseGroupId(), (String)"managedDatabaseGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeManagedDatabaseGroupCompartmentDetails(), "changeManagedDatabaseGroupCompartmentDetails is required");
        return (ChangeManagedDatabaseGroupCompartmentResponse)this.clientCall(request, ChangeManagedDatabaseGroupCompartmentResponse::builder).logger(LOG, "changeManagedDatabaseGroupCompartment").serviceDetails("DbManagement", "ChangeManagedDatabaseGroupCompartment", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabaseGroup/ChangeManagedDatabaseGroupCompartment").method(Method.POST).requestBuilder(ChangeManagedDatabaseGroupCompartmentRequest::builder).basePath("/20201101").appendPathParam("managedDatabaseGroups").appendPathParam(request.getManagedDatabaseGroupId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangeManagedDatabaseGroupCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDbManagementPrivateEndpointResponse createDbManagementPrivateEndpoint(CreateDbManagementPrivateEndpointRequest request) {
        Objects.requireNonNull(request.getCreateDbManagementPrivateEndpointDetails(), "createDbManagementPrivateEndpointDetails is required");
        return (CreateDbManagementPrivateEndpointResponse)this.clientCall(request, CreateDbManagementPrivateEndpointResponse::builder).logger(LOG, "createDbManagementPrivateEndpoint").serviceDetails("DbManagement", "CreateDbManagementPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/DbManagementPrivateEndpoint/CreateDbManagementPrivateEndpoint").method(Method.POST).requestBuilder(CreateDbManagementPrivateEndpointRequest::builder).basePath("/20201101").appendPathParam("dbManagementPrivateEndpoints").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DbManagementPrivateEndpoint.class, CreateDbManagementPrivateEndpointResponse.Builder::dbManagementPrivateEndpoint).handleResponseHeaderString("etag", CreateDbManagementPrivateEndpointResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateDbManagementPrivateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDbManagementPrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateDbManagementPrivateEndpointResponse.Builder::location).callSync();
    }

    @Override
    public CreateJobResponse createJob(CreateJobRequest request) {
        Objects.requireNonNull(request.getCreateJobDetails(), "createJobDetails is required");
        return (CreateJobResponse)this.clientCall(request, CreateJobResponse::builder).logger(LOG, "createJob").serviceDetails("DbManagement", "CreateJob", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Job/CreateJob").method(Method.POST).requestBuilder(CreateJobRequest::builder).basePath("/20201101").appendPathParam("jobs").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Job.class, CreateJobResponse.Builder::job).handleResponseHeaderString("location", CreateJobResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateJobResponse.Builder::etag).callSync();
    }

    @Override
    public CreateManagedDatabaseGroupResponse createManagedDatabaseGroup(CreateManagedDatabaseGroupRequest request) {
        Objects.requireNonNull(request.getCreateManagedDatabaseGroupDetails(), "createManagedDatabaseGroupDetails is required");
        return (CreateManagedDatabaseGroupResponse)this.clientCall(request, CreateManagedDatabaseGroupResponse::builder).logger(LOG, "createManagedDatabaseGroup").serviceDetails("DbManagement", "CreateManagedDatabaseGroup", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabaseGroup/CreateManagedDatabaseGroup").method(Method.POST).requestBuilder(CreateManagedDatabaseGroupRequest::builder).basePath("/20201101").appendPathParam("managedDatabaseGroups").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ManagedDatabaseGroup.class, CreateManagedDatabaseGroupResponse.Builder::managedDatabaseGroup).handleResponseHeaderString("location", CreateManagedDatabaseGroupResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateManagedDatabaseGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateManagedDatabaseGroupResponse.Builder::etag).callSync();
    }

    @Override
    public CreateTablespaceResponse createTablespace(CreateTablespaceRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateTablespaceDetails(), "createTablespaceDetails is required");
        return (CreateTablespaceResponse)this.clientCall(request, CreateTablespaceResponse::builder).logger(LOG, "createTablespace").serviceDetails("DbManagement", "CreateTablespace", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Tablespace/CreateTablespace").method(Method.POST).requestBuilder(CreateTablespaceRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("tablespaces").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Tablespace.class, CreateTablespaceResponse.Builder::tablespace).handleResponseHeaderString("opc-request-id", CreateTablespaceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDbManagementPrivateEndpointResponse deleteDbManagementPrivateEndpoint(DeleteDbManagementPrivateEndpointRequest request) {
        Validate.notBlank((String)request.getDbManagementPrivateEndpointId(), (String)"dbManagementPrivateEndpointId must not be blank", (Object[])new Object[0]);
        return (DeleteDbManagementPrivateEndpointResponse)this.clientCall(request, DeleteDbManagementPrivateEndpointResponse::builder).logger(LOG, "deleteDbManagementPrivateEndpoint").serviceDetails("DbManagement", "DeleteDbManagementPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/DbManagementPrivateEndpoint/DeleteDbManagementPrivateEndpoint").method(Method.DELETE).requestBuilder(DeleteDbManagementPrivateEndpointRequest::builder).basePath("/20201101").appendPathParam("dbManagementPrivateEndpoints").appendPathParam(request.getDbManagementPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteDbManagementPrivateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDbManagementPrivateEndpointResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteJobResponse deleteJob(DeleteJobRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (DeleteJobResponse)this.clientCall(request, DeleteJobResponse::builder).logger(LOG, "deleteJob").serviceDetails("DbManagement", "DeleteJob", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Job/DeleteJob").method(Method.DELETE).requestBuilder(DeleteJobRequest::builder).basePath("/20201101").appendPathParam("jobs").appendPathParam(request.getJobId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteManagedDatabaseGroupResponse deleteManagedDatabaseGroup(DeleteManagedDatabaseGroupRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseGroupId(), (String)"managedDatabaseGroupId must not be blank", (Object[])new Object[0]);
        return (DeleteManagedDatabaseGroupResponse)this.clientCall(request, DeleteManagedDatabaseGroupResponse::builder).logger(LOG, "deleteManagedDatabaseGroup").serviceDetails("DbManagement", "DeleteManagedDatabaseGroup", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabaseGroup/DeleteManagedDatabaseGroup").method(Method.DELETE).requestBuilder(DeleteManagedDatabaseGroupRequest::builder).basePath("/20201101").appendPathParam("managedDatabaseGroups").appendPathParam(request.getManagedDatabaseGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteManagedDatabaseGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeletePreferredCredentialResponse deletePreferredCredential(DeletePreferredCredentialRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCredentialName(), (String)"credentialName must not be blank", (Object[])new Object[0]);
        return (DeletePreferredCredentialResponse)this.clientCall(request, DeletePreferredCredentialResponse::builder).logger(LOG, "deletePreferredCredential").serviceDetails("DbManagement", "DeletePreferredCredential", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/PreferredCredential/DeletePreferredCredential").method(Method.DELETE).requestBuilder(DeletePreferredCredentialRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("preferredCredentials").appendPathParam(request.getCredentialName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeletePreferredCredentialResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DropTablespaceResponse dropTablespace(DropTablespaceRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTablespaceName(), (String)"tablespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDropTablespaceDetails(), "dropTablespaceDetails is required");
        return (DropTablespaceResponse)this.clientCall(request, DropTablespaceResponse::builder).logger(LOG, "dropTablespace").serviceDetails("DbManagement", "DropTablespace", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Tablespace/DropTablespace").method(Method.POST).requestBuilder(DropTablespaceRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("tablespaces").appendPathParam(request.getTablespaceName()).appendPathParam("actions").appendPathParam("dropTablespace").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TablespaceAdminStatus.class, DropTablespaceResponse.Builder::tablespaceAdminStatus).handleResponseHeaderString("opc-request-id", DropTablespaceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GenerateAwrSnapshotResponse generateAwrSnapshot(GenerateAwrSnapshotRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (GenerateAwrSnapshotResponse)this.clientCall(request, GenerateAwrSnapshotResponse::builder).logger(LOG, "generateAwrSnapshot").serviceDetails("DbManagement", "GenerateAwrSnapshot", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/SnapshotDetails/GenerateAwrSnapshot").method(Method.POST).requestBuilder(GenerateAwrSnapshotRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("actions").appendPathParam("generateAwrSnapshot").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SnapshotDetails.class, GenerateAwrSnapshotResponse.Builder::snapshotDetails).handleResponseHeaderString("opc-request-id", GenerateAwrSnapshotResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetAwrDbReportResponse getAwrDbReport(GetAwrDbReportRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        return (GetAwrDbReportResponse)this.clientCall(request, GetAwrDbReportResponse::builder).logger(LOG, "getAwrDbReport").serviceDetails("DbManagement", "GetAwrDbReport", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetAwrDbReport").method(Method.GET).requestBuilder(GetAwrDbReportRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbReport").appendListQueryParam("instNums", request.getInstNums(), CollectionFormatType.CommaSeparated).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendEnumQueryParam("reportType", (BmcEnum)request.getReportType()).appendQueryParam("containerId", (Object)request.getContainerId()).appendEnumQueryParam("reportFormat", (BmcEnum)request.getReportFormat()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(AwrDbReport.class, GetAwrDbReportResponse.Builder::awrDbReport).handleResponseHeaderString("opc-request-id", GetAwrDbReportResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetAwrDbSqlReportResponse getAwrDbSqlReport(GetAwrDbSqlReportRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSqlId(), "sqlId is required");
        return (GetAwrDbSqlReportResponse)this.clientCall(request, GetAwrDbSqlReportResponse::builder).logger(LOG, "getAwrDbSqlReport").serviceDetails("DbManagement", "GetAwrDbSqlReport", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetAwrDbSqlReport").method(Method.GET).requestBuilder(GetAwrDbSqlReportRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbSqlReport").appendQueryParam("instNum", (Object)request.getInstNum()).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendQueryParam("sqlId", (Object)request.getSqlId()).appendEnumQueryParam("reportFormat", (BmcEnum)request.getReportFormat()).appendQueryParam("containerId", (Object)request.getContainerId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(AwrDbSqlReport.class, GetAwrDbSqlReportResponse.Builder::awrDbSqlReport).handleResponseHeaderString("opc-request-id", GetAwrDbSqlReportResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetClusterCacheMetricResponse getClusterCacheMetric(GetClusterCacheMetricRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStartTime(), "startTime is required");
        Objects.requireNonNull(request.getEndTime(), "endTime is required");
        return (GetClusterCacheMetricResponse)this.clientCall(request, GetClusterCacheMetricResponse::builder).logger(LOG, "getClusterCacheMetric").serviceDetails("DbManagement", "GetClusterCacheMetric", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ClusterCacheMetric/GetClusterCacheMetric").method(Method.GET).requestBuilder(GetClusterCacheMetricRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("clusterCacheMetrics").appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ClusterCacheMetric.class, GetClusterCacheMetricResponse.Builder::clusterCacheMetric).handleResponseHeaderString("opc-request-id", GetClusterCacheMetricResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDatabaseFleetHealthMetricsResponse getDatabaseFleetHealthMetrics(GetDatabaseFleetHealthMetricsRequest request) {
        Objects.requireNonNull(request.getCompareBaselineTime(), "compareBaselineTime is required");
        Objects.requireNonNull(request.getCompareTargetTime(), "compareTargetTime is required");
        return (GetDatabaseFleetHealthMetricsResponse)this.clientCall(request, GetDatabaseFleetHealthMetricsResponse::builder).logger(LOG, "getDatabaseFleetHealthMetrics").serviceDetails("DbManagement", "GetDatabaseFleetHealthMetrics", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/DatabaseFleetHealthMetrics/GetDatabaseFleetHealthMetrics").method(Method.GET).requestBuilder(GetDatabaseFleetHealthMetricsRequest::builder).basePath("/20201101").appendPathParam("fleetMetrics").appendQueryParam("managedDatabaseGroupId", (Object)request.getManagedDatabaseGroupId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compareBaselineTime", (Object)request.getCompareBaselineTime()).appendQueryParam("compareTargetTime", (Object)request.getCompareTargetTime()).appendEnumQueryParam("compareType", (BmcEnum)request.getCompareType()).appendQueryParam("filterByMetricNames", (Object)request.getFilterByMetricNames()).appendQueryParam("filterByDatabaseType", (Object)request.getFilterByDatabaseType()).appendQueryParam("filterByDatabaseSubType", (Object)request.getFilterByDatabaseSubType()).appendQueryParam("filterByDatabaseDeploymentType", (Object)request.getFilterByDatabaseDeploymentType()).appendQueryParam("filterByDatabaseVersion", (Object)request.getFilterByDatabaseVersion()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DatabaseFleetHealthMetrics.class, GetDatabaseFleetHealthMetricsResponse.Builder::databaseFleetHealthMetrics).handleResponseHeaderString("opc-request-id", GetDatabaseFleetHealthMetricsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDatabaseHomeMetricsResponse getDatabaseHomeMetrics(GetDatabaseHomeMetricsRequest request) {
        Objects.requireNonNull(request.getManagedDatabaseId(), "managedDatabaseId is required");
        Objects.requireNonNull(request.getStartTime(), "startTime is required");
        Objects.requireNonNull(request.getEndTime(), "endTime is required");
        return (GetDatabaseHomeMetricsResponse)this.clientCall(request, GetDatabaseHomeMetricsResponse::builder).logger(LOG, "getDatabaseHomeMetrics").serviceDetails("DbManagement", "GetDatabaseHomeMetrics", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/DatabaseHomeMetrics/GetDatabaseHomeMetrics").method(Method.GET).requestBuilder(GetDatabaseHomeMetricsRequest::builder).basePath("/20201101").appendPathParam("databaseHomeMetrics").appendQueryParam("managedDatabaseId", (Object)request.getManagedDatabaseId()).appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DatabaseHomeMetrics.class, GetDatabaseHomeMetricsResponse.Builder::databaseHomeMetrics).handleResponseHeaderString("opc-request-id", GetDatabaseHomeMetricsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDbManagementPrivateEndpointResponse getDbManagementPrivateEndpoint(GetDbManagementPrivateEndpointRequest request) {
        Validate.notBlank((String)request.getDbManagementPrivateEndpointId(), (String)"dbManagementPrivateEndpointId must not be blank", (Object[])new Object[0]);
        return (GetDbManagementPrivateEndpointResponse)this.clientCall(request, GetDbManagementPrivateEndpointResponse::builder).logger(LOG, "getDbManagementPrivateEndpoint").serviceDetails("DbManagement", "GetDbManagementPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/DbManagementPrivateEndpoint/GetDbManagementPrivateEndpoint").method(Method.GET).requestBuilder(GetDbManagementPrivateEndpointRequest::builder).basePath("/20201101").appendPathParam("dbManagementPrivateEndpoints").appendPathParam(request.getDbManagementPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DbManagementPrivateEndpoint.class, GetDbManagementPrivateEndpointResponse.Builder::dbManagementPrivateEndpoint).handleResponseHeaderString("etag", GetDbManagementPrivateEndpointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDbManagementPrivateEndpointResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetJobResponse getJob(GetJobRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (GetJobResponse)this.clientCall(request, GetJobResponse::builder).logger(LOG, "getJob").serviceDetails("DbManagement", "GetJob", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Job/GetJob").method(Method.GET).requestBuilder(GetJobRequest::builder).basePath("/20201101").appendPathParam("jobs").appendPathParam(request.getJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Job.class, GetJobResponse.Builder::job).handleResponseHeaderString("location", GetJobResponse.Builder::location).handleResponseHeaderString("opc-request-id", GetJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetJobResponse.Builder::etag).callSync();
    }

    @Override
    public GetJobExecutionResponse getJobExecution(GetJobExecutionRequest request) {
        Validate.notBlank((String)request.getJobExecutionId(), (String)"jobExecutionId must not be blank", (Object[])new Object[0]);
        return (GetJobExecutionResponse)this.clientCall(request, GetJobExecutionResponse::builder).logger(LOG, "getJobExecution").serviceDetails("DbManagement", "GetJobExecution", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/JobExecution/GetJobExecution").method(Method.GET).requestBuilder(GetJobExecutionRequest::builder).basePath("/20201101").appendPathParam("jobExecutions").appendPathParam(request.getJobExecutionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobExecution.class, GetJobExecutionResponse.Builder::jobExecution).handleResponseHeaderString("opc-request-id", GetJobExecutionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetJobRunResponse getJobRun(GetJobRunRequest request) {
        Validate.notBlank((String)request.getJobRunId(), (String)"jobRunId must not be blank", (Object[])new Object[0]);
        return (GetJobRunResponse)this.clientCall(request, GetJobRunResponse::builder).logger(LOG, "getJobRun").serviceDetails("DbManagement", "GetJobRun", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/JobRun/GetJobRun").method(Method.GET).requestBuilder(GetJobRunRequest::builder).basePath("/20201101").appendPathParam("jobRuns").appendPathParam(request.getJobRunId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobRun.class, GetJobRunResponse.Builder::jobRun).handleResponseHeaderString("opc-request-id", GetJobRunResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetManagedDatabaseResponse getManagedDatabase(GetManagedDatabaseRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (GetManagedDatabaseResponse)this.clientCall(request, GetManagedDatabaseResponse::builder).logger(LOG, "getManagedDatabase").serviceDetails("DbManagement", "GetManagedDatabase", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetManagedDatabase").method(Method.GET).requestBuilder(GetManagedDatabaseRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedDatabase.class, GetManagedDatabaseResponse.Builder::managedDatabase).handleResponseHeaderString("opc-request-id", GetManagedDatabaseResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetManagedDatabaseGroupResponse getManagedDatabaseGroup(GetManagedDatabaseGroupRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseGroupId(), (String)"managedDatabaseGroupId must not be blank", (Object[])new Object[0]);
        return (GetManagedDatabaseGroupResponse)this.clientCall(request, GetManagedDatabaseGroupResponse::builder).logger(LOG, "getManagedDatabaseGroup").serviceDetails("DbManagement", "GetManagedDatabaseGroup", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabaseGroup/GetManagedDatabaseGroup").method(Method.GET).requestBuilder(GetManagedDatabaseGroupRequest::builder).basePath("/20201101").appendPathParam("managedDatabaseGroups").appendPathParam(request.getManagedDatabaseGroupId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedDatabaseGroup.class, GetManagedDatabaseGroupResponse.Builder::managedDatabaseGroup).handleResponseHeaderString("opc-request-id", GetManagedDatabaseGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetManagedDatabaseGroupResponse.Builder::etag).callSync();
    }

    @Override
    public GetOptimizerStatisticsAdvisorExecutionResponse getOptimizerStatisticsAdvisorExecution(GetOptimizerStatisticsAdvisorExecutionRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getExecutionName(), (String)"executionName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getTaskName(), "taskName is required");
        return (GetOptimizerStatisticsAdvisorExecutionResponse)this.clientCall(request, GetOptimizerStatisticsAdvisorExecutionResponse::builder).logger(LOG, "getOptimizerStatisticsAdvisorExecution").serviceDetails("DbManagement", "GetOptimizerStatisticsAdvisorExecution", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetOptimizerStatisticsAdvisorExecution").method(Method.GET).requestBuilder(GetOptimizerStatisticsAdvisorExecutionRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("optimizerStatisticsAdvisorExecutions").appendPathParam(request.getExecutionName()).appendQueryParam("taskName", (Object)request.getTaskName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OptimizerStatisticsAdvisorExecution.class, GetOptimizerStatisticsAdvisorExecutionResponse.Builder::optimizerStatisticsAdvisorExecution).handleResponseHeaderString("opc-request-id", GetOptimizerStatisticsAdvisorExecutionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetOptimizerStatisticsAdvisorExecutionScriptResponse getOptimizerStatisticsAdvisorExecutionScript(GetOptimizerStatisticsAdvisorExecutionScriptRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getExecutionName(), (String)"executionName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getTaskName(), "taskName is required");
        return (GetOptimizerStatisticsAdvisorExecutionScriptResponse)this.clientCall(request, GetOptimizerStatisticsAdvisorExecutionScriptResponse::builder).logger(LOG, "getOptimizerStatisticsAdvisorExecutionScript").serviceDetails("DbManagement", "GetOptimizerStatisticsAdvisorExecutionScript", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetOptimizerStatisticsAdvisorExecutionScript").method(Method.GET).requestBuilder(GetOptimizerStatisticsAdvisorExecutionScriptRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("optimizerStatisticsAdvisorExecutions").appendPathParam(request.getExecutionName()).appendPathParam("script").appendQueryParam("taskName", (Object)request.getTaskName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OptimizerStatisticsAdvisorExecutionScript.class, GetOptimizerStatisticsAdvisorExecutionScriptResponse.Builder::optimizerStatisticsAdvisorExecutionScript).handleResponseHeaderString("opc-request-id", GetOptimizerStatisticsAdvisorExecutionScriptResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetOptimizerStatisticsCollectionOperationResponse getOptimizerStatisticsCollectionOperation(GetOptimizerStatisticsCollectionOperationRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (GetOptimizerStatisticsCollectionOperationResponse)this.clientCall(request, GetOptimizerStatisticsCollectionOperationResponse::builder).logger(LOG, "getOptimizerStatisticsCollectionOperation").serviceDetails("DbManagement", "GetOptimizerStatisticsCollectionOperation", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetOptimizerStatisticsCollectionOperation").method(Method.GET).requestBuilder(GetOptimizerStatisticsCollectionOperationRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("optimizerStatisticsCollectionOperations").appendPathParam((Number)request.getOptimizerStatisticsCollectionOperationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OptimizerStatisticsCollectionOperation.class, GetOptimizerStatisticsCollectionOperationResponse.Builder::optimizerStatisticsCollectionOperation).handleResponseHeaderString("opc-request-id", GetOptimizerStatisticsCollectionOperationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPdbMetricsResponse getPdbMetrics(GetPdbMetricsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStartTime(), "startTime is required");
        Objects.requireNonNull(request.getEndTime(), "endTime is required");
        return (GetPdbMetricsResponse)this.clientCall(request, GetPdbMetricsResponse::builder).logger(LOG, "getPdbMetrics").serviceDetails("DbManagement", "GetPdbMetrics", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/PdbMetrics/GetPdbMetrics").method(Method.GET).requestBuilder(GetPdbMetricsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("pdbMetrics").appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("compareType", (BmcEnum)request.getCompareType()).appendQueryParam("filterByMetricNames", (Object)request.getFilterByMetricNames()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PdbMetrics.class, GetPdbMetricsResponse.Builder::pdbMetrics).handleResponseHeaderString("opc-request-id", GetPdbMetricsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPreferredCredentialResponse getPreferredCredential(GetPreferredCredentialRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCredentialName(), (String)"credentialName must not be blank", (Object[])new Object[0]);
        return (GetPreferredCredentialResponse)this.clientCall(request, GetPreferredCredentialResponse::builder).logger(LOG, "getPreferredCredential").serviceDetails("DbManagement", "GetPreferredCredential", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/PreferredCredential/GetPreferredCredential").method(Method.GET).requestBuilder(GetPreferredCredentialRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("preferredCredentials").appendPathParam(request.getCredentialName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PreferredCredential.class, GetPreferredCredentialResponse.Builder::preferredCredential).handleResponseHeaderString("opc-request-id", GetPreferredCredentialResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetPreferredCredentialResponse.Builder::etag).callSync();
    }

    @Override
    public GetTablespaceResponse getTablespace(GetTablespaceRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTablespaceName(), (String)"tablespaceName must not be blank", (Object[])new Object[0]);
        return (GetTablespaceResponse)this.clientCall(request, GetTablespaceResponse::builder).logger(LOG, "getTablespace").serviceDetails("DbManagement", "GetTablespace", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Tablespace/GetTablespace").method(Method.GET).requestBuilder(GetTablespaceRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("tablespaces").appendPathParam(request.getTablespaceName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Tablespace.class, GetTablespaceResponse.Builder::tablespace).handleResponseHeaderString("opc-request-id", GetTablespaceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetUserResponse getUser(GetUserRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserName(), (String)"userName must not be blank", (Object[])new Object[0]);
        return (GetUserResponse)this.clientCall(request, GetUserResponse::builder).logger(LOG, "getUser").serviceDetails("DbManagement", "GetUser", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetUser").method(Method.GET).requestBuilder(GetUserRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("users").appendPathParam(request.getUserName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(User.class, GetUserResponse.Builder::user).handleResponseHeaderString("opc-request-id", GetUserResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("DbManagement", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20201101").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ImplementOptimizerStatisticsAdvisorRecommendationsResponse implementOptimizerStatisticsAdvisorRecommendations(ImplementOptimizerStatisticsAdvisorRecommendationsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getExecutionName(), (String)"executionName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getImplementOptimizerStatisticsAdvisorRecommendationsDetails(), "implementOptimizerStatisticsAdvisorRecommendationsDetails is required");
        return (ImplementOptimizerStatisticsAdvisorRecommendationsResponse)this.clientCall(request, ImplementOptimizerStatisticsAdvisorRecommendationsResponse::builder).logger(LOG, "implementOptimizerStatisticsAdvisorRecommendations").serviceDetails("DbManagement", "ImplementOptimizerStatisticsAdvisorRecommendations", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ImplementOptimizerStatisticsAdvisorRecommendations").method(Method.POST).requestBuilder(ImplementOptimizerStatisticsAdvisorRecommendationsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("optimizerStatisticsAdvisorExecutions").appendPathParam(request.getExecutionName()).appendPathParam("actions").appendPathParam("implementRecommendations").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Job.class, ImplementOptimizerStatisticsAdvisorRecommendationsResponse.Builder::job).handleResponseHeaderString("opc-request-id", ImplementOptimizerStatisticsAdvisorRecommendationsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListAsmPropertiesResponse listAsmProperties(ListAsmPropertiesRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (ListAsmPropertiesResponse)this.clientCall(request, ListAsmPropertiesResponse::builder).logger(LOG, "listAsmProperties").serviceDetails("DbManagement", "ListAsmProperties", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListAsmProperties").method(Method.GET).requestBuilder(ListAsmPropertiesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("asmProperties").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AsmPropertyCollection.class, ListAsmPropertiesResponse.Builder::asmPropertyCollection).handleResponseHeaderString("opc-request-id", ListAsmPropertiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAsmPropertiesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListAssociatedDatabasesResponse listAssociatedDatabases(ListAssociatedDatabasesRequest request) {
        Validate.notBlank((String)request.getDbManagementPrivateEndpointId(), (String)"dbManagementPrivateEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListAssociatedDatabasesResponse)this.clientCall(request, ListAssociatedDatabasesResponse::builder).logger(LOG, "listAssociatedDatabases").serviceDetails("DbManagement", "ListAssociatedDatabases", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/AssociatedDatabaseSummary/ListAssociatedDatabases").method(Method.GET).requestBuilder(ListAssociatedDatabasesRequest::builder).basePath("/20201101").appendPathParam("dbManagementPrivateEndpoints").appendPathParam(request.getDbManagementPrivateEndpointId()).appendPathParam("associatedDatabases").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AssociatedDatabaseCollection.class, ListAssociatedDatabasesResponse.Builder::associatedDatabaseCollection).handleResponseHeaderString("opc-next-page", ListAssociatedDatabasesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAssociatedDatabasesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListAwrDbSnapshotsResponse listAwrDbSnapshots(ListAwrDbSnapshotsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        return (ListAwrDbSnapshotsResponse)this.clientCall(request, ListAwrDbSnapshotsResponse::builder).logger(LOG, "listAwrDbSnapshots").serviceDetails("DbManagement", "ListAwrDbSnapshots", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListAwrDbSnapshots").method(Method.GET).requestBuilder(ListAwrDbSnapshotsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbSnapshots").appendQueryParam("instNum", (Object)request.getInstNum()).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendQueryParam("containerId", (Object)request.getContainerId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(AwrDbSnapshotCollection.class, ListAwrDbSnapshotsResponse.Builder::awrDbSnapshotCollection).handleResponseHeaderString("opc-request-id", ListAwrDbSnapshotsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAwrDbSnapshotsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListAwrDbsResponse listAwrDbs(ListAwrDbsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (ListAwrDbsResponse)this.clientCall(request, ListAwrDbsResponse::builder).logger(LOG, "listAwrDbs").serviceDetails("DbManagement", "ListAwrDbs", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListAwrDbs").method(Method.GET).requestBuilder(ListAwrDbsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendQueryParam("name", (Object)request.getName()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(AwrDbCollection.class, ListAwrDbsResponse.Builder::awrDbCollection).handleResponseHeaderString("opc-request-id", ListAwrDbsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAwrDbsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListConsumerGroupPrivilegesResponse listConsumerGroupPrivileges(ListConsumerGroupPrivilegesRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserName(), (String)"userName must not be blank", (Object[])new Object[0]);
        return (ListConsumerGroupPrivilegesResponse)this.clientCall(request, ListConsumerGroupPrivilegesResponse::builder).logger(LOG, "listConsumerGroupPrivileges").serviceDetails("DbManagement", "ListConsumerGroupPrivileges", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListConsumerGroupPrivileges").method(Method.GET).requestBuilder(ListConsumerGroupPrivilegesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("users").appendPathParam(request.getUserName()).appendPathParam("consumerGroupPrivileges").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConsumerGroupPrivilegeCollection.class, ListConsumerGroupPrivilegesResponse.Builder::consumerGroupPrivilegeCollection).handleResponseHeaderString("opc-next-page", ListConsumerGroupPrivilegesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListConsumerGroupPrivilegesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDataAccessContainersResponse listDataAccessContainers(ListDataAccessContainersRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserName(), (String)"userName must not be blank", (Object[])new Object[0]);
        return (ListDataAccessContainersResponse)this.clientCall(request, ListDataAccessContainersResponse::builder).logger(LOG, "listDataAccessContainers").serviceDetails("DbManagement", "ListDataAccessContainers", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListDataAccessContainers").method(Method.GET).requestBuilder(ListDataAccessContainersRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("users").appendPathParam(request.getUserName()).appendPathParam("dataAccessContainers").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataAccessContainerCollection.class, ListDataAccessContainersResponse.Builder::dataAccessContainerCollection).handleResponseHeaderString("opc-next-page", ListDataAccessContainersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDataAccessContainersResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDatabaseParametersResponse listDatabaseParameters(ListDatabaseParametersRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (ListDatabaseParametersResponse)this.clientCall(request, ListDatabaseParametersResponse::builder).logger(LOG, "listDatabaseParameters").serviceDetails("DbManagement", "ListDatabaseParameters", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListDatabaseParameters").method(Method.GET).requestBuilder(ListDatabaseParametersRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("databaseParameters").appendEnumQueryParam("source", (BmcEnum)request.getSource()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("isAllowedValuesIncluded", (Object)request.getIsAllowedValuesIncluded()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DatabaseParametersCollection.class, ListDatabaseParametersResponse.Builder::databaseParametersCollection).handleResponseHeaderString("opc-request-id", ListDatabaseParametersResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDbManagementPrivateEndpointsResponse listDbManagementPrivateEndpoints(ListDbManagementPrivateEndpointsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDbManagementPrivateEndpointsResponse)this.clientCall(request, ListDbManagementPrivateEndpointsResponse::builder).logger(LOG, "listDbManagementPrivateEndpoints").serviceDetails("DbManagement", "ListDbManagementPrivateEndpoints", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/DbManagementPrivateEndpoint/ListDbManagementPrivateEndpoints").method(Method.GET).requestBuilder(ListDbManagementPrivateEndpointsRequest::builder).basePath("/20201101").appendPathParam("dbManagementPrivateEndpoints").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("vcnId", (Object)request.getVcnId()).appendQueryParam("isCluster", (Object)request.getIsCluster()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DbManagementPrivateEndpointCollection.class, ListDbManagementPrivateEndpointsResponse.Builder::dbManagementPrivateEndpointCollection).handleResponseHeaderString("opc-request-id", ListDbManagementPrivateEndpointsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDbManagementPrivateEndpointsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListJobExecutionsResponse listJobExecutions(ListJobExecutionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListJobExecutionsResponse)this.clientCall(request, ListJobExecutionsResponse::builder).logger(LOG, "listJobExecutions").serviceDetails("DbManagement", "ListJobExecutions", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/JobExecution/ListJobExecutions").method(Method.GET).requestBuilder(ListJobExecutionsRequest::builder).basePath("/20201101").appendPathParam("jobExecutions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("jobId", (Object)request.getJobId()).appendQueryParam("managedDatabaseId", (Object)request.getManagedDatabaseId()).appendQueryParam("managedDatabaseGroupId", (Object)request.getManagedDatabaseGroupId()).appendQueryParam("status", (Object)request.getStatus()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("jobRunId", (Object)request.getJobRunId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobExecutionCollection.class, ListJobExecutionsResponse.Builder::jobExecutionCollection).handleResponseHeaderString("opc-request-id", ListJobExecutionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJobExecutionsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListJobRunsResponse listJobRuns(ListJobRunsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListJobRunsResponse)this.clientCall(request, ListJobRunsResponse::builder).logger(LOG, "listJobRuns").serviceDetails("DbManagement", "ListJobRuns", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/JobRun/ListJobRuns").method(Method.GET).requestBuilder(ListJobRunsRequest::builder).basePath("/20201101").appendPathParam("jobRuns").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("jobId", (Object)request.getJobId()).appendQueryParam("managedDatabaseId", (Object)request.getManagedDatabaseId()).appendQueryParam("managedDatabaseGroupId", (Object)request.getManagedDatabaseGroupId()).appendQueryParam("runStatus", (Object)request.getRunStatus()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobRunCollection.class, ListJobRunsResponse.Builder::jobRunCollection).handleResponseHeaderString("opc-request-id", ListJobRunsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJobRunsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListJobsResponse listJobs(ListJobsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListJobsResponse)this.clientCall(request, ListJobsResponse::builder).logger(LOG, "listJobs").serviceDetails("DbManagement", "ListJobs", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Job/ListJobs").method(Method.GET).requestBuilder(ListJobsRequest::builder).basePath("/20201101").appendPathParam("jobs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("managedDatabaseGroupId", (Object)request.getManagedDatabaseGroupId()).appendQueryParam("managedDatabaseId", (Object)request.getManagedDatabaseId()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobCollection.class, ListJobsResponse.Builder::jobCollection).handleResponseHeaderString("opc-request-id", ListJobsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJobsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListManagedDatabaseGroupsResponse listManagedDatabaseGroups(ListManagedDatabaseGroupsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListManagedDatabaseGroupsResponse)this.clientCall(request, ListManagedDatabaseGroupsResponse::builder).logger(LOG, "listManagedDatabaseGroups").serviceDetails("DbManagement", "ListManagedDatabaseGroups", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabaseGroup/ListManagedDatabaseGroups").method(Method.GET).requestBuilder(ListManagedDatabaseGroupsRequest::builder).basePath("/20201101").appendPathParam("managedDatabaseGroups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedDatabaseGroupCollection.class, ListManagedDatabaseGroupsResponse.Builder::managedDatabaseGroupCollection).handleResponseHeaderString("opc-request-id", ListManagedDatabaseGroupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedDatabaseGroupsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListManagedDatabasesResponse listManagedDatabases(ListManagedDatabasesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListManagedDatabasesResponse)this.clientCall(request, ListManagedDatabasesResponse::builder).logger(LOG, "listManagedDatabases").serviceDetails("DbManagement", "ListManagedDatabases", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListManagedDatabases").method(Method.GET).requestBuilder(ListManagedDatabasesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("managementOption", (BmcEnum)request.getManagementOption()).appendEnumQueryParam("deploymentType", (BmcEnum)request.getDeploymentType()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedDatabaseCollection.class, ListManagedDatabasesResponse.Builder::managedDatabaseCollection).handleResponseHeaderString("opc-request-id", ListManagedDatabasesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedDatabasesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListObjectPrivilegesResponse listObjectPrivileges(ListObjectPrivilegesRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserName(), (String)"userName must not be blank", (Object[])new Object[0]);
        return (ListObjectPrivilegesResponse)this.clientCall(request, ListObjectPrivilegesResponse::builder).logger(LOG, "listObjectPrivileges").serviceDetails("DbManagement", "ListObjectPrivileges", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListObjectPrivileges").method(Method.GET).requestBuilder(ListObjectPrivilegesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("users").appendPathParam(request.getUserName()).appendPathParam("objectPrivileges").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ObjectPrivilegeCollection.class, ListObjectPrivilegesResponse.Builder::objectPrivilegeCollection).handleResponseHeaderString("opc-next-page", ListObjectPrivilegesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListObjectPrivilegesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListOptimizerStatisticsAdvisorExecutionsResponse listOptimizerStatisticsAdvisorExecutions(ListOptimizerStatisticsAdvisorExecutionsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (ListOptimizerStatisticsAdvisorExecutionsResponse)this.clientCall(request, ListOptimizerStatisticsAdvisorExecutionsResponse::builder).logger(LOG, "listOptimizerStatisticsAdvisorExecutions").serviceDetails("DbManagement", "ListOptimizerStatisticsAdvisorExecutions", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListOptimizerStatisticsAdvisorExecutions").method(Method.GET).requestBuilder(ListOptimizerStatisticsAdvisorExecutionsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("optimizerStatisticsAdvisorExecutions").appendQueryParam("startTimeGreaterThanOrEqualTo", (Object)request.getStartTimeGreaterThanOrEqualTo()).appendQueryParam("endTimeLessThanOrEqualTo", (Object)request.getEndTimeLessThanOrEqualTo()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OptimizerStatisticsAdvisorExecutionsCollection.class, ListOptimizerStatisticsAdvisorExecutionsResponse.Builder::optimizerStatisticsAdvisorExecutionsCollection).handleResponseHeaderString("opc-request-id", ListOptimizerStatisticsAdvisorExecutionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListOptimizerStatisticsCollectionAggregationsResponse listOptimizerStatisticsCollectionAggregations(ListOptimizerStatisticsCollectionAggregationsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getGroupType(), "groupType is required");
        return (ListOptimizerStatisticsCollectionAggregationsResponse)this.clientCall(request, ListOptimizerStatisticsCollectionAggregationsResponse::builder).logger(LOG, "listOptimizerStatisticsCollectionAggregations").serviceDetails("DbManagement", "ListOptimizerStatisticsCollectionAggregations", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListOptimizerStatisticsCollectionAggregations").method(Method.GET).requestBuilder(ListOptimizerStatisticsCollectionAggregationsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("optimizerStatisticsCollectionAggregations").appendQueryParam("startTimeGreaterThanOrEqualTo", (Object)request.getStartTimeGreaterThanOrEqualTo()).appendQueryParam("endTimeLessThanOrEqualTo", (Object)request.getEndTimeLessThanOrEqualTo()).appendEnumQueryParam("taskType", (BmcEnum)request.getTaskType()).appendEnumQueryParam("groupType", (BmcEnum)request.getGroupType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OptimizerStatisticsCollectionAggregationsCollection.class, ListOptimizerStatisticsCollectionAggregationsResponse.Builder::optimizerStatisticsCollectionAggregationsCollection).handleResponseHeaderString("opc-request-id", ListOptimizerStatisticsCollectionAggregationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOptimizerStatisticsCollectionAggregationsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListOptimizerStatisticsCollectionOperationsResponse listOptimizerStatisticsCollectionOperations(ListOptimizerStatisticsCollectionOperationsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (ListOptimizerStatisticsCollectionOperationsResponse)this.clientCall(request, ListOptimizerStatisticsCollectionOperationsResponse::builder).logger(LOG, "listOptimizerStatisticsCollectionOperations").serviceDetails("DbManagement", "ListOptimizerStatisticsCollectionOperations", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListOptimizerStatisticsCollectionOperations").method(Method.GET).requestBuilder(ListOptimizerStatisticsCollectionOperationsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("optimizerStatisticsCollectionOperations").appendQueryParam("startTimeGreaterThanOrEqualTo", (Object)request.getStartTimeGreaterThanOrEqualTo()).appendQueryParam("endTimeLessThanOrEqualTo", (Object)request.getEndTimeLessThanOrEqualTo()).appendEnumQueryParam("taskType", (BmcEnum)request.getTaskType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("filterBy", (Object)request.getFilterBy()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OptimizerStatisticsCollectionOperationsCollection.class, ListOptimizerStatisticsCollectionOperationsResponse.Builder::optimizerStatisticsCollectionOperationsCollection).handleResponseHeaderString("opc-request-id", ListOptimizerStatisticsCollectionOperationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOptimizerStatisticsCollectionOperationsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListPreferredCredentialsResponse listPreferredCredentials(ListPreferredCredentialsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (ListPreferredCredentialsResponse)this.clientCall(request, ListPreferredCredentialsResponse::builder).logger(LOG, "listPreferredCredentials").serviceDetails("DbManagement", "ListPreferredCredentials", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/PreferredCredential/ListPreferredCredentials").method(Method.GET).requestBuilder(ListPreferredCredentialsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("preferredCredentials").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PreferredCredentialCollection.class, ListPreferredCredentialsResponse.Builder::preferredCredentialCollection).handleResponseHeaderString("opc-request-id", ListPreferredCredentialsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPreferredCredentialsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListProxiedForUsersResponse listProxiedForUsers(ListProxiedForUsersRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserName(), (String)"userName must not be blank", (Object[])new Object[0]);
        return (ListProxiedForUsersResponse)this.clientCall(request, ListProxiedForUsersResponse::builder).logger(LOG, "listProxiedForUsers").serviceDetails("DbManagement", "ListProxiedForUsers", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListProxiedForUsers").method(Method.GET).requestBuilder(ListProxiedForUsersRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("users").appendPathParam(request.getUserName()).appendPathParam("proxiedForUsers").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProxiedForUserCollection.class, ListProxiedForUsersResponse.Builder::proxiedForUserCollection).handleResponseHeaderString("opc-next-page", ListProxiedForUsersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListProxiedForUsersResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListProxyUsersResponse listProxyUsers(ListProxyUsersRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserName(), (String)"userName must not be blank", (Object[])new Object[0]);
        return (ListProxyUsersResponse)this.clientCall(request, ListProxyUsersResponse::builder).logger(LOG, "listProxyUsers").serviceDetails("DbManagement", "ListProxyUsers", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListProxyUsers").method(Method.GET).requestBuilder(ListProxyUsersRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("users").appendPathParam(request.getUserName()).appendPathParam("proxyUsers").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProxyUserCollection.class, ListProxyUsersResponse.Builder::proxyUserCollection).handleResponseHeaderString("opc-next-page", ListProxyUsersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListProxyUsersResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListRolesResponse listRoles(ListRolesRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserName(), (String)"userName must not be blank", (Object[])new Object[0]);
        return (ListRolesResponse)this.clientCall(request, ListRolesResponse::builder).logger(LOG, "listRoles").serviceDetails("DbManagement", "ListRoles", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListRoles").method(Method.GET).requestBuilder(ListRolesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("users").appendPathParam(request.getUserName()).appendPathParam("roles").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RoleCollection.class, ListRolesResponse.Builder::roleCollection).handleResponseHeaderString("opc-next-page", ListRolesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListRolesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListSystemPrivilegesResponse listSystemPrivileges(ListSystemPrivilegesRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserName(), (String)"userName must not be blank", (Object[])new Object[0]);
        return (ListSystemPrivilegesResponse)this.clientCall(request, ListSystemPrivilegesResponse::builder).logger(LOG, "listSystemPrivileges").serviceDetails("DbManagement", "ListSystemPrivileges", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListSystemPrivileges").method(Method.GET).requestBuilder(ListSystemPrivilegesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("users").appendPathParam(request.getUserName()).appendPathParam("systemPrivileges").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SystemPrivilegeCollection.class, ListSystemPrivilegesResponse.Builder::systemPrivilegeCollection).handleResponseHeaderString("opc-next-page", ListSystemPrivilegesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSystemPrivilegesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListTableStatisticsResponse listTableStatistics(ListTableStatisticsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (ListTableStatisticsResponse)this.clientCall(request, ListTableStatisticsResponse::builder).logger(LOG, "listTableStatistics").serviceDetails("DbManagement", "ListTableStatistics", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListTableStatistics").method(Method.GET).requestBuilder(ListTableStatisticsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("tableStatistics").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TableStatisticsCollection.class, ListTableStatisticsResponse.Builder::tableStatisticsCollection).handleResponseHeaderString("opc-request-id", ListTableStatisticsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListTablespacesResponse listTablespaces(ListTablespacesRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (ListTablespacesResponse)this.clientCall(request, ListTablespacesResponse::builder).logger(LOG, "listTablespaces").serviceDetails("DbManagement", "ListTablespaces", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Tablespace/ListTablespaces").method(Method.GET).requestBuilder(ListTablespacesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("tablespaces").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TablespaceCollection.class, ListTablespacesResponse.Builder::tablespaceCollection).handleResponseHeaderString("opc-request-id", ListTablespacesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTablespacesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListUsersResponse listUsers(ListUsersRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (ListUsersResponse)this.clientCall(request, ListUsersResponse::builder).logger(LOG, "listUsers").serviceDetails("DbManagement", "ListUsers", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListUsers").method(Method.GET).requestBuilder(ListUsersRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("users").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UserCollection.class, ListUsersResponse.Builder::userCollection).handleResponseHeaderString("opc-next-page", ListUsersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListUsersResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("DbManagement", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20201101").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("DbManagement", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20201101").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("DbManagement", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20201101").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RemoveDataFileResponse removeDataFile(RemoveDataFileRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTablespaceName(), (String)"tablespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveDataFileDetails(), "removeDataFileDetails is required");
        return (RemoveDataFileResponse)this.clientCall(request, RemoveDataFileResponse::builder).logger(LOG, "removeDataFile").serviceDetails("DbManagement", "RemoveDataFile", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Tablespace/RemoveDataFile").method(Method.POST).requestBuilder(RemoveDataFileRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("tablespaces").appendPathParam(request.getTablespaceName()).appendPathParam("actions").appendPathParam("removeDataFile").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TablespaceAdminStatus.class, RemoveDataFileResponse.Builder::tablespaceAdminStatus).handleResponseHeaderString("opc-request-id", RemoveDataFileResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RemoveManagedDatabaseFromManagedDatabaseGroupResponse removeManagedDatabaseFromManagedDatabaseGroup(RemoveManagedDatabaseFromManagedDatabaseGroupRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseGroupId(), (String)"managedDatabaseGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveManagedDatabaseFromManagedDatabaseGroupDetails(), "removeManagedDatabaseFromManagedDatabaseGroupDetails is required");
        return (RemoveManagedDatabaseFromManagedDatabaseGroupResponse)this.clientCall(request, RemoveManagedDatabaseFromManagedDatabaseGroupResponse::builder).logger(LOG, "removeManagedDatabaseFromManagedDatabaseGroup").serviceDetails("DbManagement", "RemoveManagedDatabaseFromManagedDatabaseGroup", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabaseGroup/RemoveManagedDatabaseFromManagedDatabaseGroup").method(Method.POST).requestBuilder(RemoveManagedDatabaseFromManagedDatabaseGroupRequest::builder).basePath("/20201101").appendPathParam("managedDatabaseGroups").appendPathParam(request.getManagedDatabaseGroupId()).appendPathParam("actions").appendPathParam("removeManagedDatabase").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", RemoveManagedDatabaseFromManagedDatabaseGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ResetDatabaseParametersResponse resetDatabaseParameters(ResetDatabaseParametersRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getResetDatabaseParametersDetails(), "resetDatabaseParametersDetails is required");
        return (ResetDatabaseParametersResponse)this.clientCall(request, ResetDatabaseParametersResponse::builder).logger(LOG, "resetDatabaseParameters").serviceDetails("DbManagement", "ResetDatabaseParameters", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ResetDatabaseParameters").method(Method.POST).requestBuilder(ResetDatabaseParametersRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("actions").appendPathParam("resetDatabaseParameters").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(UpdateDatabaseParametersResult.class, ResetDatabaseParametersResponse.Builder::updateDatabaseParametersResult).handleResponseHeaderString("opc-request-id", ResetDatabaseParametersResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ResizeDataFileResponse resizeDataFile(ResizeDataFileRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTablespaceName(), (String)"tablespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getResizeDataFileDetails(), "resizeDataFileDetails is required");
        return (ResizeDataFileResponse)this.clientCall(request, ResizeDataFileResponse::builder).logger(LOG, "resizeDataFile").serviceDetails("DbManagement", "ResizeDataFile", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Tablespace/ResizeDataFile").method(Method.POST).requestBuilder(ResizeDataFileRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("tablespaces").appendPathParam(request.getTablespaceName()).appendPathParam("actions").appendPathParam("resizeDataFile").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TablespaceAdminStatus.class, ResizeDataFileResponse.Builder::tablespaceAdminStatus).handleResponseHeaderString("opc-request-id", ResizeDataFileResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RunHistoricAddmResponse runHistoricAddm(RunHistoricAddmRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRunHistoricAddmDetails(), "runHistoricAddmDetails is required");
        return (RunHistoricAddmResponse)this.clientCall(request, RunHistoricAddmResponse::builder).logger(LOG, "runHistoricAddm").serviceDetails("DbManagement", "RunHistoricAddm", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/HistoricAddmResult/RunHistoricAddm").method(Method.POST).requestBuilder(RunHistoricAddmRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("actions").appendPathParam("runHistoricAddm").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(HistoricAddmResult.class, RunHistoricAddmResponse.Builder::historicAddmResult).handleResponseHeaderString("opc-request-id", RunHistoricAddmResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public SummarizeAwrDbCpuUsagesResponse summarizeAwrDbCpuUsages(SummarizeAwrDbCpuUsagesRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        return (SummarizeAwrDbCpuUsagesResponse)this.clientCall(request, SummarizeAwrDbCpuUsagesResponse::builder).logger(LOG, "summarizeAwrDbCpuUsages").serviceDetails("DbManagement", "SummarizeAwrDbCpuUsages", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeAwrDbCpuUsages").method(Method.GET).requestBuilder(SummarizeAwrDbCpuUsagesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbCpuUsages").appendQueryParam("instNum", (Object)request.getInstNum()).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendEnumQueryParam("sessionType", (BmcEnum)request.getSessionType()).appendQueryParam("containerId", (Object)request.getContainerId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(AwrDbCpuUsageCollection.class, SummarizeAwrDbCpuUsagesResponse.Builder::awrDbCpuUsageCollection).handleResponseHeaderString("opc-request-id", SummarizeAwrDbCpuUsagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAwrDbCpuUsagesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeAwrDbMetricsResponse summarizeAwrDbMetrics(SummarizeAwrDbMetricsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getName(), "name is required");
        return (SummarizeAwrDbMetricsResponse)this.clientCall(request, SummarizeAwrDbMetricsResponse::builder).logger(LOG, "summarizeAwrDbMetrics").serviceDetails("DbManagement", "SummarizeAwrDbMetrics", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeAwrDbMetrics").method(Method.GET).requestBuilder(SummarizeAwrDbMetricsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbMetrics").appendQueryParam("instNum", (Object)request.getInstNum()).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendListQueryParam("name", request.getName(), CollectionFormatType.Multi).appendQueryParam("containerId", (Object)request.getContainerId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(AwrDbMetricCollection.class, SummarizeAwrDbMetricsResponse.Builder::awrDbMetricCollection).handleResponseHeaderString("opc-request-id", SummarizeAwrDbMetricsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAwrDbMetricsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeAwrDbParameterChangesResponse summarizeAwrDbParameterChanges(SummarizeAwrDbParameterChangesRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getName(), "name is required");
        return (SummarizeAwrDbParameterChangesResponse)this.clientCall(request, SummarizeAwrDbParameterChangesResponse::builder).logger(LOG, "summarizeAwrDbParameterChanges").serviceDetails("DbManagement", "SummarizeAwrDbParameterChanges", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeAwrDbParameterChanges").method(Method.GET).requestBuilder(SummarizeAwrDbParameterChangesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbParameterChanges").appendQueryParam("instNum", (Object)request.getInstNum()).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendQueryParam("containerId", (Object)request.getContainerId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(AwrDbParameterChangeCollection.class, SummarizeAwrDbParameterChangesResponse.Builder::awrDbParameterChangeCollection).handleResponseHeaderString("opc-request-id", SummarizeAwrDbParameterChangesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAwrDbParameterChangesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeAwrDbParametersResponse summarizeAwrDbParameters(SummarizeAwrDbParametersRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        return (SummarizeAwrDbParametersResponse)this.clientCall(request, SummarizeAwrDbParametersResponse::builder).logger(LOG, "summarizeAwrDbParameters").serviceDetails("DbManagement", "SummarizeAwrDbParameters", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeAwrDbParameters").method(Method.GET).requestBuilder(SummarizeAwrDbParametersRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbParameters").appendQueryParam("instNum", (Object)request.getInstNum()).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendQueryParam("containerId", (Object)request.getContainerId()).appendListQueryParam("name", request.getName(), CollectionFormatType.Multi).appendQueryParam("nameContains", (Object)request.getNameContains()).appendEnumQueryParam("valueChanged", (BmcEnum)request.getValueChanged()).appendEnumQueryParam("valueDefault", (BmcEnum)request.getValueDefault()).appendEnumQueryParam("valueModified", (BmcEnum)request.getValueModified()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(AwrDbParameterCollection.class, SummarizeAwrDbParametersResponse.Builder::awrDbParameterCollection).handleResponseHeaderString("opc-request-id", SummarizeAwrDbParametersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAwrDbParametersResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeAwrDbSnapshotRangesResponse summarizeAwrDbSnapshotRanges(SummarizeAwrDbSnapshotRangesRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (SummarizeAwrDbSnapshotRangesResponse)this.clientCall(request, SummarizeAwrDbSnapshotRangesResponse::builder).logger(LOG, "summarizeAwrDbSnapshotRanges").serviceDetails("DbManagement", "SummarizeAwrDbSnapshotRanges", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeAwrDbSnapshotRanges").method(Method.GET).requestBuilder(SummarizeAwrDbSnapshotRangesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbSnapshotRanges").appendQueryParam("name", (Object)request.getName()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(AwrDbSnapshotRangeCollection.class, SummarizeAwrDbSnapshotRangesResponse.Builder::awrDbSnapshotRangeCollection).handleResponseHeaderString("opc-request-id", SummarizeAwrDbSnapshotRangesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAwrDbSnapshotRangesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeAwrDbSysstatsResponse summarizeAwrDbSysstats(SummarizeAwrDbSysstatsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getName(), "name is required");
        return (SummarizeAwrDbSysstatsResponse)this.clientCall(request, SummarizeAwrDbSysstatsResponse::builder).logger(LOG, "summarizeAwrDbSysstats").serviceDetails("DbManagement", "SummarizeAwrDbSysstats", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeAwrDbSysstats").method(Method.GET).requestBuilder(SummarizeAwrDbSysstatsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbSysstats").appendQueryParam("instNum", (Object)request.getInstNum()).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendListQueryParam("name", request.getName(), CollectionFormatType.Multi).appendQueryParam("containerId", (Object)request.getContainerId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(AwrDbSysstatCollection.class, SummarizeAwrDbSysstatsResponse.Builder::awrDbSysstatCollection).handleResponseHeaderString("opc-request-id", SummarizeAwrDbSysstatsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAwrDbSysstatsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeAwrDbTopWaitEventsResponse summarizeAwrDbTopWaitEvents(SummarizeAwrDbTopWaitEventsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        return (SummarizeAwrDbTopWaitEventsResponse)this.clientCall(request, SummarizeAwrDbTopWaitEventsResponse::builder).logger(LOG, "summarizeAwrDbTopWaitEvents").serviceDetails("DbManagement", "SummarizeAwrDbTopWaitEvents", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeAwrDbTopWaitEvents").method(Method.GET).requestBuilder(SummarizeAwrDbTopWaitEventsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbTopWaitEvents").appendQueryParam("instNum", (Object)request.getInstNum()).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendEnumQueryParam("sessionType", (BmcEnum)request.getSessionType()).appendQueryParam("containerId", (Object)request.getContainerId()).appendQueryParam("topN", (Object)request.getTopN()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(AwrDbTopWaitEventCollection.class, SummarizeAwrDbTopWaitEventsResponse.Builder::awrDbTopWaitEventCollection).handleResponseHeaderString("opc-request-id", SummarizeAwrDbTopWaitEventsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAwrDbTopWaitEventsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeAwrDbWaitEventBucketsResponse summarizeAwrDbWaitEventBuckets(SummarizeAwrDbWaitEventBucketsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getName(), "name is required");
        return (SummarizeAwrDbWaitEventBucketsResponse)this.clientCall(request, SummarizeAwrDbWaitEventBucketsResponse::builder).logger(LOG, "summarizeAwrDbWaitEventBuckets").serviceDetails("DbManagement", "SummarizeAwrDbWaitEventBuckets", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeAwrDbWaitEventBuckets").method(Method.GET).requestBuilder(SummarizeAwrDbWaitEventBucketsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbWaitEventBuckets").appendQueryParam("instNum", (Object)request.getInstNum()).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("numBucket", (Object)request.getNumBucket()).appendQueryParam("minValue", (Object)request.getMinValue()).appendQueryParam("maxValue", (Object)request.getMaxValue()).appendQueryParam("containerId", (Object)request.getContainerId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(AwrDbWaitEventBucketCollection.class, SummarizeAwrDbWaitEventBucketsResponse.Builder::awrDbWaitEventBucketCollection).handleResponseHeaderString("opc-request-id", SummarizeAwrDbWaitEventBucketsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAwrDbWaitEventBucketsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeAwrDbWaitEventsResponse summarizeAwrDbWaitEvents(SummarizeAwrDbWaitEventsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        return (SummarizeAwrDbWaitEventsResponse)this.clientCall(request, SummarizeAwrDbWaitEventsResponse::builder).logger(LOG, "summarizeAwrDbWaitEvents").serviceDetails("DbManagement", "SummarizeAwrDbWaitEvents", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeAwrDbWaitEvents").method(Method.GET).requestBuilder(SummarizeAwrDbWaitEventsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbWaitEvents").appendQueryParam("instNum", (Object)request.getInstNum()).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendListQueryParam("name", request.getName(), CollectionFormatType.Multi).appendEnumQueryParam("sessionType", (BmcEnum)request.getSessionType()).appendQueryParam("containerId", (Object)request.getContainerId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(AwrDbWaitEventCollection.class, SummarizeAwrDbWaitEventsResponse.Builder::awrDbWaitEventCollection).handleResponseHeaderString("opc-request-id", SummarizeAwrDbWaitEventsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAwrDbWaitEventsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeJobExecutionsStatusesResponse summarizeJobExecutionsStatuses(SummarizeJobExecutionsStatusesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getStartTime(), "startTime is required");
        Objects.requireNonNull(request.getEndTime(), "endTime is required");
        return (SummarizeJobExecutionsStatusesResponse)this.clientCall(request, SummarizeJobExecutionsStatusesResponse::builder).logger(LOG, "summarizeJobExecutionsStatuses").serviceDetails("DbManagement", "SummarizeJobExecutionsStatuses", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/JobExecutionsStatusSummaryCollection/SummarizeJobExecutionsStatuses").method(Method.GET).requestBuilder(SummarizeJobExecutionsStatusesRequest::builder).basePath("/20201101").appendPathParam("jobExecutionsStatus").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("managedDatabaseGroupId", (Object)request.getManagedDatabaseGroupId()).appendQueryParam("managedDatabaseId", (Object)request.getManagedDatabaseId()).appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobExecutionsStatusSummaryCollection.class, SummarizeJobExecutionsStatusesResponse.Builder::jobExecutionsStatusSummaryCollection).handleResponseHeaderString("opc-request-id", SummarizeJobExecutionsStatusesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public TestPreferredCredentialResponse testPreferredCredential(TestPreferredCredentialRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCredentialName(), (String)"credentialName must not be blank", (Object[])new Object[0]);
        return (TestPreferredCredentialResponse)this.clientCall(request, TestPreferredCredentialResponse::builder).logger(LOG, "testPreferredCredential").serviceDetails("DbManagement", "TestPreferredCredential", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/PreferredCredential/TestPreferredCredential").method(Method.POST).requestBuilder(TestPreferredCredentialRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("preferredCredentials").appendPathParam(request.getCredentialName()).appendPathParam("actions").appendPathParam("test").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TestPreferredCredentialStatus.class, TestPreferredCredentialResponse.Builder::testPreferredCredentialStatus).handleResponseHeaderString("opc-request-id", TestPreferredCredentialResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDbManagementPrivateEndpointResponse updateDbManagementPrivateEndpoint(UpdateDbManagementPrivateEndpointRequest request) {
        Validate.notBlank((String)request.getDbManagementPrivateEndpointId(), (String)"dbManagementPrivateEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDbManagementPrivateEndpointDetails(), "updateDbManagementPrivateEndpointDetails is required");
        return (UpdateDbManagementPrivateEndpointResponse)this.clientCall(request, UpdateDbManagementPrivateEndpointResponse::builder).logger(LOG, "updateDbManagementPrivateEndpoint").serviceDetails("DbManagement", "UpdateDbManagementPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/DbManagementPrivateEndpoint/UpdateDbManagementPrivateEndpoint").method(Method.PUT).requestBuilder(UpdateDbManagementPrivateEndpointRequest::builder).basePath("/20201101").appendPathParam("dbManagementPrivateEndpoints").appendPathParam(request.getDbManagementPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(DbManagementPrivateEndpoint.class, UpdateDbManagementPrivateEndpointResponse.Builder::dbManagementPrivateEndpoint).handleResponseHeaderString("opc-request-id", UpdateDbManagementPrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateDbManagementPrivateEndpointResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateJobResponse updateJob(UpdateJobRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateJobDetails(), "updateJobDetails is required");
        return (UpdateJobResponse)this.clientCall(request, UpdateJobResponse::builder).logger(LOG, "updateJob").serviceDetails("DbManagement", "UpdateJob", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Job/UpdateJob").method(Method.PUT).requestBuilder(UpdateJobRequest::builder).basePath("/20201101").appendPathParam("jobs").appendPathParam(request.getJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Job.class, UpdateJobResponse.Builder::job).handleResponseHeaderString("opc-request-id", UpdateJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateJobResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateManagedDatabaseGroupResponse updateManagedDatabaseGroup(UpdateManagedDatabaseGroupRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseGroupId(), (String)"managedDatabaseGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateManagedDatabaseGroupDetails(), "updateManagedDatabaseGroupDetails is required");
        return (UpdateManagedDatabaseGroupResponse)this.clientCall(request, UpdateManagedDatabaseGroupResponse::builder).logger(LOG, "updateManagedDatabaseGroup").serviceDetails("DbManagement", "UpdateManagedDatabaseGroup", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabaseGroup/UpdateManagedDatabaseGroup").method(Method.PUT).requestBuilder(UpdateManagedDatabaseGroupRequest::builder).basePath("/20201101").appendPathParam("managedDatabaseGroups").appendPathParam(request.getManagedDatabaseGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ManagedDatabaseGroup.class, UpdateManagedDatabaseGroupResponse.Builder::managedDatabaseGroup).handleResponseHeaderString("opc-request-id", UpdateManagedDatabaseGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateManagedDatabaseGroupResponse.Builder::etag).callSync();
    }

    @Override
    public UpdatePreferredCredentialResponse updatePreferredCredential(UpdatePreferredCredentialRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCredentialName(), (String)"credentialName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePreferredCredentialDetails(), "updatePreferredCredentialDetails is required");
        return (UpdatePreferredCredentialResponse)this.clientCall(request, UpdatePreferredCredentialResponse::builder).logger(LOG, "updatePreferredCredential").serviceDetails("DbManagement", "UpdatePreferredCredential", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/PreferredCredential/UpdatePreferredCredential").method(Method.PUT).requestBuilder(UpdatePreferredCredentialRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("preferredCredentials").appendPathParam(request.getCredentialName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(PreferredCredential.class, UpdatePreferredCredentialResponse.Builder::preferredCredential).handleResponseHeaderString("opc-request-id", UpdatePreferredCredentialResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdatePreferredCredentialResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateTablespaceResponse updateTablespace(UpdateTablespaceRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTablespaceName(), (String)"tablespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTablespaceDetails(), "updateTablespaceDetails is required");
        return (UpdateTablespaceResponse)this.clientCall(request, UpdateTablespaceResponse::builder).logger(LOG, "updateTablespace").serviceDetails("DbManagement", "UpdateTablespace", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Tablespace/UpdateTablespace").method(Method.PUT).requestBuilder(UpdateTablespaceRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("tablespaces").appendPathParam(request.getTablespaceName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Tablespace.class, UpdateTablespaceResponse.Builder::tablespace).handleResponseHeaderString("opc-request-id", UpdateTablespaceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DbManagementWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DbManagementPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DbManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DbManagementClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DbManagementClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DbManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DbManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DbManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DbManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DbManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DbManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DbManagementClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DbManagementClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DbManagementClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

