/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.ScanDetails;
import com.oracle.bmc.database.model.VmNetworkDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VmClusterNetwork
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="exadataInfrastructureId")
    private final String exadataInfrastructureId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="vmClusterId")
    private final String vmClusterId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="scans")
    private final List<ScanDetails> scans;
    @JsonProperty(value="dns")
    private final List<String> dns;
    @JsonProperty(value="ntp")
    private final List<String> ntp;
    @JsonProperty(value="vmNetworks")
    private final List<VmNetworkDetails> vmNetworks;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"id", "exadataInfrastructureId", "compartmentId", "vmClusterId", "displayName", "scans", "dns", "ntp", "vmNetworks", "lifecycleState", "timeCreated", "lifecycleDetails", "freeformTags", "definedTags"})
    public VmClusterNetwork(String id, String exadataInfrastructureId, String compartmentId, String vmClusterId, String displayName, List<ScanDetails> scans, List<String> dns, List<String> ntp, List<VmNetworkDetails> vmNetworks, LifecycleState lifecycleState, Date timeCreated, String lifecycleDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.exadataInfrastructureId = exadataInfrastructureId;
        this.compartmentId = compartmentId;
        this.vmClusterId = vmClusterId;
        this.displayName = displayName;
        this.scans = scans;
        this.dns = dns;
        this.ntp = ntp;
        this.vmNetworks = vmNetworks;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.lifecycleDetails = lifecycleDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getExadataInfrastructureId() {
        return this.exadataInfrastructureId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getVmClusterId() {
        return this.vmClusterId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<ScanDetails> getScans() {
        return this.scans;
    }

    public List<String> getDns() {
        return this.dns;
    }

    public List<String> getNtp() {
        return this.ntp;
    }

    public List<VmNetworkDetails> getVmNetworks() {
        return this.vmNetworks;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VmClusterNetwork(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", exadataInfrastructureId=").append(String.valueOf(this.exadataInfrastructureId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", vmClusterId=").append(String.valueOf(this.vmClusterId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", scans=").append(String.valueOf(this.scans));
        sb.append(", dns=").append(String.valueOf(this.dns));
        sb.append(", ntp=").append(String.valueOf(this.ntp));
        sb.append(", vmNetworks=").append(String.valueOf(this.vmNetworks));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VmClusterNetwork)) {
            return false;
        }
        VmClusterNetwork other = (VmClusterNetwork)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.exadataInfrastructureId, other.exadataInfrastructureId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.vmClusterId, other.vmClusterId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.scans, other.scans) && Objects.equals(this.dns, other.dns) && Objects.equals(this.ntp, other.ntp) && Objects.equals(this.vmNetworks, other.vmNetworks) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.exadataInfrastructureId == null ? 43 : this.exadataInfrastructureId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.vmClusterId == null ? 43 : this.vmClusterId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.scans == null ? 43 : this.scans.hashCode());
        result = result * 59 + (this.dns == null ? 43 : this.dns.hashCode());
        result = result * 59 + (this.ntp == null ? 43 : this.ntp.hashCode());
        result = result * 59 + (this.vmNetworks == null ? 43 : this.vmNetworks.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        RequiresValidation("REQUIRES_VALIDATION"),
        Validating("VALIDATING"),
        Validated("VALIDATED"),
        ValidationFailed("VALIDATION_FAILED"),
        Updating("UPDATING"),
        Allocated("ALLOCATED"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Failed("FAILED"),
        NeedsAttention("NEEDS_ATTENTION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="exadataInfrastructureId")
        private String exadataInfrastructureId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="vmClusterId")
        private String vmClusterId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="scans")
        private List<ScanDetails> scans;
        @JsonProperty(value="dns")
        private List<String> dns;
        @JsonProperty(value="ntp")
        private List<String> ntp;
        @JsonProperty(value="vmNetworks")
        private List<VmNetworkDetails> vmNetworks;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder exadataInfrastructureId(String exadataInfrastructureId) {
            this.exadataInfrastructureId = exadataInfrastructureId;
            this.__explicitlySet__.add("exadataInfrastructureId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder vmClusterId(String vmClusterId) {
            this.vmClusterId = vmClusterId;
            this.__explicitlySet__.add("vmClusterId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder scans(List<ScanDetails> scans) {
            this.scans = scans;
            this.__explicitlySet__.add("scans");
            return this;
        }

        public Builder dns(List<String> dns) {
            this.dns = dns;
            this.__explicitlySet__.add("dns");
            return this;
        }

        public Builder ntp(List<String> ntp) {
            this.ntp = ntp;
            this.__explicitlySet__.add("ntp");
            return this;
        }

        public Builder vmNetworks(List<VmNetworkDetails> vmNetworks) {
            this.vmNetworks = vmNetworks;
            this.__explicitlySet__.add("vmNetworks");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public VmClusterNetwork build() {
            VmClusterNetwork model = new VmClusterNetwork(this.id, this.exadataInfrastructureId, this.compartmentId, this.vmClusterId, this.displayName, this.scans, this.dns, this.ntp, this.vmNetworks, this.lifecycleState, this.timeCreated, this.lifecycleDetails, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VmClusterNetwork model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("exadataInfrastructureId")) {
                this.exadataInfrastructureId(model.getExadataInfrastructureId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("vmClusterId")) {
                this.vmClusterId(model.getVmClusterId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("scans")) {
                this.scans(model.getScans());
            }
            if (model.wasPropertyExplicitlySet("dns")) {
                this.dns(model.getDns());
            }
            if (model.wasPropertyExplicitlySet("ntp")) {
                this.ntp(model.getNtp());
            }
            if (model.wasPropertyExplicitlySet("vmNetworks")) {
                this.vmNetworks(model.getVmNetworks());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

