/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InfoForNetworkGenDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="networkType")
    private final NetworkType networkType;
    @JsonProperty(value="vlanId")
    private final String vlanId;
    @JsonProperty(value="cidr")
    private final String cidr;
    @JsonProperty(value="gateway")
    private final String gateway;
    @JsonProperty(value="netmask")
    private final String netmask;
    @JsonProperty(value="domain")
    private final String domain;
    @JsonProperty(value="prefix")
    private final String prefix;

    @Deprecated
    @ConstructorProperties(value={"networkType", "vlanId", "cidr", "gateway", "netmask", "domain", "prefix"})
    public InfoForNetworkGenDetails(NetworkType networkType, String vlanId, String cidr, String gateway, String netmask, String domain, String prefix) {
        this.networkType = networkType;
        this.vlanId = vlanId;
        this.cidr = cidr;
        this.gateway = gateway;
        this.netmask = netmask;
        this.domain = domain;
        this.prefix = prefix;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public String getVlanId() {
        return this.vlanId;
    }

    public String getCidr() {
        return this.cidr;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InfoForNetworkGenDetails(");
        sb.append("super=").append(super.toString());
        sb.append("networkType=").append(String.valueOf((Object)this.networkType));
        sb.append(", vlanId=").append(String.valueOf(this.vlanId));
        sb.append(", cidr=").append(String.valueOf(this.cidr));
        sb.append(", gateway=").append(String.valueOf(this.gateway));
        sb.append(", netmask=").append(String.valueOf(this.netmask));
        sb.append(", domain=").append(String.valueOf(this.domain));
        sb.append(", prefix=").append(String.valueOf(this.prefix));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InfoForNetworkGenDetails)) {
            return false;
        }
        InfoForNetworkGenDetails other = (InfoForNetworkGenDetails)((Object)o);
        return Objects.equals((Object)this.networkType, (Object)other.networkType) && Objects.equals(this.vlanId, other.vlanId) && Objects.equals(this.cidr, other.cidr) && Objects.equals(this.gateway, other.gateway) && Objects.equals(this.netmask, other.netmask) && Objects.equals(this.domain, other.domain) && Objects.equals(this.prefix, other.prefix) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.networkType == null ? 43 : this.networkType.hashCode());
        result = result * 59 + (this.vlanId == null ? 43 : this.vlanId.hashCode());
        result = result * 59 + (this.cidr == null ? 43 : this.cidr.hashCode());
        result = result * 59 + (this.gateway == null ? 43 : this.gateway.hashCode());
        result = result * 59 + (this.netmask == null ? 43 : this.netmask.hashCode());
        result = result * 59 + (this.domain == null ? 43 : this.domain.hashCode());
        result = result * 59 + (this.prefix == null ? 43 : this.prefix.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum NetworkType implements BmcEnum
    {
        Client("CLIENT"),
        Backup("BACKUP");

        private final String value;
        private static Map<String, NetworkType> map;

        private NetworkType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static NetworkType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid NetworkType: " + key);
        }

        static {
            map = new HashMap<String, NetworkType>();
            for (NetworkType v : NetworkType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="networkType")
        private NetworkType networkType;
        @JsonProperty(value="vlanId")
        private String vlanId;
        @JsonProperty(value="cidr")
        private String cidr;
        @JsonProperty(value="gateway")
        private String gateway;
        @JsonProperty(value="netmask")
        private String netmask;
        @JsonProperty(value="domain")
        private String domain;
        @JsonProperty(value="prefix")
        private String prefix;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder networkType(NetworkType networkType) {
            this.networkType = networkType;
            this.__explicitlySet__.add("networkType");
            return this;
        }

        public Builder vlanId(String vlanId) {
            this.vlanId = vlanId;
            this.__explicitlySet__.add("vlanId");
            return this;
        }

        public Builder cidr(String cidr) {
            this.cidr = cidr;
            this.__explicitlySet__.add("cidr");
            return this;
        }

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            this.__explicitlySet__.add("gateway");
            return this;
        }

        public Builder netmask(String netmask) {
            this.netmask = netmask;
            this.__explicitlySet__.add("netmask");
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            this.__explicitlySet__.add("domain");
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            this.__explicitlySet__.add("prefix");
            return this;
        }

        public InfoForNetworkGenDetails build() {
            InfoForNetworkGenDetails model = new InfoForNetworkGenDetails(this.networkType, this.vlanId, this.cidr, this.gateway, this.netmask, this.domain, this.prefix);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InfoForNetworkGenDetails model) {
            if (model.wasPropertyExplicitlySet("networkType")) {
                this.networkType(model.getNetworkType());
            }
            if (model.wasPropertyExplicitlySet("vlanId")) {
                this.vlanId(model.getVlanId());
            }
            if (model.wasPropertyExplicitlySet("cidr")) {
                this.cidr(model.getCidr());
            }
            if (model.wasPropertyExplicitlySet("gateway")) {
                this.gateway(model.getGateway());
            }
            if (model.wasPropertyExplicitlySet("netmask")) {
                this.netmask(model.getNetmask());
            }
            if (model.wasPropertyExplicitlySet("domain")) {
                this.domain(model.getDomain());
            }
            if (model.wasPropertyExplicitlySet("prefix")) {
                this.prefix(model.getPrefix());
            }
            return this;
        }
    }
}

