/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.StoragePerformanceDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbSystemStoragePerformanceSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="shapeType")
    private final ShapeType shapeType;
    @JsonProperty(value="dataStoragePerformanceList")
    private final List<StoragePerformanceDetails> dataStoragePerformanceList;
    @JsonProperty(value="recoStoragePerformanceList")
    private final List<StoragePerformanceDetails> recoStoragePerformanceList;

    @Deprecated
    @ConstructorProperties(value={"shapeType", "dataStoragePerformanceList", "recoStoragePerformanceList"})
    public DbSystemStoragePerformanceSummary(ShapeType shapeType, List<StoragePerformanceDetails> dataStoragePerformanceList, List<StoragePerformanceDetails> recoStoragePerformanceList) {
        this.shapeType = shapeType;
        this.dataStoragePerformanceList = dataStoragePerformanceList;
        this.recoStoragePerformanceList = recoStoragePerformanceList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    public List<StoragePerformanceDetails> getDataStoragePerformanceList() {
        return this.dataStoragePerformanceList;
    }

    public List<StoragePerformanceDetails> getRecoStoragePerformanceList() {
        return this.recoStoragePerformanceList;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbSystemStoragePerformanceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("shapeType=").append(String.valueOf((Object)this.shapeType));
        sb.append(", dataStoragePerformanceList=").append(String.valueOf(this.dataStoragePerformanceList));
        sb.append(", recoStoragePerformanceList=").append(String.valueOf(this.recoStoragePerformanceList));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbSystemStoragePerformanceSummary)) {
            return false;
        }
        DbSystemStoragePerformanceSummary other = (DbSystemStoragePerformanceSummary)((Object)o);
        return Objects.equals((Object)this.shapeType, (Object)other.shapeType) && Objects.equals(this.dataStoragePerformanceList, other.dataStoragePerformanceList) && Objects.equals(this.recoStoragePerformanceList, other.recoStoragePerformanceList) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.shapeType == null ? 43 : this.shapeType.hashCode());
        result = result * 59 + (this.dataStoragePerformanceList == null ? 43 : this.dataStoragePerformanceList.hashCode());
        result = result * 59 + (this.recoStoragePerformanceList == null ? 43 : this.recoStoragePerformanceList.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ShapeType implements BmcEnum
    {
        Amd("AMD"),
        Intel("INTEL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ShapeType> map;

        private ShapeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ShapeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ShapeType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ShapeType.class);
            map = new HashMap<String, ShapeType>();
            for (ShapeType v : ShapeType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="shapeType")
        private ShapeType shapeType;
        @JsonProperty(value="dataStoragePerformanceList")
        private List<StoragePerformanceDetails> dataStoragePerformanceList;
        @JsonProperty(value="recoStoragePerformanceList")
        private List<StoragePerformanceDetails> recoStoragePerformanceList;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder shapeType(ShapeType shapeType) {
            this.shapeType = shapeType;
            this.__explicitlySet__.add("shapeType");
            return this;
        }

        public Builder dataStoragePerformanceList(List<StoragePerformanceDetails> dataStoragePerformanceList) {
            this.dataStoragePerformanceList = dataStoragePerformanceList;
            this.__explicitlySet__.add("dataStoragePerformanceList");
            return this;
        }

        public Builder recoStoragePerformanceList(List<StoragePerformanceDetails> recoStoragePerformanceList) {
            this.recoStoragePerformanceList = recoStoragePerformanceList;
            this.__explicitlySet__.add("recoStoragePerformanceList");
            return this;
        }

        public DbSystemStoragePerformanceSummary build() {
            DbSystemStoragePerformanceSummary model = new DbSystemStoragePerformanceSummary(this.shapeType, this.dataStoragePerformanceList, this.recoStoragePerformanceList);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbSystemStoragePerformanceSummary model) {
            if (model.wasPropertyExplicitlySet("shapeType")) {
                this.shapeType(model.getShapeType());
            }
            if (model.wasPropertyExplicitlySet("dataStoragePerformanceList")) {
                this.dataStoragePerformanceList(model.getDataStoragePerformanceList());
            }
            if (model.wasPropertyExplicitlySet("recoStoragePerformanceList")) {
                this.recoStoragePerformanceList(model.getRecoStoragePerformanceList());
            }
            return this;
        }
    }
}

