/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.BackupDestinationDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbBackupConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="autoBackupEnabled")
    private final Boolean autoBackupEnabled;
    @JsonProperty(value="recoveryWindowInDays")
    private final Integer recoveryWindowInDays;
    @JsonProperty(value="autoBackupWindow")
    private final AutoBackupWindow autoBackupWindow;
    @JsonProperty(value="backupDestinationDetails")
    private final List<BackupDestinationDetails> backupDestinationDetails;

    @Deprecated
    @ConstructorProperties(value={"autoBackupEnabled", "recoveryWindowInDays", "autoBackupWindow", "backupDestinationDetails"})
    public DbBackupConfig(Boolean autoBackupEnabled, Integer recoveryWindowInDays, AutoBackupWindow autoBackupWindow, List<BackupDestinationDetails> backupDestinationDetails) {
        this.autoBackupEnabled = autoBackupEnabled;
        this.recoveryWindowInDays = recoveryWindowInDays;
        this.autoBackupWindow = autoBackupWindow;
        this.backupDestinationDetails = backupDestinationDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Boolean getAutoBackupEnabled() {
        return this.autoBackupEnabled;
    }

    public Integer getRecoveryWindowInDays() {
        return this.recoveryWindowInDays;
    }

    public AutoBackupWindow getAutoBackupWindow() {
        return this.autoBackupWindow;
    }

    public List<BackupDestinationDetails> getBackupDestinationDetails() {
        return this.backupDestinationDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbBackupConfig(");
        sb.append("super=").append(super.toString());
        sb.append("autoBackupEnabled=").append(String.valueOf(this.autoBackupEnabled));
        sb.append(", recoveryWindowInDays=").append(String.valueOf(this.recoveryWindowInDays));
        sb.append(", autoBackupWindow=").append(String.valueOf((Object)this.autoBackupWindow));
        sb.append(", backupDestinationDetails=").append(String.valueOf(this.backupDestinationDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbBackupConfig)) {
            return false;
        }
        DbBackupConfig other = (DbBackupConfig)((Object)o);
        return Objects.equals(this.autoBackupEnabled, other.autoBackupEnabled) && Objects.equals(this.recoveryWindowInDays, other.recoveryWindowInDays) && Objects.equals((Object)this.autoBackupWindow, (Object)other.autoBackupWindow) && Objects.equals(this.backupDestinationDetails, other.backupDestinationDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.autoBackupEnabled == null ? 43 : this.autoBackupEnabled.hashCode());
        result = result * 59 + (this.recoveryWindowInDays == null ? 43 : this.recoveryWindowInDays.hashCode());
        result = result * 59 + (this.autoBackupWindow == null ? 43 : this.autoBackupWindow.hashCode());
        result = result * 59 + (this.backupDestinationDetails == null ? 43 : this.backupDestinationDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AutoBackupWindow implements BmcEnum
    {
        SlotOne("SLOT_ONE"),
        SlotTwo("SLOT_TWO"),
        SlotThree("SLOT_THREE"),
        SlotFour("SLOT_FOUR"),
        SlotFive("SLOT_FIVE"),
        SlotSix("SLOT_SIX"),
        SlotSeven("SLOT_SEVEN"),
        SlotEight("SLOT_EIGHT"),
        SlotNine("SLOT_NINE"),
        SlotTen("SLOT_TEN"),
        SlotEleven("SLOT_ELEVEN"),
        SlotTwelve("SLOT_TWELVE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AutoBackupWindow> map;

        private AutoBackupWindow(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AutoBackupWindow create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AutoBackupWindow', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AutoBackupWindow.class);
            map = new HashMap<String, AutoBackupWindow>();
            for (AutoBackupWindow v : AutoBackupWindow.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="autoBackupEnabled")
        private Boolean autoBackupEnabled;
        @JsonProperty(value="recoveryWindowInDays")
        private Integer recoveryWindowInDays;
        @JsonProperty(value="autoBackupWindow")
        private AutoBackupWindow autoBackupWindow;
        @JsonProperty(value="backupDestinationDetails")
        private List<BackupDestinationDetails> backupDestinationDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder autoBackupEnabled(Boolean autoBackupEnabled) {
            this.autoBackupEnabled = autoBackupEnabled;
            this.__explicitlySet__.add("autoBackupEnabled");
            return this;
        }

        public Builder recoveryWindowInDays(Integer recoveryWindowInDays) {
            this.recoveryWindowInDays = recoveryWindowInDays;
            this.__explicitlySet__.add("recoveryWindowInDays");
            return this;
        }

        public Builder autoBackupWindow(AutoBackupWindow autoBackupWindow) {
            this.autoBackupWindow = autoBackupWindow;
            this.__explicitlySet__.add("autoBackupWindow");
            return this;
        }

        public Builder backupDestinationDetails(List<BackupDestinationDetails> backupDestinationDetails) {
            this.backupDestinationDetails = backupDestinationDetails;
            this.__explicitlySet__.add("backupDestinationDetails");
            return this;
        }

        public DbBackupConfig build() {
            DbBackupConfig model = new DbBackupConfig(this.autoBackupEnabled, this.recoveryWindowInDays, this.autoBackupWindow, this.backupDestinationDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbBackupConfig model) {
            if (model.wasPropertyExplicitlySet("autoBackupEnabled")) {
                this.autoBackupEnabled(model.getAutoBackupEnabled());
            }
            if (model.wasPropertyExplicitlySet("recoveryWindowInDays")) {
                this.recoveryWindowInDays(model.getRecoveryWindowInDays());
            }
            if (model.wasPropertyExplicitlySet("autoBackupWindow")) {
                this.autoBackupWindow(model.getAutoBackupWindow());
            }
            if (model.wasPropertyExplicitlySet("backupDestinationDetails")) {
                this.backupDestinationDetails(model.getBackupDestinationDetails());
            }
            return this;
        }
    }
}

