/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutonomousDatabaseDataguardAssociation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="autonomousDatabaseId")
    private final String autonomousDatabaseId;
    @JsonProperty(value="role")
    private final Role role;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="peerRole")
    private final PeerRole peerRole;
    @JsonProperty(value="peerAutonomousDatabaseId")
    private final String peerAutonomousDatabaseId;
    @JsonProperty(value="peerAutonomousDatabaseLifeCycleState")
    private final PeerAutonomousDatabaseLifeCycleState peerAutonomousDatabaseLifeCycleState;
    @JsonProperty(value="protectionMode")
    private final ProtectionMode protectionMode;
    @JsonProperty(value="applyLag")
    private final String applyLag;
    @JsonProperty(value="applyRate")
    private final String applyRate;
    @JsonProperty(value="isAutomaticFailoverEnabled")
    private final Boolean isAutomaticFailoverEnabled;
    @JsonProperty(value="transportLag")
    private final String transportLag;
    @JsonProperty(value="timeLastSynced")
    private final Date timeLastSynced;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeLastRoleChanged")
    private final Date timeLastRoleChanged;

    @Deprecated
    @ConstructorProperties(value={"id", "autonomousDatabaseId", "role", "lifecycleState", "lifecycleDetails", "peerRole", "peerAutonomousDatabaseId", "peerAutonomousDatabaseLifeCycleState", "protectionMode", "applyLag", "applyRate", "isAutomaticFailoverEnabled", "transportLag", "timeLastSynced", "timeCreated", "timeLastRoleChanged"})
    public AutonomousDatabaseDataguardAssociation(String id, String autonomousDatabaseId, Role role, LifecycleState lifecycleState, String lifecycleDetails, PeerRole peerRole, String peerAutonomousDatabaseId, PeerAutonomousDatabaseLifeCycleState peerAutonomousDatabaseLifeCycleState, ProtectionMode protectionMode, String applyLag, String applyRate, Boolean isAutomaticFailoverEnabled, String transportLag, Date timeLastSynced, Date timeCreated, Date timeLastRoleChanged) {
        this.id = id;
        this.autonomousDatabaseId = autonomousDatabaseId;
        this.role = role;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.peerRole = peerRole;
        this.peerAutonomousDatabaseId = peerAutonomousDatabaseId;
        this.peerAutonomousDatabaseLifeCycleState = peerAutonomousDatabaseLifeCycleState;
        this.protectionMode = protectionMode;
        this.applyLag = applyLag;
        this.applyRate = applyRate;
        this.isAutomaticFailoverEnabled = isAutomaticFailoverEnabled;
        this.transportLag = transportLag;
        this.timeLastSynced = timeLastSynced;
        this.timeCreated = timeCreated;
        this.timeLastRoleChanged = timeLastRoleChanged;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getAutonomousDatabaseId() {
        return this.autonomousDatabaseId;
    }

    public Role getRole() {
        return this.role;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public PeerRole getPeerRole() {
        return this.peerRole;
    }

    public String getPeerAutonomousDatabaseId() {
        return this.peerAutonomousDatabaseId;
    }

    public PeerAutonomousDatabaseLifeCycleState getPeerAutonomousDatabaseLifeCycleState() {
        return this.peerAutonomousDatabaseLifeCycleState;
    }

    public ProtectionMode getProtectionMode() {
        return this.protectionMode;
    }

    public String getApplyLag() {
        return this.applyLag;
    }

    public String getApplyRate() {
        return this.applyRate;
    }

    public Boolean getIsAutomaticFailoverEnabled() {
        return this.isAutomaticFailoverEnabled;
    }

    public String getTransportLag() {
        return this.transportLag;
    }

    public Date getTimeLastSynced() {
        return this.timeLastSynced;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeLastRoleChanged() {
        return this.timeLastRoleChanged;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutonomousDatabaseDataguardAssociation(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", autonomousDatabaseId=").append(String.valueOf(this.autonomousDatabaseId));
        sb.append(", role=").append(String.valueOf((Object)this.role));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", peerRole=").append(String.valueOf((Object)this.peerRole));
        sb.append(", peerAutonomousDatabaseId=").append(String.valueOf(this.peerAutonomousDatabaseId));
        sb.append(", peerAutonomousDatabaseLifeCycleState=").append(String.valueOf((Object)this.peerAutonomousDatabaseLifeCycleState));
        sb.append(", protectionMode=").append(String.valueOf((Object)this.protectionMode));
        sb.append(", applyLag=").append(String.valueOf(this.applyLag));
        sb.append(", applyRate=").append(String.valueOf(this.applyRate));
        sb.append(", isAutomaticFailoverEnabled=").append(String.valueOf(this.isAutomaticFailoverEnabled));
        sb.append(", transportLag=").append(String.valueOf(this.transportLag));
        sb.append(", timeLastSynced=").append(String.valueOf(this.timeLastSynced));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeLastRoleChanged=").append(String.valueOf(this.timeLastRoleChanged));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutonomousDatabaseDataguardAssociation)) {
            return false;
        }
        AutonomousDatabaseDataguardAssociation other = (AutonomousDatabaseDataguardAssociation)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.autonomousDatabaseId, other.autonomousDatabaseId) && Objects.equals((Object)this.role, (Object)other.role) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals((Object)this.peerRole, (Object)other.peerRole) && Objects.equals(this.peerAutonomousDatabaseId, other.peerAutonomousDatabaseId) && Objects.equals((Object)this.peerAutonomousDatabaseLifeCycleState, (Object)other.peerAutonomousDatabaseLifeCycleState) && Objects.equals((Object)this.protectionMode, (Object)other.protectionMode) && Objects.equals(this.applyLag, other.applyLag) && Objects.equals(this.applyRate, other.applyRate) && Objects.equals(this.isAutomaticFailoverEnabled, other.isAutomaticFailoverEnabled) && Objects.equals(this.transportLag, other.transportLag) && Objects.equals(this.timeLastSynced, other.timeLastSynced) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeLastRoleChanged, other.timeLastRoleChanged) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.autonomousDatabaseId == null ? 43 : this.autonomousDatabaseId.hashCode());
        result = result * 59 + (this.role == null ? 43 : this.role.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.peerRole == null ? 43 : this.peerRole.hashCode());
        result = result * 59 + (this.peerAutonomousDatabaseId == null ? 43 : this.peerAutonomousDatabaseId.hashCode());
        result = result * 59 + (this.peerAutonomousDatabaseLifeCycleState == null ? 43 : this.peerAutonomousDatabaseLifeCycleState.hashCode());
        result = result * 59 + (this.protectionMode == null ? 43 : this.protectionMode.hashCode());
        result = result * 59 + (this.applyLag == null ? 43 : this.applyLag.hashCode());
        result = result * 59 + (this.applyRate == null ? 43 : this.applyRate.hashCode());
        result = result * 59 + (this.isAutomaticFailoverEnabled == null ? 43 : this.isAutomaticFailoverEnabled.hashCode());
        result = result * 59 + (this.transportLag == null ? 43 : this.transportLag.hashCode());
        result = result * 59 + (this.timeLastSynced == null ? 43 : this.timeLastSynced.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeLastRoleChanged == null ? 43 : this.timeLastRoleChanged.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ProtectionMode implements BmcEnum
    {
        MaximumAvailability("MAXIMUM_AVAILABILITY"),
        MaximumPerformance("MAXIMUM_PERFORMANCE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ProtectionMode> map;

        private ProtectionMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ProtectionMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ProtectionMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ProtectionMode.class);
            map = new HashMap<String, ProtectionMode>();
            for (ProtectionMode v : ProtectionMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PeerAutonomousDatabaseLifeCycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        RoleChangeInProgress("ROLE_CHANGE_IN_PROGRESS"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Failed("FAILED"),
        Unavailable("UNAVAILABLE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PeerAutonomousDatabaseLifeCycleState> map;

        private PeerAutonomousDatabaseLifeCycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PeerAutonomousDatabaseLifeCycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PeerAutonomousDatabaseLifeCycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PeerAutonomousDatabaseLifeCycleState.class);
            map = new HashMap<String, PeerAutonomousDatabaseLifeCycleState>();
            for (PeerAutonomousDatabaseLifeCycleState v : PeerAutonomousDatabaseLifeCycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PeerRole implements BmcEnum
    {
        Primary("PRIMARY"),
        Standby("STANDBY"),
        DisabledStandby("DISABLED_STANDBY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PeerRole> map;

        private PeerRole(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PeerRole create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PeerRole', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PeerRole.class);
            map = new HashMap<String, PeerRole>();
            for (PeerRole v : PeerRole.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        RoleChangeInProgress("ROLE_CHANGE_IN_PROGRESS"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Failed("FAILED"),
        Unavailable("UNAVAILABLE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Role implements BmcEnum
    {
        Primary("PRIMARY"),
        Standby("STANDBY"),
        DisabledStandby("DISABLED_STANDBY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Role> map;

        private Role(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Role create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Role', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Role.class);
            map = new HashMap<String, Role>();
            for (Role v : Role.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="autonomousDatabaseId")
        private String autonomousDatabaseId;
        @JsonProperty(value="role")
        private Role role;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="peerRole")
        private PeerRole peerRole;
        @JsonProperty(value="peerAutonomousDatabaseId")
        private String peerAutonomousDatabaseId;
        @JsonProperty(value="peerAutonomousDatabaseLifeCycleState")
        private PeerAutonomousDatabaseLifeCycleState peerAutonomousDatabaseLifeCycleState;
        @JsonProperty(value="protectionMode")
        private ProtectionMode protectionMode;
        @JsonProperty(value="applyLag")
        private String applyLag;
        @JsonProperty(value="applyRate")
        private String applyRate;
        @JsonProperty(value="isAutomaticFailoverEnabled")
        private Boolean isAutomaticFailoverEnabled;
        @JsonProperty(value="transportLag")
        private String transportLag;
        @JsonProperty(value="timeLastSynced")
        private Date timeLastSynced;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeLastRoleChanged")
        private Date timeLastRoleChanged;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder autonomousDatabaseId(String autonomousDatabaseId) {
            this.autonomousDatabaseId = autonomousDatabaseId;
            this.__explicitlySet__.add("autonomousDatabaseId");
            return this;
        }

        public Builder role(Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder peerRole(PeerRole peerRole) {
            this.peerRole = peerRole;
            this.__explicitlySet__.add("peerRole");
            return this;
        }

        public Builder peerAutonomousDatabaseId(String peerAutonomousDatabaseId) {
            this.peerAutonomousDatabaseId = peerAutonomousDatabaseId;
            this.__explicitlySet__.add("peerAutonomousDatabaseId");
            return this;
        }

        public Builder peerAutonomousDatabaseLifeCycleState(PeerAutonomousDatabaseLifeCycleState peerAutonomousDatabaseLifeCycleState) {
            this.peerAutonomousDatabaseLifeCycleState = peerAutonomousDatabaseLifeCycleState;
            this.__explicitlySet__.add("peerAutonomousDatabaseLifeCycleState");
            return this;
        }

        public Builder protectionMode(ProtectionMode protectionMode) {
            this.protectionMode = protectionMode;
            this.__explicitlySet__.add("protectionMode");
            return this;
        }

        public Builder applyLag(String applyLag) {
            this.applyLag = applyLag;
            this.__explicitlySet__.add("applyLag");
            return this;
        }

        public Builder applyRate(String applyRate) {
            this.applyRate = applyRate;
            this.__explicitlySet__.add("applyRate");
            return this;
        }

        public Builder isAutomaticFailoverEnabled(Boolean isAutomaticFailoverEnabled) {
            this.isAutomaticFailoverEnabled = isAutomaticFailoverEnabled;
            this.__explicitlySet__.add("isAutomaticFailoverEnabled");
            return this;
        }

        public Builder transportLag(String transportLag) {
            this.transportLag = transportLag;
            this.__explicitlySet__.add("transportLag");
            return this;
        }

        public Builder timeLastSynced(Date timeLastSynced) {
            this.timeLastSynced = timeLastSynced;
            this.__explicitlySet__.add("timeLastSynced");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeLastRoleChanged(Date timeLastRoleChanged) {
            this.timeLastRoleChanged = timeLastRoleChanged;
            this.__explicitlySet__.add("timeLastRoleChanged");
            return this;
        }

        public AutonomousDatabaseDataguardAssociation build() {
            AutonomousDatabaseDataguardAssociation model = new AutonomousDatabaseDataguardAssociation(this.id, this.autonomousDatabaseId, this.role, this.lifecycleState, this.lifecycleDetails, this.peerRole, this.peerAutonomousDatabaseId, this.peerAutonomousDatabaseLifeCycleState, this.protectionMode, this.applyLag, this.applyRate, this.isAutomaticFailoverEnabled, this.transportLag, this.timeLastSynced, this.timeCreated, this.timeLastRoleChanged);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutonomousDatabaseDataguardAssociation model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("autonomousDatabaseId")) {
                this.autonomousDatabaseId(model.getAutonomousDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("role")) {
                this.role(model.getRole());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("peerRole")) {
                this.peerRole(model.getPeerRole());
            }
            if (model.wasPropertyExplicitlySet("peerAutonomousDatabaseId")) {
                this.peerAutonomousDatabaseId(model.getPeerAutonomousDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("peerAutonomousDatabaseLifeCycleState")) {
                this.peerAutonomousDatabaseLifeCycleState(model.getPeerAutonomousDatabaseLifeCycleState());
            }
            if (model.wasPropertyExplicitlySet("protectionMode")) {
                this.protectionMode(model.getProtectionMode());
            }
            if (model.wasPropertyExplicitlySet("applyLag")) {
                this.applyLag(model.getApplyLag());
            }
            if (model.wasPropertyExplicitlySet("applyRate")) {
                this.applyRate(model.getApplyRate());
            }
            if (model.wasPropertyExplicitlySet("isAutomaticFailoverEnabled")) {
                this.isAutomaticFailoverEnabled(model.getIsAutomaticFailoverEnabled());
            }
            if (model.wasPropertyExplicitlySet("transportLag")) {
                this.transportLag(model.getTransportLag());
            }
            if (model.wasPropertyExplicitlySet("timeLastSynced")) {
                this.timeLastSynced(model.getTimeLastSynced());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeLastRoleChanged")) {
                this.timeLastRoleChanged(model.getTimeLastRoleChanged());
            }
            return this;
        }
    }
}

