/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutonomousDatabaseBackup
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="autonomousDatabaseId")
    private final String autonomousDatabaseId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="isAutomatic")
    private final Boolean isAutomatic;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeEnded")
    private final Date timeEnded;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="databaseSizeInTBs")
    private final BigDecimal databaseSizeInTBs;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="isRestorable")
    private final Boolean isRestorable;
    @JsonProperty(value="keyStoreId")
    private final String keyStoreId;
    @JsonProperty(value="keyStoreWalletName")
    private final String keyStoreWalletName;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="vaultId")
    private final String vaultId;
    @JsonProperty(value="kmsKeyVersionId")
    private final String kmsKeyVersionId;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "autonomousDatabaseId", "displayName", "type", "isAutomatic", "timeStarted", "timeEnded", "lifecycleDetails", "databaseSizeInTBs", "lifecycleState", "isRestorable", "keyStoreId", "keyStoreWalletName", "kmsKeyId", "vaultId", "kmsKeyVersionId"})
    public AutonomousDatabaseBackup(String id, String compartmentId, String autonomousDatabaseId, String displayName, Type type, Boolean isAutomatic, Date timeStarted, Date timeEnded, String lifecycleDetails, BigDecimal databaseSizeInTBs, LifecycleState lifecycleState, Boolean isRestorable, String keyStoreId, String keyStoreWalletName, String kmsKeyId, String vaultId, String kmsKeyVersionId) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.autonomousDatabaseId = autonomousDatabaseId;
        this.displayName = displayName;
        this.type = type;
        this.isAutomatic = isAutomatic;
        this.timeStarted = timeStarted;
        this.timeEnded = timeEnded;
        this.lifecycleDetails = lifecycleDetails;
        this.databaseSizeInTBs = databaseSizeInTBs;
        this.lifecycleState = lifecycleState;
        this.isRestorable = isRestorable;
        this.keyStoreId = keyStoreId;
        this.keyStoreWalletName = keyStoreWalletName;
        this.kmsKeyId = kmsKeyId;
        this.vaultId = vaultId;
        this.kmsKeyVersionId = kmsKeyVersionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAutonomousDatabaseId() {
        return this.autonomousDatabaseId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Type getType() {
        return this.type;
    }

    public Boolean getIsAutomatic() {
        return this.isAutomatic;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeEnded() {
        return this.timeEnded;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public BigDecimal getDatabaseSizeInTBs() {
        return this.databaseSizeInTBs;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Boolean getIsRestorable() {
        return this.isRestorable;
    }

    public String getKeyStoreId() {
        return this.keyStoreId;
    }

    public String getKeyStoreWalletName() {
        return this.keyStoreWalletName;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public String getVaultId() {
        return this.vaultId;
    }

    public String getKmsKeyVersionId() {
        return this.kmsKeyVersionId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutonomousDatabaseBackup(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", autonomousDatabaseId=").append(String.valueOf(this.autonomousDatabaseId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", isAutomatic=").append(String.valueOf(this.isAutomatic));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeEnded=").append(String.valueOf(this.timeEnded));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", databaseSizeInTBs=").append(String.valueOf(this.databaseSizeInTBs));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", isRestorable=").append(String.valueOf(this.isRestorable));
        sb.append(", keyStoreId=").append(String.valueOf(this.keyStoreId));
        sb.append(", keyStoreWalletName=").append(String.valueOf(this.keyStoreWalletName));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(", vaultId=").append(String.valueOf(this.vaultId));
        sb.append(", kmsKeyVersionId=").append(String.valueOf(this.kmsKeyVersionId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutonomousDatabaseBackup)) {
            return false;
        }
        AutonomousDatabaseBackup other = (AutonomousDatabaseBackup)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.autonomousDatabaseId, other.autonomousDatabaseId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.isAutomatic, other.isAutomatic) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeEnded, other.timeEnded) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.databaseSizeInTBs, other.databaseSizeInTBs) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.isRestorable, other.isRestorable) && Objects.equals(this.keyStoreId, other.keyStoreId) && Objects.equals(this.keyStoreWalletName, other.keyStoreWalletName) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && Objects.equals(this.vaultId, other.vaultId) && Objects.equals(this.kmsKeyVersionId, other.kmsKeyVersionId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.autonomousDatabaseId == null ? 43 : this.autonomousDatabaseId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.isAutomatic == null ? 43 : this.isAutomatic.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeEnded == null ? 43 : this.timeEnded.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.databaseSizeInTBs == null ? 43 : this.databaseSizeInTBs.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.isRestorable == null ? 43 : this.isRestorable.hashCode());
        result = result * 59 + (this.keyStoreId == null ? 43 : this.keyStoreId.hashCode());
        result = result * 59 + (this.keyStoreWalletName == null ? 43 : this.keyStoreWalletName.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + (this.vaultId == null ? 43 : this.vaultId.hashCode());
        result = result * 59 + (this.kmsKeyVersionId == null ? 43 : this.kmsKeyVersionId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Type implements BmcEnum
    {
        Incremental("INCREMENTAL"),
        Full("FULL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="autonomousDatabaseId")
        private String autonomousDatabaseId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="isAutomatic")
        private Boolean isAutomatic;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeEnded")
        private Date timeEnded;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="databaseSizeInTBs")
        private BigDecimal databaseSizeInTBs;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="isRestorable")
        private Boolean isRestorable;
        @JsonProperty(value="keyStoreId")
        private String keyStoreId;
        @JsonProperty(value="keyStoreWalletName")
        private String keyStoreWalletName;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="vaultId")
        private String vaultId;
        @JsonProperty(value="kmsKeyVersionId")
        private String kmsKeyVersionId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder autonomousDatabaseId(String autonomousDatabaseId) {
            this.autonomousDatabaseId = autonomousDatabaseId;
            this.__explicitlySet__.add("autonomousDatabaseId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder isAutomatic(Boolean isAutomatic) {
            this.isAutomatic = isAutomatic;
            this.__explicitlySet__.add("isAutomatic");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeEnded(Date timeEnded) {
            this.timeEnded = timeEnded;
            this.__explicitlySet__.add("timeEnded");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder databaseSizeInTBs(BigDecimal databaseSizeInTBs) {
            this.databaseSizeInTBs = databaseSizeInTBs;
            this.__explicitlySet__.add("databaseSizeInTBs");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder isRestorable(Boolean isRestorable) {
            this.isRestorable = isRestorable;
            this.__explicitlySet__.add("isRestorable");
            return this;
        }

        public Builder keyStoreId(String keyStoreId) {
            this.keyStoreId = keyStoreId;
            this.__explicitlySet__.add("keyStoreId");
            return this;
        }

        public Builder keyStoreWalletName(String keyStoreWalletName) {
            this.keyStoreWalletName = keyStoreWalletName;
            this.__explicitlySet__.add("keyStoreWalletName");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            this.__explicitlySet__.add("vaultId");
            return this;
        }

        public Builder kmsKeyVersionId(String kmsKeyVersionId) {
            this.kmsKeyVersionId = kmsKeyVersionId;
            this.__explicitlySet__.add("kmsKeyVersionId");
            return this;
        }

        public AutonomousDatabaseBackup build() {
            AutonomousDatabaseBackup model = new AutonomousDatabaseBackup(this.id, this.compartmentId, this.autonomousDatabaseId, this.displayName, this.type, this.isAutomatic, this.timeStarted, this.timeEnded, this.lifecycleDetails, this.databaseSizeInTBs, this.lifecycleState, this.isRestorable, this.keyStoreId, this.keyStoreWalletName, this.kmsKeyId, this.vaultId, this.kmsKeyVersionId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutonomousDatabaseBackup model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("autonomousDatabaseId")) {
                this.autonomousDatabaseId(model.getAutonomousDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("isAutomatic")) {
                this.isAutomatic(model.getIsAutomatic());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeEnded")) {
                this.timeEnded(model.getTimeEnded());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("databaseSizeInTBs")) {
                this.databaseSizeInTBs(model.getDatabaseSizeInTBs());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("isRestorable")) {
                this.isRestorable(model.getIsRestorable());
            }
            if (model.wasPropertyExplicitlySet("keyStoreId")) {
                this.keyStoreId(model.getKeyStoreId());
            }
            if (model.wasPropertyExplicitlySet("keyStoreWalletName")) {
                this.keyStoreWalletName(model.getKeyStoreWalletName());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            if (model.wasPropertyExplicitlySet("vaultId")) {
                this.vaultId(model.getVaultId());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyVersionId")) {
                this.kmsKeyVersionId(model.getKmsKeyVersionId());
            }
            return this;
        }
    }
}

