/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dashboardservice.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteDashboardRequest
extends BmcRequest<Void> {
    private String dashboardId;
    private String ifMatch;
    private String opcRequestId;
    private String opcCrossRegion;

    public String getDashboardId() {
        return this.dashboardId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcCrossRegion() {
        return this.opcCrossRegion;
    }

    public Builder toBuilder() {
        return new Builder().dashboardId(this.dashboardId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcCrossRegion(this.opcCrossRegion);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dashboardId=").append(String.valueOf(this.dashboardId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcCrossRegion=").append(String.valueOf(this.opcCrossRegion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteDashboardRequest)) {
            return false;
        }
        DeleteDashboardRequest other = (DeleteDashboardRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dashboardId, other.dashboardId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcCrossRegion, other.opcCrossRegion);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dashboardId == null ? 43 : this.dashboardId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcCrossRegion == null ? 43 : this.opcCrossRegion.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteDashboardRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dashboardId = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcCrossRegion = null;

        public Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcCrossRegion(String opcCrossRegion) {
            this.opcCrossRegion = opcCrossRegion;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDashboardRequest o) {
            this.dashboardId(o.getDashboardId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcCrossRegion(o.getOpcCrossRegion());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDashboardRequest build() {
            DeleteDashboardRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteDashboardRequest buildWithoutInvocationCallback() {
            DeleteDashboardRequest request = new DeleteDashboardRequest();
            request.dashboardId = this.dashboardId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcCrossRegion = this.opcCrossRegion;
            return request;
        }
    }
}

