/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dashboardservice;

import com.oracle.bmc.dashboardservice.Dashboard;
import com.oracle.bmc.dashboardservice.model.DashboardSummary;
import com.oracle.bmc.dashboardservice.requests.ListDashboardsRequest;
import com.oracle.bmc.dashboardservice.responses.ListDashboardsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class DashboardPaginators {
    private final Dashboard client;

    public DashboardPaginators(Dashboard client) {
        this.client = client;
    }

    public Iterable<ListDashboardsResponse> listDashboardsResponseIterator(final ListDashboardsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDashboardsRequest.Builder>(){

            @Override
            public ListDashboardsRequest.Builder get() {
                return ListDashboardsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDashboardsResponse, String>(){

            @Override
            public String apply(ListDashboardsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDashboardsRequest.Builder>, ListDashboardsRequest>(){

            @Override
            public ListDashboardsRequest apply(RequestBuilderAndToken<ListDashboardsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDashboardsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDashboardsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDashboardsRequest, ListDashboardsResponse>(){

            @Override
            public ListDashboardsResponse apply(ListDashboardsRequest request) {
                return DashboardPaginators.this.client.listDashboards(request);
            }
        });
    }

    public Iterable<DashboardSummary> listDashboardsRecordIterator(final ListDashboardsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDashboardsRequest.Builder>(){

            @Override
            public ListDashboardsRequest.Builder get() {
                return ListDashboardsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDashboardsResponse, String>(){

            @Override
            public String apply(ListDashboardsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDashboardsRequest.Builder>, ListDashboardsRequest>(){

            @Override
            public ListDashboardsRequest apply(RequestBuilderAndToken<ListDashboardsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDashboardsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDashboardsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDashboardsRequest, ListDashboardsResponse>(){

            @Override
            public ListDashboardsResponse apply(ListDashboardsRequest request) {
                return DashboardPaginators.this.client.listDashboards(request);
            }
        }, (Function)new Function<ListDashboardsResponse, List<DashboardSummary>>(){

            @Override
            public List<DashboardSummary> apply(ListDashboardsResponse response) {
                return response.getDashboardCollection().getItems();
            }
        });
    }
}

