/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dashboardservice;

import com.oracle.bmc.dashboardservice.DashboardGroup;
import com.oracle.bmc.dashboardservice.model.DashboardGroup;
import com.oracle.bmc.dashboardservice.requests.GetDashboardGroupRequest;
import com.oracle.bmc.dashboardservice.responses.GetDashboardGroupResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DashboardGroupWaiters {
    private final ExecutorService executorService;
    private final DashboardGroup client;

    public DashboardGroupWaiters(ExecutorService executorService, DashboardGroup client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetDashboardGroupRequest, GetDashboardGroupResponse> forDashboardGroup(GetDashboardGroupRequest request, DashboardGroup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDashboardGroup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDashboardGroupRequest, GetDashboardGroupResponse> forDashboardGroup(GetDashboardGroupRequest request, DashboardGroup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDashboardGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDashboardGroupRequest, GetDashboardGroupResponse> forDashboardGroup(GetDashboardGroupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DashboardGroup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDashboardGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDashboardGroupRequest, GetDashboardGroupResponse> forDashboardGroup(BmcGenericWaiter waiter, GetDashboardGroupRequest request, DashboardGroup.LifecycleState ... targetStates) {
        final HashSet<DashboardGroup.LifecycleState> targetStatesSet = new HashSet<DashboardGroup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDashboardGroupRequest, GetDashboardGroupResponse>(){

            @Override
            public GetDashboardGroupResponse apply(GetDashboardGroupRequest request) {
                return DashboardGroupWaiters.this.client.getDashboardGroup(request);
            }
        }, (Predicate)new Predicate<GetDashboardGroupResponse>(){

            @Override
            public boolean test(GetDashboardGroupResponse response) {
                return targetStatesSet.contains((Object)response.getDashboardGroup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DashboardGroup.LifecycleState.Deleted)), (Object)request);
    }
}

