/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerinstances;

import com.oracle.bmc.containerinstances.ContainerInstance;
import com.oracle.bmc.containerinstances.model.ContainerInstanceShapeSummary;
import com.oracle.bmc.containerinstances.model.ContainerInstanceSummary;
import com.oracle.bmc.containerinstances.model.ContainerSummary;
import com.oracle.bmc.containerinstances.model.WorkRequestError;
import com.oracle.bmc.containerinstances.model.WorkRequestLogEntry;
import com.oracle.bmc.containerinstances.model.WorkRequestSummary;
import com.oracle.bmc.containerinstances.requests.ListContainerInstanceShapesRequest;
import com.oracle.bmc.containerinstances.requests.ListContainerInstancesRequest;
import com.oracle.bmc.containerinstances.requests.ListContainersRequest;
import com.oracle.bmc.containerinstances.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.containerinstances.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.containerinstances.requests.ListWorkRequestsRequest;
import com.oracle.bmc.containerinstances.responses.ListContainerInstanceShapesResponse;
import com.oracle.bmc.containerinstances.responses.ListContainerInstancesResponse;
import com.oracle.bmc.containerinstances.responses.ListContainersResponse;
import com.oracle.bmc.containerinstances.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.containerinstances.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.containerinstances.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ContainerInstancePaginators {
    private final ContainerInstance client;

    public ContainerInstancePaginators(ContainerInstance client) {
        this.client = client;
    }

    public Iterable<ListContainerInstanceShapesResponse> listContainerInstanceShapesResponseIterator(final ListContainerInstanceShapesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListContainerInstanceShapesRequest.Builder>(){

            @Override
            public ListContainerInstanceShapesRequest.Builder get() {
                return ListContainerInstanceShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainerInstanceShapesResponse, String>(){

            @Override
            public String apply(ListContainerInstanceShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainerInstanceShapesRequest.Builder>, ListContainerInstanceShapesRequest>(){

            @Override
            public ListContainerInstanceShapesRequest apply(RequestBuilderAndToken<ListContainerInstanceShapesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListContainerInstanceShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainerInstanceShapesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListContainerInstanceShapesRequest, ListContainerInstanceShapesResponse>(){

            @Override
            public ListContainerInstanceShapesResponse apply(ListContainerInstanceShapesRequest request) {
                return ContainerInstancePaginators.this.client.listContainerInstanceShapes(request);
            }
        });
    }

    public Iterable<ContainerInstanceShapeSummary> listContainerInstanceShapesRecordIterator(final ListContainerInstanceShapesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListContainerInstanceShapesRequest.Builder>(){

            @Override
            public ListContainerInstanceShapesRequest.Builder get() {
                return ListContainerInstanceShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainerInstanceShapesResponse, String>(){

            @Override
            public String apply(ListContainerInstanceShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainerInstanceShapesRequest.Builder>, ListContainerInstanceShapesRequest>(){

            @Override
            public ListContainerInstanceShapesRequest apply(RequestBuilderAndToken<ListContainerInstanceShapesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListContainerInstanceShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainerInstanceShapesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListContainerInstanceShapesRequest, ListContainerInstanceShapesResponse>(){

            @Override
            public ListContainerInstanceShapesResponse apply(ListContainerInstanceShapesRequest request) {
                return ContainerInstancePaginators.this.client.listContainerInstanceShapes(request);
            }
        }, (Function)new Function<ListContainerInstanceShapesResponse, List<ContainerInstanceShapeSummary>>(){

            @Override
            public List<ContainerInstanceShapeSummary> apply(ListContainerInstanceShapesResponse response) {
                return response.getContainerInstanceShapeCollection().getItems();
            }
        });
    }

    public Iterable<ListContainerInstancesResponse> listContainerInstancesResponseIterator(final ListContainerInstancesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListContainerInstancesRequest.Builder>(){

            @Override
            public ListContainerInstancesRequest.Builder get() {
                return ListContainerInstancesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainerInstancesResponse, String>(){

            @Override
            public String apply(ListContainerInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainerInstancesRequest.Builder>, ListContainerInstancesRequest>(){

            @Override
            public ListContainerInstancesRequest apply(RequestBuilderAndToken<ListContainerInstancesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListContainerInstancesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainerInstancesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListContainerInstancesRequest, ListContainerInstancesResponse>(){

            @Override
            public ListContainerInstancesResponse apply(ListContainerInstancesRequest request) {
                return ContainerInstancePaginators.this.client.listContainerInstances(request);
            }
        });
    }

    public Iterable<ContainerInstanceSummary> listContainerInstancesRecordIterator(final ListContainerInstancesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListContainerInstancesRequest.Builder>(){

            @Override
            public ListContainerInstancesRequest.Builder get() {
                return ListContainerInstancesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainerInstancesResponse, String>(){

            @Override
            public String apply(ListContainerInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainerInstancesRequest.Builder>, ListContainerInstancesRequest>(){

            @Override
            public ListContainerInstancesRequest apply(RequestBuilderAndToken<ListContainerInstancesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListContainerInstancesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainerInstancesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListContainerInstancesRequest, ListContainerInstancesResponse>(){

            @Override
            public ListContainerInstancesResponse apply(ListContainerInstancesRequest request) {
                return ContainerInstancePaginators.this.client.listContainerInstances(request);
            }
        }, (Function)new Function<ListContainerInstancesResponse, List<ContainerInstanceSummary>>(){

            @Override
            public List<ContainerInstanceSummary> apply(ListContainerInstancesResponse response) {
                return response.getContainerInstanceCollection().getItems();
            }
        });
    }

    public Iterable<ListContainersResponse> listContainersResponseIterator(final ListContainersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListContainersRequest.Builder>(){

            @Override
            public ListContainersRequest.Builder get() {
                return ListContainersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainersResponse, String>(){

            @Override
            public String apply(ListContainersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainersRequest.Builder>, ListContainersRequest>(){

            @Override
            public ListContainersRequest apply(RequestBuilderAndToken<ListContainersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListContainersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListContainersRequest, ListContainersResponse>(){

            @Override
            public ListContainersResponse apply(ListContainersRequest request) {
                return ContainerInstancePaginators.this.client.listContainers(request);
            }
        });
    }

    public Iterable<ContainerSummary> listContainersRecordIterator(final ListContainersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListContainersRequest.Builder>(){

            @Override
            public ListContainersRequest.Builder get() {
                return ListContainersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainersResponse, String>(){

            @Override
            public String apply(ListContainersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainersRequest.Builder>, ListContainersRequest>(){

            @Override
            public ListContainersRequest apply(RequestBuilderAndToken<ListContainersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListContainersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListContainersRequest, ListContainersResponse>(){

            @Override
            public ListContainersResponse apply(ListContainersRequest request) {
                return ContainerInstancePaginators.this.client.listContainers(request);
            }
        }, (Function)new Function<ListContainersResponse, List<ContainerSummary>>(){

            @Override
            public List<ContainerSummary> apply(ListContainersResponse response) {
                return response.getContainerCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ContainerInstancePaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ContainerInstancePaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ContainerInstancePaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ContainerInstancePaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ContainerInstancePaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ContainerInstancePaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

