/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerinstances;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.containerinstances.ContainerInstanceAsync;
import com.oracle.bmc.containerinstances.model.Container;
import com.oracle.bmc.containerinstances.model.ContainerCollection;
import com.oracle.bmc.containerinstances.model.ContainerInstance;
import com.oracle.bmc.containerinstances.model.ContainerInstanceCollection;
import com.oracle.bmc.containerinstances.model.ContainerInstanceShapeCollection;
import com.oracle.bmc.containerinstances.model.WorkRequest;
import com.oracle.bmc.containerinstances.model.WorkRequestErrorCollection;
import com.oracle.bmc.containerinstances.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.containerinstances.model.WorkRequestSummaryCollection;
import com.oracle.bmc.containerinstances.requests.ChangeContainerInstanceCompartmentRequest;
import com.oracle.bmc.containerinstances.requests.CreateContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.DeleteContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.GetContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.GetContainerRequest;
import com.oracle.bmc.containerinstances.requests.GetWorkRequestRequest;
import com.oracle.bmc.containerinstances.requests.ListContainerInstanceShapesRequest;
import com.oracle.bmc.containerinstances.requests.ListContainerInstancesRequest;
import com.oracle.bmc.containerinstances.requests.ListContainersRequest;
import com.oracle.bmc.containerinstances.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.containerinstances.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.containerinstances.requests.ListWorkRequestsRequest;
import com.oracle.bmc.containerinstances.requests.RestartContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.RetrieveLogsRequest;
import com.oracle.bmc.containerinstances.requests.StartContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.StopContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.UpdateContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.UpdateContainerRequest;
import com.oracle.bmc.containerinstances.responses.ChangeContainerInstanceCompartmentResponse;
import com.oracle.bmc.containerinstances.responses.CreateContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.DeleteContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.GetContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.GetContainerResponse;
import com.oracle.bmc.containerinstances.responses.GetWorkRequestResponse;
import com.oracle.bmc.containerinstances.responses.ListContainerInstanceShapesResponse;
import com.oracle.bmc.containerinstances.responses.ListContainerInstancesResponse;
import com.oracle.bmc.containerinstances.responses.ListContainersResponse;
import com.oracle.bmc.containerinstances.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.containerinstances.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.containerinstances.responses.ListWorkRequestsResponse;
import com.oracle.bmc.containerinstances.responses.RestartContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.RetrieveLogsResponse;
import com.oracle.bmc.containerinstances.responses.StartContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.StopContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.UpdateContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.UpdateContainerResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerInstanceAsyncClient
extends BaseAsyncClient
implements ContainerInstanceAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("CONTAINERINSTANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://compute-containers.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ContainerInstanceAsyncClient.class);

    private ContainerInstanceAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeContainerInstanceCompartmentResponse> changeContainerInstanceCompartment(ChangeContainerInstanceCompartmentRequest request, AsyncHandler<ChangeContainerInstanceCompartmentRequest, ChangeContainerInstanceCompartmentResponse> handler) {
        Validate.notBlank((String)request.getContainerInstanceId(), (String)"containerInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeContainerInstanceCompartmentDetails(), "changeContainerInstanceCompartmentDetails is required");
        return this.clientCall(request, ChangeContainerInstanceCompartmentResponse::builder).logger(LOG, "changeContainerInstanceCompartment").serviceDetails("ContainerInstance", "ChangeContainerInstanceCompartment", "").method(Method.POST).requestBuilder(ChangeContainerInstanceCompartmentRequest::builder).basePath("/20210415").appendPathParam("containerInstances").appendPathParam(request.getContainerInstanceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeContainerInstanceCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeContainerInstanceCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateContainerInstanceResponse> createContainerInstance(CreateContainerInstanceRequest request, AsyncHandler<CreateContainerInstanceRequest, CreateContainerInstanceResponse> handler) {
        Objects.requireNonNull(request.getCreateContainerInstanceDetails(), "createContainerInstanceDetails is required");
        return this.clientCall(request, CreateContainerInstanceResponse::builder).logger(LOG, "createContainerInstance").serviceDetails("ContainerInstance", "CreateContainerInstance", "").method(Method.POST).requestBuilder(CreateContainerInstanceRequest::builder).basePath("/20210415").appendPathParam("containerInstances").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ContainerInstance.class, CreateContainerInstanceResponse.Builder::containerInstance).handleResponseHeaderString("etag", CreateContainerInstanceResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateContainerInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateContainerInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteContainerInstanceResponse> deleteContainerInstance(DeleteContainerInstanceRequest request, AsyncHandler<DeleteContainerInstanceRequest, DeleteContainerInstanceResponse> handler) {
        Validate.notBlank((String)request.getContainerInstanceId(), (String)"containerInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteContainerInstanceResponse::builder).logger(LOG, "deleteContainerInstance").serviceDetails("ContainerInstance", "DeleteContainerInstance", "").method(Method.DELETE).requestBuilder(DeleteContainerInstanceRequest::builder).basePath("/20210415").appendPathParam("containerInstances").appendPathParam(request.getContainerInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteContainerInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteContainerInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetContainerResponse> getContainer(GetContainerRequest request, AsyncHandler<GetContainerRequest, GetContainerResponse> handler) {
        Validate.notBlank((String)request.getContainerId(), (String)"containerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetContainerResponse::builder).logger(LOG, "getContainer").serviceDetails("ContainerInstance", "GetContainer", "").method(Method.GET).requestBuilder(GetContainerRequest::builder).basePath("/20210415").appendPathParam("containers").appendPathParam(request.getContainerId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Container.class, GetContainerResponse.Builder::container).handleResponseHeaderString("etag", GetContainerResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetContainerResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetContainerInstanceResponse> getContainerInstance(GetContainerInstanceRequest request, AsyncHandler<GetContainerInstanceRequest, GetContainerInstanceResponse> handler) {
        Validate.notBlank((String)request.getContainerInstanceId(), (String)"containerInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetContainerInstanceResponse::builder).logger(LOG, "getContainerInstance").serviceDetails("ContainerInstance", "GetContainerInstance", "").method(Method.GET).requestBuilder(GetContainerInstanceRequest::builder).basePath("/20210415").appendPathParam("containerInstances").appendPathParam(request.getContainerInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ContainerInstance.class, GetContainerInstanceResponse.Builder::containerInstance).handleResponseHeaderString("etag", GetContainerInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetContainerInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("ContainerInstance", "GetWorkRequest", "").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210415").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListContainerInstanceShapesResponse> listContainerInstanceShapes(ListContainerInstanceShapesRequest request, AsyncHandler<ListContainerInstanceShapesRequest, ListContainerInstanceShapesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListContainerInstanceShapesResponse::builder).logger(LOG, "listContainerInstanceShapes").serviceDetails("ContainerInstance", "ListContainerInstanceShapes", "").method(Method.GET).requestBuilder(ListContainerInstanceShapesRequest::builder).basePath("/20210415").appendPathParam("containerInstanceShapes").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ContainerInstanceShapeCollection.class, ListContainerInstanceShapesResponse.Builder::containerInstanceShapeCollection).handleResponseHeaderString("opc-request-id", ListContainerInstanceShapesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListContainerInstanceShapesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListContainerInstancesResponse> listContainerInstances(ListContainerInstancesRequest request, AsyncHandler<ListContainerInstancesRequest, ListContainerInstancesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListContainerInstancesResponse::builder).logger(LOG, "listContainerInstances").serviceDetails("ContainerInstance", "ListContainerInstances", "").method(Method.GET).requestBuilder(ListContainerInstancesRequest::builder).basePath("/20210415").appendPathParam("containerInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ContainerInstanceCollection.class, ListContainerInstancesResponse.Builder::containerInstanceCollection).handleResponseHeaderString("opc-request-id", ListContainerInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListContainerInstancesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListContainersResponse> listContainers(ListContainersRequest request, AsyncHandler<ListContainersRequest, ListContainersResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListContainersResponse::builder).logger(LOG, "listContainers").serviceDetails("ContainerInstance", "ListContainers", "").method(Method.GET).requestBuilder(ListContainersRequest::builder).basePath("/20210415").appendPathParam("containers").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("containerInstanceId", (Object)request.getContainerInstanceId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ContainerCollection.class, ListContainersResponse.Builder::containerCollection).handleResponseHeaderString("opc-request-id", ListContainersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListContainersResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("ContainerInstance", "ListWorkRequestErrors", "").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210415").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("ContainerInstance", "ListWorkRequestLogs", "").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210415").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("ContainerInstance", "ListWorkRequests", "").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210415").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<RestartContainerInstanceResponse> restartContainerInstance(RestartContainerInstanceRequest request, AsyncHandler<RestartContainerInstanceRequest, RestartContainerInstanceResponse> handler) {
        Validate.notBlank((String)request.getContainerInstanceId(), (String)"containerInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RestartContainerInstanceResponse::builder).logger(LOG, "restartContainerInstance").serviceDetails("ContainerInstance", "RestartContainerInstance", "").method(Method.POST).requestBuilder(RestartContainerInstanceRequest::builder).basePath("/20210415").appendPathParam("containerInstances").appendPathParam(request.getContainerInstanceId()).appendPathParam("actions").appendPathParam("restart").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", RestartContainerInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RestartContainerInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RetrieveLogsResponse> retrieveLogs(RetrieveLogsRequest request, AsyncHandler<RetrieveLogsRequest, RetrieveLogsResponse> handler) {
        Validate.notBlank((String)request.getContainerId(), (String)"containerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RetrieveLogsResponse::builder).logger(LOG, "retrieveLogs").serviceDetails("ContainerInstance", "RetrieveLogs", "").method(Method.POST).requestBuilder(RetrieveLogsRequest::builder).basePath("/20210415").appendPathParam("containers").appendPathParam(request.getContainerId()).appendPathParam("actions").appendPathParam("retrieveLogs").accept(new String[]{"application/json", "text/plain"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, RetrieveLogsResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", RetrieveLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<StartContainerInstanceResponse> startContainerInstance(StartContainerInstanceRequest request, AsyncHandler<StartContainerInstanceRequest, StartContainerInstanceResponse> handler) {
        Validate.notBlank((String)request.getContainerInstanceId(), (String)"containerInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StartContainerInstanceResponse::builder).logger(LOG, "startContainerInstance").serviceDetails("ContainerInstance", "StartContainerInstance", "").method(Method.POST).requestBuilder(StartContainerInstanceRequest::builder).basePath("/20210415").appendPathParam("containerInstances").appendPathParam(request.getContainerInstanceId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", StartContainerInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StartContainerInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<StopContainerInstanceResponse> stopContainerInstance(StopContainerInstanceRequest request, AsyncHandler<StopContainerInstanceRequest, StopContainerInstanceResponse> handler) {
        Validate.notBlank((String)request.getContainerInstanceId(), (String)"containerInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StopContainerInstanceResponse::builder).logger(LOG, "stopContainerInstance").serviceDetails("ContainerInstance", "StopContainerInstance", "").method(Method.POST).requestBuilder(StopContainerInstanceRequest::builder).basePath("/20210415").appendPathParam("containerInstances").appendPathParam(request.getContainerInstanceId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", StopContainerInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StopContainerInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateContainerResponse> updateContainer(UpdateContainerRequest request, AsyncHandler<UpdateContainerRequest, UpdateContainerResponse> handler) {
        Validate.notBlank((String)request.getContainerId(), (String)"containerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateContainerDetails(), "updateContainerDetails is required");
        return this.clientCall(request, UpdateContainerResponse::builder).logger(LOG, "updateContainer").serviceDetails("ContainerInstance", "UpdateContainer", "").method(Method.PUT).requestBuilder(UpdateContainerRequest::builder).basePath("/20210415").appendPathParam("containers").appendPathParam(request.getContainerId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateContainerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateContainerResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateContainerInstanceResponse> updateContainerInstance(UpdateContainerInstanceRequest request, AsyncHandler<UpdateContainerInstanceRequest, UpdateContainerInstanceResponse> handler) {
        Validate.notBlank((String)request.getContainerInstanceId(), (String)"containerInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateContainerInstanceDetails(), "updateContainerInstanceDetails is required");
        return this.clientCall(request, UpdateContainerInstanceResponse::builder).logger(LOG, "updateContainerInstance").serviceDetails("ContainerInstance", "UpdateContainerInstance", "").method(Method.PUT).requestBuilder(UpdateContainerInstanceRequest::builder).basePath("/20210415").appendPathParam("containerInstances").appendPathParam(request.getContainerInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateContainerInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateContainerInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ContainerInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ContainerInstanceAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ContainerInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ContainerInstanceAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ContainerInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ContainerInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ContainerInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ContainerInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ContainerInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ContainerInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ContainerInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ContainerInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ContainerInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ContainerInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ContainerInstanceAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ContainerInstanceAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ContainerInstanceAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

