/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerengine.model.KeyValue;
import com.oracle.bmc.containerengine.model.NodeEvictionNodePoolSettings;
import com.oracle.bmc.containerengine.model.NodeSourceDetails;
import com.oracle.bmc.containerengine.model.UpdateNodePoolNodeConfigDetails;
import com.oracle.bmc.containerengine.model.UpdateNodeShapeConfigDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateNodePoolDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="kubernetesVersion")
    private final String kubernetesVersion;
    @JsonProperty(value="initialNodeLabels")
    private final List<KeyValue> initialNodeLabels;
    @JsonProperty(value="quantityPerSubnet")
    private final Integer quantityPerSubnet;
    @JsonProperty(value="subnetIds")
    private final List<String> subnetIds;
    @JsonProperty(value="nodeConfigDetails")
    private final UpdateNodePoolNodeConfigDetails nodeConfigDetails;
    @JsonProperty(value="nodeMetadata")
    private final Map<String, String> nodeMetadata;
    @JsonProperty(value="nodeSourceDetails")
    private final NodeSourceDetails nodeSourceDetails;
    @JsonProperty(value="sshPublicKey")
    private final String sshPublicKey;
    @JsonProperty(value="nodeShape")
    private final String nodeShape;
    @JsonProperty(value="nodeShapeConfig")
    private final UpdateNodeShapeConfigDetails nodeShapeConfig;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="nodeEvictionNodePoolSettings")
    private final NodeEvictionNodePoolSettings nodeEvictionNodePoolSettings;

    @Deprecated
    @ConstructorProperties(value={"name", "kubernetesVersion", "initialNodeLabels", "quantityPerSubnet", "subnetIds", "nodeConfigDetails", "nodeMetadata", "nodeSourceDetails", "sshPublicKey", "nodeShape", "nodeShapeConfig", "freeformTags", "definedTags", "nodeEvictionNodePoolSettings"})
    public UpdateNodePoolDetails(String name, String kubernetesVersion, List<KeyValue> initialNodeLabels, Integer quantityPerSubnet, List<String> subnetIds, UpdateNodePoolNodeConfigDetails nodeConfigDetails, Map<String, String> nodeMetadata, NodeSourceDetails nodeSourceDetails, String sshPublicKey, String nodeShape, UpdateNodeShapeConfigDetails nodeShapeConfig, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, NodeEvictionNodePoolSettings nodeEvictionNodePoolSettings) {
        this.name = name;
        this.kubernetesVersion = kubernetesVersion;
        this.initialNodeLabels = initialNodeLabels;
        this.quantityPerSubnet = quantityPerSubnet;
        this.subnetIds = subnetIds;
        this.nodeConfigDetails = nodeConfigDetails;
        this.nodeMetadata = nodeMetadata;
        this.nodeSourceDetails = nodeSourceDetails;
        this.sshPublicKey = sshPublicKey;
        this.nodeShape = nodeShape;
        this.nodeShapeConfig = nodeShapeConfig;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.nodeEvictionNodePoolSettings = nodeEvictionNodePoolSettings;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getKubernetesVersion() {
        return this.kubernetesVersion;
    }

    public List<KeyValue> getInitialNodeLabels() {
        return this.initialNodeLabels;
    }

    public Integer getQuantityPerSubnet() {
        return this.quantityPerSubnet;
    }

    public List<String> getSubnetIds() {
        return this.subnetIds;
    }

    public UpdateNodePoolNodeConfigDetails getNodeConfigDetails() {
        return this.nodeConfigDetails;
    }

    public Map<String, String> getNodeMetadata() {
        return this.nodeMetadata;
    }

    public NodeSourceDetails getNodeSourceDetails() {
        return this.nodeSourceDetails;
    }

    public String getSshPublicKey() {
        return this.sshPublicKey;
    }

    public String getNodeShape() {
        return this.nodeShape;
    }

    public UpdateNodeShapeConfigDetails getNodeShapeConfig() {
        return this.nodeShapeConfig;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public NodeEvictionNodePoolSettings getNodeEvictionNodePoolSettings() {
        return this.nodeEvictionNodePoolSettings;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateNodePoolDetails(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", kubernetesVersion=").append(String.valueOf(this.kubernetesVersion));
        sb.append(", initialNodeLabels=").append(String.valueOf(this.initialNodeLabels));
        sb.append(", quantityPerSubnet=").append(String.valueOf(this.quantityPerSubnet));
        sb.append(", subnetIds=").append(String.valueOf(this.subnetIds));
        sb.append(", nodeConfigDetails=").append(String.valueOf((Object)this.nodeConfigDetails));
        sb.append(", nodeMetadata=").append(String.valueOf(this.nodeMetadata));
        sb.append(", nodeSourceDetails=").append(String.valueOf((Object)this.nodeSourceDetails));
        sb.append(", sshPublicKey=").append(String.valueOf(this.sshPublicKey));
        sb.append(", nodeShape=").append(String.valueOf(this.nodeShape));
        sb.append(", nodeShapeConfig=").append(String.valueOf((Object)this.nodeShapeConfig));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", nodeEvictionNodePoolSettings=").append(String.valueOf((Object)this.nodeEvictionNodePoolSettings));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateNodePoolDetails)) {
            return false;
        }
        UpdateNodePoolDetails other = (UpdateNodePoolDetails)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.kubernetesVersion, other.kubernetesVersion) && Objects.equals(this.initialNodeLabels, other.initialNodeLabels) && Objects.equals(this.quantityPerSubnet, other.quantityPerSubnet) && Objects.equals(this.subnetIds, other.subnetIds) && Objects.equals((Object)this.nodeConfigDetails, (Object)other.nodeConfigDetails) && Objects.equals(this.nodeMetadata, other.nodeMetadata) && Objects.equals((Object)this.nodeSourceDetails, (Object)other.nodeSourceDetails) && Objects.equals(this.sshPublicKey, other.sshPublicKey) && Objects.equals(this.nodeShape, other.nodeShape) && Objects.equals((Object)this.nodeShapeConfig, (Object)other.nodeShapeConfig) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals((Object)this.nodeEvictionNodePoolSettings, (Object)other.nodeEvictionNodePoolSettings) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.kubernetesVersion == null ? 43 : this.kubernetesVersion.hashCode());
        result = result * 59 + (this.initialNodeLabels == null ? 43 : this.initialNodeLabels.hashCode());
        result = result * 59 + (this.quantityPerSubnet == null ? 43 : this.quantityPerSubnet.hashCode());
        result = result * 59 + (this.subnetIds == null ? 43 : this.subnetIds.hashCode());
        result = result * 59 + (this.nodeConfigDetails == null ? 43 : this.nodeConfigDetails.hashCode());
        result = result * 59 + (this.nodeMetadata == null ? 43 : this.nodeMetadata.hashCode());
        result = result * 59 + (this.nodeSourceDetails == null ? 43 : this.nodeSourceDetails.hashCode());
        result = result * 59 + (this.sshPublicKey == null ? 43 : this.sshPublicKey.hashCode());
        result = result * 59 + (this.nodeShape == null ? 43 : this.nodeShape.hashCode());
        result = result * 59 + (this.nodeShapeConfig == null ? 43 : this.nodeShapeConfig.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.nodeEvictionNodePoolSettings == null ? 43 : this.nodeEvictionNodePoolSettings.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="kubernetesVersion")
        private String kubernetesVersion;
        @JsonProperty(value="initialNodeLabels")
        private List<KeyValue> initialNodeLabels;
        @JsonProperty(value="quantityPerSubnet")
        private Integer quantityPerSubnet;
        @JsonProperty(value="subnetIds")
        private List<String> subnetIds;
        @JsonProperty(value="nodeConfigDetails")
        private UpdateNodePoolNodeConfigDetails nodeConfigDetails;
        @JsonProperty(value="nodeMetadata")
        private Map<String, String> nodeMetadata;
        @JsonProperty(value="nodeSourceDetails")
        private NodeSourceDetails nodeSourceDetails;
        @JsonProperty(value="sshPublicKey")
        private String sshPublicKey;
        @JsonProperty(value="nodeShape")
        private String nodeShape;
        @JsonProperty(value="nodeShapeConfig")
        private UpdateNodeShapeConfigDetails nodeShapeConfig;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="nodeEvictionNodePoolSettings")
        private NodeEvictionNodePoolSettings nodeEvictionNodePoolSettings;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder kubernetesVersion(String kubernetesVersion) {
            this.kubernetesVersion = kubernetesVersion;
            this.__explicitlySet__.add("kubernetesVersion");
            return this;
        }

        public Builder initialNodeLabels(List<KeyValue> initialNodeLabels) {
            this.initialNodeLabels = initialNodeLabels;
            this.__explicitlySet__.add("initialNodeLabels");
            return this;
        }

        public Builder quantityPerSubnet(Integer quantityPerSubnet) {
            this.quantityPerSubnet = quantityPerSubnet;
            this.__explicitlySet__.add("quantityPerSubnet");
            return this;
        }

        public Builder subnetIds(List<String> subnetIds) {
            this.subnetIds = subnetIds;
            this.__explicitlySet__.add("subnetIds");
            return this;
        }

        public Builder nodeConfigDetails(UpdateNodePoolNodeConfigDetails nodeConfigDetails) {
            this.nodeConfigDetails = nodeConfigDetails;
            this.__explicitlySet__.add("nodeConfigDetails");
            return this;
        }

        public Builder nodeMetadata(Map<String, String> nodeMetadata) {
            this.nodeMetadata = nodeMetadata;
            this.__explicitlySet__.add("nodeMetadata");
            return this;
        }

        public Builder nodeSourceDetails(NodeSourceDetails nodeSourceDetails) {
            this.nodeSourceDetails = nodeSourceDetails;
            this.__explicitlySet__.add("nodeSourceDetails");
            return this;
        }

        public Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            this.__explicitlySet__.add("sshPublicKey");
            return this;
        }

        public Builder nodeShape(String nodeShape) {
            this.nodeShape = nodeShape;
            this.__explicitlySet__.add("nodeShape");
            return this;
        }

        public Builder nodeShapeConfig(UpdateNodeShapeConfigDetails nodeShapeConfig) {
            this.nodeShapeConfig = nodeShapeConfig;
            this.__explicitlySet__.add("nodeShapeConfig");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder nodeEvictionNodePoolSettings(NodeEvictionNodePoolSettings nodeEvictionNodePoolSettings) {
            this.nodeEvictionNodePoolSettings = nodeEvictionNodePoolSettings;
            this.__explicitlySet__.add("nodeEvictionNodePoolSettings");
            return this;
        }

        public UpdateNodePoolDetails build() {
            UpdateNodePoolDetails model = new UpdateNodePoolDetails(this.name, this.kubernetesVersion, this.initialNodeLabels, this.quantityPerSubnet, this.subnetIds, this.nodeConfigDetails, this.nodeMetadata, this.nodeSourceDetails, this.sshPublicKey, this.nodeShape, this.nodeShapeConfig, this.freeformTags, this.definedTags, this.nodeEvictionNodePoolSettings);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateNodePoolDetails model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("kubernetesVersion")) {
                this.kubernetesVersion(model.getKubernetesVersion());
            }
            if (model.wasPropertyExplicitlySet("initialNodeLabels")) {
                this.initialNodeLabels(model.getInitialNodeLabels());
            }
            if (model.wasPropertyExplicitlySet("quantityPerSubnet")) {
                this.quantityPerSubnet(model.getQuantityPerSubnet());
            }
            if (model.wasPropertyExplicitlySet("subnetIds")) {
                this.subnetIds(model.getSubnetIds());
            }
            if (model.wasPropertyExplicitlySet("nodeConfigDetails")) {
                this.nodeConfigDetails(model.getNodeConfigDetails());
            }
            if (model.wasPropertyExplicitlySet("nodeMetadata")) {
                this.nodeMetadata(model.getNodeMetadata());
            }
            if (model.wasPropertyExplicitlySet("nodeSourceDetails")) {
                this.nodeSourceDetails(model.getNodeSourceDetails());
            }
            if (model.wasPropertyExplicitlySet("sshPublicKey")) {
                this.sshPublicKey(model.getSshPublicKey());
            }
            if (model.wasPropertyExplicitlySet("nodeShape")) {
                this.nodeShape(model.getNodeShape());
            }
            if (model.wasPropertyExplicitlySet("nodeShapeConfig")) {
                this.nodeShapeConfig(model.getNodeShapeConfig());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("nodeEvictionNodePoolSettings")) {
                this.nodeEvictionNodePoolSettings(model.getNodeEvictionNodePoolSettings());
            }
            return this;
        }
    }
}

