/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine;

import com.oracle.bmc.containerengine.ContainerEngine;
import com.oracle.bmc.containerengine.model.ClusterSummary;
import com.oracle.bmc.containerengine.model.NodePoolSummary;
import com.oracle.bmc.containerengine.model.WorkRequestSummary;
import com.oracle.bmc.containerengine.requests.ListClustersRequest;
import com.oracle.bmc.containerengine.requests.ListNodePoolsRequest;
import com.oracle.bmc.containerengine.requests.ListWorkRequestsRequest;
import com.oracle.bmc.containerengine.responses.ListClustersResponse;
import com.oracle.bmc.containerengine.responses.ListNodePoolsResponse;
import com.oracle.bmc.containerengine.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ContainerEnginePaginators {
    private final ContainerEngine client;

    public ContainerEnginePaginators(ContainerEngine client) {
        this.client = client;
    }

    public Iterable<ListClustersResponse> listClustersResponseIterator(final ListClustersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListClustersRequest.Builder>(){

            @Override
            public ListClustersRequest.Builder get() {
                return ListClustersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListClustersResponse, String>(){

            @Override
            public String apply(ListClustersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListClustersRequest.Builder>, ListClustersRequest>(){

            @Override
            public ListClustersRequest apply(RequestBuilderAndToken<ListClustersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListClustersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListClustersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListClustersRequest, ListClustersResponse>(){

            @Override
            public ListClustersResponse apply(ListClustersRequest request) {
                return ContainerEnginePaginators.this.client.listClusters(request);
            }
        });
    }

    public Iterable<ClusterSummary> listClustersRecordIterator(final ListClustersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListClustersRequest.Builder>(){

            @Override
            public ListClustersRequest.Builder get() {
                return ListClustersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListClustersResponse, String>(){

            @Override
            public String apply(ListClustersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListClustersRequest.Builder>, ListClustersRequest>(){

            @Override
            public ListClustersRequest apply(RequestBuilderAndToken<ListClustersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListClustersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListClustersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListClustersRequest, ListClustersResponse>(){

            @Override
            public ListClustersResponse apply(ListClustersRequest request) {
                return ContainerEnginePaginators.this.client.listClusters(request);
            }
        }, (Function)new Function<ListClustersResponse, List<ClusterSummary>>(){

            @Override
            public List<ClusterSummary> apply(ListClustersResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListNodePoolsResponse> listNodePoolsResponseIterator(final ListNodePoolsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListNodePoolsRequest.Builder>(){

            @Override
            public ListNodePoolsRequest.Builder get() {
                return ListNodePoolsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNodePoolsResponse, String>(){

            @Override
            public String apply(ListNodePoolsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNodePoolsRequest.Builder>, ListNodePoolsRequest>(){

            @Override
            public ListNodePoolsRequest apply(RequestBuilderAndToken<ListNodePoolsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListNodePoolsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNodePoolsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListNodePoolsRequest, ListNodePoolsResponse>(){

            @Override
            public ListNodePoolsResponse apply(ListNodePoolsRequest request) {
                return ContainerEnginePaginators.this.client.listNodePools(request);
            }
        });
    }

    public Iterable<NodePoolSummary> listNodePoolsRecordIterator(final ListNodePoolsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListNodePoolsRequest.Builder>(){

            @Override
            public ListNodePoolsRequest.Builder get() {
                return ListNodePoolsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNodePoolsResponse, String>(){

            @Override
            public String apply(ListNodePoolsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNodePoolsRequest.Builder>, ListNodePoolsRequest>(){

            @Override
            public ListNodePoolsRequest apply(RequestBuilderAndToken<ListNodePoolsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListNodePoolsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNodePoolsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListNodePoolsRequest, ListNodePoolsResponse>(){

            @Override
            public ListNodePoolsResponse apply(ListNodePoolsRequest request) {
                return ContainerEnginePaginators.this.client.listNodePools(request);
            }
        }, (Function)new Function<ListNodePoolsResponse, List<NodePoolSummary>>(){

            @Override
            public List<NodePoolSummary> apply(ListNodePoolsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ContainerEnginePaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ContainerEnginePaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }
}

