/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetInstanceAgentCommandRequest
extends BmcRequest<Void> {
    private String instanceAgentCommandId;
    private String opcRequestId;

    public String getInstanceAgentCommandId() {
        return this.instanceAgentCommandId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().instanceAgentCommandId(this.instanceAgentCommandId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",instanceAgentCommandId=").append(String.valueOf(this.instanceAgentCommandId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetInstanceAgentCommandRequest)) {
            return false;
        }
        GetInstanceAgentCommandRequest other = (GetInstanceAgentCommandRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.instanceAgentCommandId, other.instanceAgentCommandId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instanceAgentCommandId == null ? 43 : this.instanceAgentCommandId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetInstanceAgentCommandRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String instanceAgentCommandId = null;
        private String opcRequestId = null;

        public Builder instanceAgentCommandId(String instanceAgentCommandId) {
            this.instanceAgentCommandId = instanceAgentCommandId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetInstanceAgentCommandRequest o) {
            this.instanceAgentCommandId(o.getInstanceAgentCommandId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetInstanceAgentCommandRequest build() {
            GetInstanceAgentCommandRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetInstanceAgentCommandRequest buildWithoutInvocationCallback() {
            GetInstanceAgentCommandRequest request = new GetInstanceAgentCommandRequest();
            request.instanceAgentCommandId = this.instanceAgentCommandId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

