/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.computeinstanceagent.model.InstanceAgentCommandExecutionOutputContent;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="outputType")
@JsonFilter(value="explicitlySetFilter")
public final class InstanceAgentCommandExecutionOutputViaTextDetails
extends InstanceAgentCommandExecutionOutputContent {
    @JsonProperty(value="text")
    private final String text;
    @JsonProperty(value="textSha256")
    private final String textSha256;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public InstanceAgentCommandExecutionOutputViaTextDetails(Integer exitCode, String message, String text, String textSha256) {
        super(exitCode, message);
        this.text = text;
        this.textSha256 = textSha256;
    }

    public String getText() {
        return this.text;
    }

    public String getTextSha256() {
        return this.textSha256;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstanceAgentCommandExecutionOutputViaTextDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", text=").append(String.valueOf(this.text));
        sb.append(", textSha256=").append(String.valueOf(this.textSha256));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceAgentCommandExecutionOutputViaTextDetails)) {
            return false;
        }
        InstanceAgentCommandExecutionOutputViaTextDetails other = (InstanceAgentCommandExecutionOutputViaTextDetails)((Object)o);
        return Objects.equals(this.text, other.text) && Objects.equals(this.textSha256, other.textSha256) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.text == null ? 43 : this.text.hashCode());
        result = result * 59 + (this.textSha256 == null ? 43 : this.textSha256.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="exitCode")
        private Integer exitCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="text")
        private String text;
        @JsonProperty(value="textSha256")
        private String textSha256;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            this.__explicitlySet__.add("exitCode");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            this.__explicitlySet__.add("text");
            return this;
        }

        public Builder textSha256(String textSha256) {
            this.textSha256 = textSha256;
            this.__explicitlySet__.add("textSha256");
            return this;
        }

        public InstanceAgentCommandExecutionOutputViaTextDetails build() {
            InstanceAgentCommandExecutionOutputViaTextDetails model = new InstanceAgentCommandExecutionOutputViaTextDetails(this.exitCode, this.message, this.text, this.textSha256);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstanceAgentCommandExecutionOutputViaTextDetails model) {
            if (model.wasPropertyExplicitlySet("exitCode")) {
                this.exitCode(model.getExitCode());
            }
            if (model.wasPropertyExplicitlySet("message")) {
                this.message(model.getMessage());
            }
            if (model.wasPropertyExplicitlySet("text")) {
                this.text(model.getText());
            }
            if (model.wasPropertyExplicitlySet("textSha256")) {
                this.textSha256(model.getTextSha256());
            }
            return this;
        }
    }
}

