/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent;

import com.oracle.bmc.computeinstanceagent.Plugin;
import com.oracle.bmc.computeinstanceagent.model.InstanceAgentPluginSummary;
import com.oracle.bmc.computeinstanceagent.requests.ListInstanceAgentPluginsRequest;
import com.oracle.bmc.computeinstanceagent.responses.ListInstanceAgentPluginsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class PluginPaginators {
    private final Plugin client;

    public PluginPaginators(Plugin client) {
        this.client = client;
    }

    public Iterable<ListInstanceAgentPluginsResponse> listInstanceAgentPluginsResponseIterator(final ListInstanceAgentPluginsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListInstanceAgentPluginsRequest.Builder>(){

            @Override
            public ListInstanceAgentPluginsRequest.Builder get() {
                return ListInstanceAgentPluginsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListInstanceAgentPluginsResponse, String>(){

            @Override
            public String apply(ListInstanceAgentPluginsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListInstanceAgentPluginsRequest.Builder>, ListInstanceAgentPluginsRequest>(){

            @Override
            public ListInstanceAgentPluginsRequest apply(RequestBuilderAndToken<ListInstanceAgentPluginsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListInstanceAgentPluginsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListInstanceAgentPluginsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListInstanceAgentPluginsRequest, ListInstanceAgentPluginsResponse>(){

            @Override
            public ListInstanceAgentPluginsResponse apply(ListInstanceAgentPluginsRequest request) {
                return PluginPaginators.this.client.listInstanceAgentPlugins(request);
            }
        });
    }

    public Iterable<InstanceAgentPluginSummary> listInstanceAgentPluginsRecordIterator(final ListInstanceAgentPluginsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListInstanceAgentPluginsRequest.Builder>(){

            @Override
            public ListInstanceAgentPluginsRequest.Builder get() {
                return ListInstanceAgentPluginsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListInstanceAgentPluginsResponse, String>(){

            @Override
            public String apply(ListInstanceAgentPluginsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListInstanceAgentPluginsRequest.Builder>, ListInstanceAgentPluginsRequest>(){

            @Override
            public ListInstanceAgentPluginsRequest apply(RequestBuilderAndToken<ListInstanceAgentPluginsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListInstanceAgentPluginsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListInstanceAgentPluginsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListInstanceAgentPluginsRequest, ListInstanceAgentPluginsResponse>(){

            @Override
            public ListInstanceAgentPluginsResponse apply(ListInstanceAgentPluginsRequest request) {
                return PluginPaginators.this.client.listInstanceAgentPlugins(request);
            }
        }, (Function)new Function<ListInstanceAgentPluginsResponse, List<InstanceAgentPluginSummary>>(){

            @Override
            public List<InstanceAgentPluginSummary> apply(ListInstanceAgentPluginsResponse response) {
                return response.getItems();
            }
        });
    }
}

