/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.computeinstanceagent.PluginAsync;
import com.oracle.bmc.computeinstanceagent.model.InstanceAgentPlugin;
import com.oracle.bmc.computeinstanceagent.model.InstanceAgentPluginSummary;
import com.oracle.bmc.computeinstanceagent.requests.GetInstanceAgentPluginRequest;
import com.oracle.bmc.computeinstanceagent.requests.ListInstanceAgentPluginsRequest;
import com.oracle.bmc.computeinstanceagent.responses.GetInstanceAgentPluginResponse;
import com.oracle.bmc.computeinstanceagent.responses.ListInstanceAgentPluginsResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginAsyncClient
extends BaseAsyncClient
implements PluginAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("PLUGIN").serviceEndpointPrefix("").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(PluginAsyncClient.class);

    private PluginAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<GetInstanceAgentPluginResponse> getInstanceAgentPlugin(GetInstanceAgentPluginRequest request, AsyncHandler<GetInstanceAgentPluginRequest, GetInstanceAgentPluginResponse> handler) {
        Validate.notBlank((String)request.getInstanceagentId(), (String)"instanceagentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getPluginName(), (String)"pluginName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetInstanceAgentPluginResponse::builder).logger(LOG, "getInstanceAgentPlugin").serviceDetails("Plugin", "GetInstanceAgentPlugin", "https://docs.oracle.com/iaas/api/#/en/instanceagent/20180530/Plugin/GetInstanceAgentPlugin").method(Method.GET).requestBuilder(GetInstanceAgentPluginRequest::builder).basePath("/20180530").appendPathParam("instanceagents").appendPathParam(request.getInstanceagentId()).appendPathParam("plugins").appendPathParam(request.getPluginName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InstanceAgentPlugin.class, GetInstanceAgentPluginResponse.Builder::instanceAgentPlugin).handleResponseHeaderString("opc-request-id", GetInstanceAgentPluginResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListInstanceAgentPluginsResponse> listInstanceAgentPlugins(ListInstanceAgentPluginsRequest request, AsyncHandler<ListInstanceAgentPluginsRequest, ListInstanceAgentPluginsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getInstanceagentId(), (String)"instanceagentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListInstanceAgentPluginsResponse::builder).logger(LOG, "listInstanceAgentPlugins").serviceDetails("Plugin", "ListInstanceAgentPlugins", "https://docs.oracle.com/iaas/api/#/en/instanceagent/20180530/Plugin/ListInstanceAgentPlugins").method(Method.GET).requestBuilder(ListInstanceAgentPluginsRequest::builder).basePath("/20180530").appendPathParam("instanceagents").appendPathParam(request.getInstanceagentId()).appendPathParam("plugins").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("name", (Object)request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(InstanceAgentPluginSummary.class, ListInstanceAgentPluginsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListInstanceAgentPluginsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListInstanceAgentPluginsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Deprecated
    public PluginAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)PluginAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public PluginAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(PluginAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public PluginAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)PluginAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public PluginAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)PluginAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public PluginAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)PluginAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public PluginAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)PluginAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public PluginAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)PluginAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, PluginAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public PluginAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new PluginAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

